/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.system.sttest.utils;

import com.pivotal.gemfirexd.internal.tools.JDBCDisplayUtil;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Random;
import org.apache.derbyTesting.functionTests.util.streams.CharAlphabet;
import org.apache.derbyTesting.functionTests.util.streams.LoopingAlphabetReader;
import org.apache.derbyTesting.functionTests.util.streams.LoopingAlphabetStream;

public class Datatypes {
    public static final int TCHAR = 0;
    public static final int TBLOB = 1;
    public static final int TCLOB = 2;
    public static final int TDATE = 3;
    public static final int TDECIMAL = 4;
    public static final int TDECIMALNN = 5;
    public static final int TDOUBLE = 6;
    public static final int TFLOAT = 7;
    public static final int TINT = 8;
    public static final int TLONGINT = 9;
    public static final int TNUMERICLARGE = 10;
    public static final int TREAL = 11;
    public static final int TSMALLINT = 12;
    public static final int TTIME = 13;
    public static final int TTIMESTAMP = 14;
    public static final int TVARCHAR = 15;
    public static final int NUMTYPES = 15;
    public static Random Rn = new Random();
    public static String[] colnames = new String[]{"t_char", "t_blob", "t_clob", "t_date", "t_decimal", "t_decimal_nn", "t_double", "t_float", "t_int", "t_longint", "t_numeric_large", "t_real", "t_smallint", "t_time", "t_timestamp", "t_varchar"};

    public static synchronized void add_one_row(Connection conn, int thread_id) throws Exception {
        try {
            PreparedStatement ps = conn.prepareStatement(" insert into Datatypes (id,t_char,t_blob,t_clob, t_date, t_decimal, t_decimal_nn, t_double,  t_float, t_int, t_longint, t_numeric_large, t_real, t_smallint, t_time, t_timestamp, t_varchar) values ( ?,?, ?,?, ?, ?,?, ?, ?, ?,?, ?, ?, ?, ?, ?,?)", 1);
            LoopingAlphabetStream streamIn = null;
            LoopingAlphabetReader streamReader = null;
            int ind = Rn.nextInt();
            Date dt = new Date(1L);
            Time tt = new Time(1L);
            Timestamp ts = new Timestamp(1L);
            String cs = "asdf qwerqwer 12341234 ZXCVZXCVZXCV !@#$!@#$ asdfasdf 1 q a z asdf ASDF qwerasdfzxcvasdfqwer1234asd#";
            ps.setInt(1, ind);
            int i1 = Math.abs(ind % 100);
            String cs2 = cs.substring(i1, 99) + cs.substring(0, i1);
            int i2 = i1 < 89 ? i1 + 10 : i1;
            ps.setString(2, cs2.substring(0, i2));
            int blobLength = Rn.nextInt(102401) + 0;
            streamIn = new LoopingAlphabetStream(blobLength);
            ps.setBinaryStream(3, (InputStream)streamIn, blobLength);
            int clobLength = Rn.nextInt(102401) + 0;
            streamReader = new LoopingAlphabetReader((long)clobLength, CharAlphabet.modernLatinLowercase());
            ps.setCharacterStream(4, (Reader)streamReader, clobLength);
            dt.setTime(Math.abs(Rn.nextLong() / 150000L));
            ps.setDate(5, dt);
            double x = Math.abs(Rn.nextInt() % 18);
            if (x > 5.0) {
                x = 5.0;
            }
            ps.setDouble(6, Math.abs(Rn.nextDouble() * Math.pow(10.0, x)));
            ps.setDouble(7, Rn.nextDouble());
            ps.setDouble(8, Rn.nextDouble() * Math.pow(10.0, Math.abs(Rn.nextInt() % 300)));
            ps.setFloat(9, Rn.nextFloat() * (float)Math.pow(10.0, Math.abs(Rn.nextInt() % 30)));
            ps.setInt(10, Rn.nextInt());
            ps.setLong(11, Rn.nextLong());
            x = Math.abs(Rn.nextInt() % 30);
            if (x > 30.0) {
                x = 31.0;
            }
            ps.setDouble(12, Math.abs(Rn.nextDouble() * Math.pow(10.0, x)));
            ps.setFloat(13, Rn.nextFloat() * (float)Math.pow(10.0, Math.abs(Rn.nextInt() % 7)));
            ps.setInt(14, Rn.nextInt() % 32768);
            tt.setTime(Math.abs(Rn.nextInt()));
            ps.setTime(15, tt);
            ts.setTime(Math.abs(Rn.nextLong() / 50000L));
            ps.setTimestamp(16, ts);
            ps.setString(17, cs.substring(Math.abs(Rn.nextInt() % 100)));
            int rows = ps.executeUpdate();
            if (rows == 1) {
                ResultSet rs = ps.getGeneratedKeys();
                while (rs.next()) {
                    ResultSetMetaData rsmd = rs.getMetaData();
                    int n = rsmd.getColumnCount();
                }
            } else {
                System.out.println("t" + thread_id + " insert failed");
            }
            ((Reader)streamReader).close();
            streamIn.close();
        }
        catch (SQLException se) {
            if (se.getNextException() == null) {
                throw se;
            }
            String m = se.getNextException().getSQLState();
            System.out.println(se.getNextException().getMessage() + " SQLSTATE: " + m);
        }
    }

    public static int delete_some(Connection conn, int thread_id, int quantity) throws Exception {
        PreparedStatement ps = null;
        int[] list = Datatypes.pick_some(conn, thread_id, quantity);
        int rows = 0;
        try {
            ps = conn.prepareStatement(" delete from  Datatypes where id = ?");
            for (int i = 0; i < quantity; ++i) {
                ps.setInt(1, list[i]);
                rows += ps.executeUpdate();
            }
            if (ps != null) {
                ps.close();
            }
        }
        catch (SQLException se) {
            if (se.getNextException() == null) {
                throw se;
            }
            String m = se.getNextException().getSQLState();
            System.out.println(se.getNextException().getMessage() + " SQLSTATE: " + m);
            return rows;
        }
        conn.commit();
        return rows;
    }

    public static int[] pick_some(Connection conn, int thread_id, int quantity) throws Exception {
        System.out.println("quantity in pick_some is: " + quantity);
        int ind = 0;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            ps = conn.prepareStatement(" select id from  Datatypes where id = ?");
        }
        catch (SQLException se) {
            if (se.getNextException() == null) {
                throw se;
            }
            String m = se.getNextException().getSQLState();
            System.out.println(se.getNextException().getMessage() + " SQLSTATE: " + m);
            return null;
        }
        int[] list = new int[quantity];
        int j = 0;
        for (int i = 0; i < quantity; ++i) {
            ind = Rn.nextInt();
            try {
                ps.setInt(1, ind);
                rs = ps.executeQuery();
                if (rs.next()) {
                    j = rs.getInt(1);
                    if (rs.wasNull()) {
                        --i;
                        continue;
                    }
                    list[i] = j;
                }
                conn.commit();
                continue;
            }
            catch (SQLException se) {
                if (se.getNextException() == null) {
                    throw se;
                }
                String m = se.getNextException().getSQLState();
                System.out.println(se.getNextException().getMessage() + " SQLSTATE: " + m);
                return null;
            }
        }
        if (rs != null) {
            rs.close();
        }
        if (ps != null) {
            ps.close();
        }
        return list;
    }

    public static void delete_one_row(Connection conn, int thread_id) throws Exception {
        String m;
        PreparedStatement ps = null;
        PreparedStatement ps2 = null;
        String column = null;
        int ind = 0;
        ResultSet rs = null;
        ind = Math.abs(Rn.nextInt());
        while (ind % 15 == 4 || ind % 15 == 15 || ind % 15 == 0) {
            ind = Math.abs(Rn.nextInt());
        }
        column = colnames[ind % 15];
        try {
            ps = conn.prepareStatement(" select cast (max (" + column + ") as " + " char(120)) from Datatypes where " + column + " <= ? ");
            ps2 = conn.prepareStatement(" delete from  Datatypes where " + column + " = ?");
        }
        catch (SQLException se) {
            if (se.getNextException() == null) {
                throw se;
            }
            String m2 = se.getNextException().getSQLState();
            System.out.println(se.getNextException().getMessage() + " SQLSTATE: " + m2);
            return;
        }
        String ds = null;
        String cs = "asdf qwerqwer 12341234 ZXCVZXCVZXCV !@#$!@#$ asdfasdf 1 q a z asdf ASDF qwerasdfzxcvasdfqwer1234asd#";
        double d = 0.0;
        float f = 0.0f;
        BigDecimal bdec = null;
        switch (ind % 15) {
            case 0: {
                ds = cs.substring(Math.abs(Rn.nextInt() % 100));
                ps.setString(1, ds);
                break;
            }
            case 3: {
                Date dt = new Date(1L);
                dt.setTime(Math.abs(Rn.nextLong() / 150000L));
                ps.setString(1, dt.toString());
                ds = dt.toString();
                break;
            }
            case 4: {
                d = Rn.nextDouble() * Math.pow(10.0, Rn.nextInt() % 18);
                bdec = new BigDecimal(d);
                ps.setString(1, String.valueOf(bdec));
                ds = String.valueOf(d);
                break;
            }
            case 5: {
                d = Rn.nextDouble();
                bdec = new BigDecimal(d);
                ps.setString(1, String.valueOf(bdec));
                ds = String.valueOf(d);
                break;
            }
            case 6: {
                d = Rn.nextDouble() * Math.pow(10.0, Rn.nextInt() % 300);
                ps.setString(1, String.valueOf(d));
                ds = String.valueOf(d);
                break;
            }
            case 7: {
                f = Rn.nextFloat() * (float)Math.pow(10.0, Rn.nextInt() % 30);
                ps.setString(1, String.valueOf(f));
                ds = String.valueOf(f);
                break;
            }
            case 8: {
                ps.setString(1, String.valueOf(Rn.nextInt()));
                ds = String.valueOf(Rn.nextInt());
                break;
            }
            case 9: {
                ps.setString(1, String.valueOf(Rn.nextLong()));
                ds = String.valueOf(Rn.nextLong());
                break;
            }
            case 10: {
                d = Rn.nextDouble() * Math.pow(10.0, Rn.nextInt() % 50);
                bdec = new BigDecimal(d);
                ps.setString(1, String.valueOf(bdec));
                ds = String.valueOf(d);
                break;
            }
            case 11: {
                f = Rn.nextFloat() * (float)Math.pow(10.0, Rn.nextInt() % 7);
                ps.setString(1, String.valueOf(f));
                ds = String.valueOf(f);
                break;
            }
            case 12: {
                int i = Rn.nextInt() % 32768;
                ps.setString(1, String.valueOf(i));
                ds = String.valueOf(i);
                break;
            }
            case 13: {
                Time tt = new Time(1L);
                tt.setTime(Math.abs(Rn.nextInt()));
                ps.setString(1, "time'" + tt.toString() + "'");
                ds = "time'" + tt.toString() + "'";
                break;
            }
            case 14: {
                Timestamp ts = new Timestamp(1L);
                ts.setTime(Math.abs(Rn.nextLong() / 50000L));
                ps.setString(1, "timestamp'" + ts.toString() + "'");
                ds = "timestamp'" + ts.toString() + "'";
                break;
            }
            case 15: {
                ds = cs.substring(Math.abs(Rn.nextInt() % 100));
                ps.setString(1, ds);
            }
        }
        String ds3 = null;
        String ds4 = null;
        int rows = 0;
        boolean cleanuponly = false;
        try {
            rs = ps.executeQuery();
            if (rs.next()) {
                ds3 = rs.getString(1);
                if (rs.wasNull()) {
                    cleanuponly = true;
                } else {
                    ds3 = ds4 = ds3.trim();
                }
            }
        }
        catch (SQLException se) {
            if (se.getNextException() == null) {
                throw se;
            }
            m = se.getNextException().getSQLState();
            System.out.println(se.getNextException().getMessage() + " SQLSTATE: " + m);
        }
        if (ps != null) {
            try {
                ps.close();
            }
            catch (SQLException se) {
                if (se.getNextException() == null) {
                    throw se;
                }
                m = se.getNextException().getSQLState();
                System.out.println(se.getNextException().getMessage() + " SQLSTATE: " + m);
            }
        }
        if (rs != null) {
            try {
                rs.close();
            }
            catch (SQLException se) {
                if (se.getNextException() == null) {
                    throw se;
                }
                m = se.getNextException().getSQLState();
                System.out.println(se.getNextException().getMessage() + " SQLSTATE: " + m);
            }
        }
        if (!cleanuponly) {
            try {
                ps2.setString(1, ds3);
                rows = ps2.executeUpdate();
            }
            catch (SQLException se) {
                if (se.getNextException() == null) {
                    throw se;
                }
                m = se.getNextException().getSQLState();
                System.out.println(se.getNextException().getMessage() + " SQLSTATE: " + m);
            }
            if (rows < 0) {
                System.out.println("t" + thread_id + " delete failed.");
            }
        }
        if (ps2 != null) {
            try {
                ps2.close();
            }
            catch (SQLException se) {
                if (se.getNextException() == null) {
                    throw se;
                }
                m = se.getNextException().getSQLState();
                System.out.println(se.getNextException().getMessage() + " SQLSTATE: " + m);
            }
        }
    }

    public static synchronized void update_one_row(Connection conn, int thread_id) throws Exception {
        String m;
        PreparedStatement ps2 = null;
        Statement stmt = conn.createStatement();
        String column = null;
        int ind = 0;
        long max = 0L;
        long min = 0L;
        InputStream streamIn = null;
        Reader streamReader = null;
        ResultSet rs = stmt.executeQuery("select max(serialkey) from Datatypes");
        while (rs.next()) {
            max = rs.getLong(1);
        }
        rs = stmt.executeQuery("select min(serialkey) from Datatypes");
        while (rs.next()) {
            min = rs.getLong(1);
        }
        long id_to_update = min + 1L + Math.abs(Rn.nextLong()) % (max - min);
        if (id_to_update == 0L) {
            id_to_update = 1L;
        }
        ind = Math.abs(Rn.nextInt());
        column = colnames[ind % 15];
        try {
            conn.setTransactionIsolation(4);
            ps2 = conn.prepareStatement(" update Datatypes set " + column + " = ? " + " where serialkey = " + id_to_update);
        }
        catch (SQLException se) {
            if (se.getNextException() == null) {
                throw se;
            }
            String m2 = se.getNextException().getSQLState();
            return;
        }
        String ds = null;
        String ds2 = null;
        String cs = "asdf qwerqwer 12341234 ZXCVZXCVZXCV !@#$!@#$ asdfasdf 1 q a z asdf ASDF qwerasdfzxcvasdfqwer1234asd#";
        double d = 0.0;
        float f = 0.0f;
        BigDecimal bdec = null;
        int type = ind % 15;
        switch (type) {
            case 0: {
                ds2 = cs.substring(Math.abs(Rn.nextInt() % 100));
                ps2.setString(1, ds2);
                break;
            }
            case 3: {
                Date dt = new Date(1L);
                dt.setTime(Math.abs(Rn.nextLong() / 150000L));
                dt.setTime(Math.abs(Rn.nextLong() / 150000L));
                ps2.setDate(1, dt);
                ds2 = dt.toString();
                break;
            }
            case 4: {
                double x = Math.abs(Rn.nextInt() % 18);
                if (x > 5.0) {
                    x = 5.0;
                }
                d = Rn.nextDouble() * Math.pow(10.0, x);
                bdec = new BigDecimal(d);
                ps2.setBigDecimal(1, bdec);
                ds2 = String.valueOf(d);
                break;
            }
            case 5: {
                ds = String.valueOf(d);
                d = Rn.nextDouble();
                bdec = new BigDecimal(d);
                ps2.setBigDecimal(1, bdec);
                ds2 = String.valueOf(d);
                break;
            }
            case 6: {
                d = Rn.nextDouble() * Math.pow(10.0, Rn.nextInt() % 300);
                ps2.setDouble(1, d);
                ds2 = String.valueOf(d);
                break;
            }
            case 7: {
                ds = String.valueOf(f);
                f = Rn.nextFloat() * (float)Math.pow(10.0, Rn.nextInt() % 30);
                ps2.setFloat(1, f);
                ds2 = String.valueOf(f);
                break;
            }
            case 8: {
                int i = Rn.nextInt();
                ds2 = String.valueOf(i);
                ps2.setInt(1, i);
                break;
            }
            case 9: {
                long l = Rn.nextLong();
                ds2 = String.valueOf(l);
                ps2.setLong(1, l);
                break;
            }
            case 10: {
                ds = String.valueOf(d);
                double x = Math.abs(Rn.nextInt() % 30);
                if (x > 30.0) {
                    x = 31.0;
                }
                d = Rn.nextDouble() * Math.pow(10.0, x);
                bdec = new BigDecimal(d);
                ps2.setBigDecimal(1, bdec);
                ds2 = String.valueOf(d);
                break;
            }
            case 11: {
                ds = String.valueOf(f);
                f = Rn.nextFloat() * (float)Math.pow(10.0, Rn.nextInt() % 7);
                ps2.setFloat(1, f);
                ds2 = String.valueOf(f);
                break;
            }
            case 12: {
                int i = Rn.nextInt() % 32768;
                ds = String.valueOf(i);
                short si = (short)i;
                ps2.setShort(1, si);
                ds2 = String.valueOf(si);
                break;
            }
            case 13: {
                Time tt = new Time(1L);
                tt.setTime(Math.abs(Rn.nextInt()));
                ps2.setTime(1, tt);
                ds2 = tt.toString();
                break;
            }
            case 14: {
                Timestamp ts = new Timestamp(1L);
                ts.setTime(Math.abs(Rn.nextLong() / 50000L));
                ps2.setTimestamp(1, ts);
                ds2 = ts.toString();
                break;
            }
            case 15: {
                ds2 = cs.substring(Math.abs(Rn.nextInt() % 100));
                ps2.setString(1, ds2);
                break;
            }
            case 1: {
                int blobLength = Rn.nextInt(102401) + 0;
                streamIn = new LoopingAlphabetStream(blobLength);
                ps2.setBinaryStream(1, streamIn, blobLength);
                break;
            }
            case 2: {
                int clobLength = Rn.nextInt(102401) + 0;
                streamReader = new LoopingAlphabetReader((long)clobLength, CharAlphabet.modernLatinLowercase());
                ps2.setCharacterStream(1, streamReader, clobLength);
            }
        }
        int rows = 0;
        boolean cleanuponly = false;
        if (!cleanuponly) {
            try {
                rows = ps2.executeUpdate();
            }
            catch (SQLException se) {
                if (se.getNextException() == null) {
                    throw se;
                }
                m = se.getNextException().getSQLState();
                System.out.println(se.getNextException().getMessage() + " SQLSTATE: " + m);
            }
            if (rows < 0) {
                System.out.println("t" + thread_id + " update failed.");
            }
        }
        streamReader.close();
        streamIn.close();
        if (ps2 != null) {
            try {
                ps2.close();
                rs.close();
            }
            catch (SQLException se) {
                if (se.getNextException() == null) {
                    throw se;
                }
                m = se.getNextException().getSQLState();
                System.out.println(se.getNextException().getMessage() + " SQLSTATE: " + m);
            }
        }
    }

    public static synchronized int get_table_count(Connection conn) throws Exception {
        PreparedStatement ps = null;
        ResultSet rs = null;
        int rows = 0;
        boolean locked = false;
        int tick = 1;
        while (!locked) {
            try {
                Statement s = conn.createStatement();
                s.execute("lock table Datatypes in exclusive mode");
                s.close();
                locked = true;
            }
            catch (SQLException se) {
                if (se.getSQLState().equals("X0X02")) {
                    Thread.sleep(20000L);
                    if (tick++ < 60) {
                        System.out.println("count: cannot lock table, retrying " + tick + "\n");
                        continue;
                    }
                    System.out.println("count timed out\n");
                    return -1;
                }
                JDBCDisplayUtil.ShowException((PrintStream)System.out, (Throwable)se);
            }
        }
        try {
            ps = conn.prepareStatement(" select count (*) from Datatypes ");
            rs = ps.executeQuery();
            if (rs.next()) {
                rows = rs.getInt(1);
            }
            if (ps != null) {
                ps.close();
            }
        }
        catch (SQLException se) {
            if (se.getNextException() == null) {
                throw se;
            }
            String m = se.getNextException().getSQLState();
            System.out.println(se.getNextException().getMessage() + " SQLSTATE: " + m);
        }
        locked = true;
        return rows;
    }
}

