/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.system.oe.util;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Random;

public class OERandom {
    final Random rand;
    protected final int Clast;
    protected final int Cid;
    protected final int Citem;
    private static int[] RESCALE = new int[]{0, 10, 100, 1000, 10000, 100000, 1000000};
    private StringBuilder decimalString = new StringBuilder(12);
    private final String[] SYLLABLES = new String[]{"BAR", "OUGHT", "ABLE", "PRI", "PRES", "ESE", "ANTI", "CALLY", "ATION", "EING"};
    private static final String[] left24 = new String[10];
    private static final String[] left300 = new String[10];
    private static final String[] right200 = new String[10];
    private static final String[] left10 = new String[10];
    private static final String[] right10 = new String[10];
    private static final String[] left14 = new String[10];
    private static final String[] left26 = new String[10];
    private static final String[] right24 = new String[10];
    private static final String[] left8 = new String[10];
    private static final String[] right8 = new String[10];
    private static boolean doneInit;

    public OERandom(OERandom oer) {
        this.rand = new Random(System.currentTimeMillis() + oer.rand.nextLong());
        this.Clast = oer.Clast;
        this.Cid = oer.Cid;
        this.Citem = oer.Citem;
    }

    public OERandom(int last, long seed) {
        this.rand = new Random(seed);
        this.Clast = last;
        this.Cid = this.randomInt(0, 255);
        this.Citem = this.randomInt(0, 255);
        this.initAStrings();
    }

    public OERandom(int last) {
        this(last, System.currentTimeMillis());
    }

    public String randomDecimalString(int start, int end, int scale) {
        int val = this.randomInt(start, end);
        int whole = val / RESCALE[scale];
        int part = val % RESCALE[scale];
        this.decimalString.setLength(0);
        this.decimalString.append(whole);
        this.decimalString.append('.');
        int pos = this.decimalString.length();
        this.decimalString.append(part);
        int tempScale = this.decimalString.length() - pos;
        if (tempScale < scale) {
            for (int i = 0; i < scale - tempScale; ++i) {
                this.decimalString.insert(pos, '0');
            }
        }
        return this.decimalString.toString();
    }

    public BigDecimal payment() {
        return this.randomDecimal(1, 500000, 2);
    }

    public BigDecimal randomDecimal(int start, int end, int scale) {
        BigInteger bi = BigInteger.valueOf(this.randomInt(start, end));
        return new BigDecimal(bi, scale);
    }

    public int randomInt(int start, int end) {
        double drand = this.rand.nextDouble();
        double rrand = drand * (double)(end - start) + 0.5;
        return (int)rrand + start;
    }

    public short district() {
        return (short)this.randomInt(1, 10);
    }

    public short carrier() {
        return (short)this.randomInt(1, 10);
    }

    public int threshold() {
        return this.randomInt(10, 20);
    }

    public String randomAString(int min, int max) {
        int len = this.randomInt(min, max);
        char[] c = new char[len];
        block22: for (int i = 0; i < len; ++i) {
            double drand = this.rand.nextDouble();
            if (i == 0) {
                if (drand < 2.0) {
                    c[0] = (char)this.randomInt(65, 90);
                    continue;
                }
                switch (this.randomInt(1, 10)) {
                    case 1: {
                        c[0] = 192;
                        break;
                    }
                    case 2: {
                        c[0] = 193;
                        break;
                    }
                    case 3: {
                        c[0] = 194;
                        break;
                    }
                    case 4: {
                        c[0] = 202;
                        break;
                    }
                    case 5: {
                        c[0] = 203;
                        break;
                    }
                    case 6: {
                        c[0] = 212;
                        break;
                    }
                    case 7: {
                        c[0] = 216;
                        break;
                    }
                    case 8: {
                        c[0] = 209;
                        break;
                    }
                    case 9: {
                        c[0] = 205;
                        break;
                    }
                    default: {
                        c[0] = 220;
                        break;
                    }
                }
                continue;
            }
            if (drand < 2.0) {
                c[i] = (char)this.randomInt(97, 122);
                continue;
            }
            switch (this.randomInt(1, 10)) {
                case 1: {
                    c[i] = 226;
                    continue block22;
                }
                case 2: {
                    c[i] = 228;
                    continue block22;
                }
                case 3: {
                    c[i] = 231;
                    continue block22;
                }
                case 4: {
                    c[i] = 232;
                    continue block22;
                }
                case 5: {
                    c[i] = 236;
                    continue block22;
                }
                case 6: {
                    c[i] = 239;
                    continue block22;
                }
                case 7: {
                    c[i] = 246;
                    continue block22;
                }
                case 8: {
                    c[i] = 249;
                    continue block22;
                }
                case 9: {
                    c[i] = 252;
                    continue block22;
                }
                default: {
                    c[i] = 229;
                }
            }
        }
        return new String(c);
    }

    public String randomNString(int min, int max) {
        int len = this.randomInt(min, max);
        char[] c = new char[len];
        for (int i = 0; i < len; ++i) {
            c[i] = (char)this.randomInt(48, 57);
        }
        return new String(c);
    }

    protected String randomCLast(int n) {
        return this.SYLLABLES[n / 100] + this.SYLLABLES[n / 10 % 10] + this.SYLLABLES[n % 10];
    }

    public String randomZIP() {
        return this.randomNString(4, 4) + "11111";
    }

    public int NURand8191() {
        int l = this.randomInt(0, 8191);
        int r = this.randomInt(1, 100000);
        int C = this.randomInt(0, 8191);
        return ((l | r) + C) % 100000 + 1;
    }

    public int NURand1023() {
        int l = this.randomInt(0, 1023);
        int r = this.randomInt(1, 3000);
        int C = this.randomInt(0, 1023);
        return ((l | r) + C) % 3000 + 1;
    }

    public int NURand255() {
        int l = this.randomInt(0, 255);
        int r = this.randomInt(0, 999);
        int C = this.randomInt(0, 255);
        return ((l | r) + C) % 1000 + 0;
    }

    public String randomState() {
        StringBuilder s = new StringBuilder(2);
        for (int i = 0; i < 2; ++i) {
            s.append((char)this.randomInt(65, 90));
        }
        return s.toString();
    }

    public String randomCLastPopulate(int cid) {
        if (cid <= 1000) {
            return this.randomCLast(cid - 1);
        }
        return this.randomCLast(this.NURand255());
    }

    public String randomCLast() {
        return this.randomCLast(this.NURand255());
    }

    public String randomData() {
        String s = this.randomAString26_50();
        if (this.rand.nextDouble() < 0.9) {
            return s;
        }
        int pos = this.randomInt(0, s.length() - 9);
        if (pos == 0) {
            return "ORIGINAL" + s.substring(8);
        }
        if (pos == s.length() - 9) {
            return s.substring(0, s.length() - 9) + "ORIGINAL";
        }
        return s.substring(0, pos) + "ORIGINAL" + s.substring(pos + 8, s.length());
    }

    public int[] randomIntPerm(int count) {
        int[] data = new int[count];
        for (int i = 0; i < count; ++i) {
            data[i] = i + 1;
        }
        for (int j = 0; j < count * 4; ++j) {
            int a = this.randomInt(0, count - 1);
            int b = this.randomInt(0, count - 1);
            int val = data[a];
            data[a] = data[b];
            data[b] = val;
        }
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initAStrings() {
        String[] stringArray = left24;
        synchronized (left24) {
            if (doneInit) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            for (int i = 0; i < 10; ++i) {
                OERandom.left24[i] = this.randomAString(24, 24);
                OERandom.left300[i] = this.randomAString(300, 300);
                OERandom.right200[i] = this.randomAString(0, 200);
                OERandom.left10[i] = this.randomAString(10, 10);
                OERandom.right10[i] = this.randomAString(0, 10);
                OERandom.left14[i] = this.randomAString(10, 10);
                OERandom.left26[i] = this.randomAString(26, 26);
                OERandom.right24[i] = this.randomAString(0, 24);
                OERandom.left8[i] = this.randomAString(8, 8);
                OERandom.right8[i] = this.randomAString(0, 8);
            }
            doneInit = true;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public String randomAString24() {
        return left24[this.randomInt(0, 9)];
    }

    public String randomAString300_500() {
        String l = left300[this.randomInt(0, 9)];
        String r = right200[this.randomInt(0, 9)];
        return l.concat(r);
    }

    public String randomAString10_20() {
        String l = left10[this.randomInt(0, 9)];
        String r = right10[this.randomInt(0, 9)];
        return l.concat(r);
    }

    public String randomAString14_24() {
        String l = left14[this.randomInt(0, 9)];
        String r = right10[this.randomInt(0, 9)];
        return l.concat(r);
    }

    public String randomAString26_50() {
        String l = left26[this.randomInt(0, 9)];
        String r = right24[this.randomInt(0, 9)];
        return l.concat(r);
    }

    public String randomAString8_16() {
        String l = left8[this.randomInt(0, 9)];
        String r = right8[this.randomInt(0, 9)];
        return l.concat(r);
    }
}

