/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.system.oe.direct;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.IdentityHashMap;
import java.util.Map;
import org.apache.derbyTesting.system.oe.model.Address;

class StatementHelper {
    protected final Connection conn;
    private Map statements = new IdentityHashMap();

    StatementHelper(Connection conn, boolean autoCommit, int isolation) throws SQLException {
        this.conn = conn;
        conn.setAutoCommit(autoCommit);
        conn.setTransactionIsolation(isolation);
    }

    protected PreparedStatement prepareStatement(String sql) throws SQLException {
        PreparedStatement ps = (PreparedStatement)this.statements.get(sql);
        if (ps != null) {
            return ps;
        }
        ps = this.conn.prepareStatement(sql, 1003, 1007, 2);
        this.statements.put(sql, ps);
        return ps;
    }

    public void close() throws SQLException {
        for (String sql : this.statements.keySet()) {
            PreparedStatement ps = (PreparedStatement)this.statements.get(sql);
            ps.close();
        }
    }

    protected void reset(PreparedStatement ps) throws SQLException {
        ResultSet rs = ps.getResultSet();
        if (rs != null) {
            rs.close();
        }
        ps.clearParameters();
    }

    protected Address getAddress(ResultSet rs, String firstColumnName) throws SQLException {
        return this.getAddress(new Address(), rs, firstColumnName);
    }

    protected Address getAddress(Address address, ResultSet rs, String firstColumnName) throws SQLException {
        address.clear();
        int col = rs.findColumn(firstColumnName);
        address.setStreet1(rs.getString(col++));
        address.setStreet2(rs.getString(col++));
        address.setCity(rs.getString(col++));
        address.setState(rs.getString(col++));
        address.setZip(rs.getString(col));
        return address;
    }
}

