/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.system.nstest.tester;

import org.apache.derbyTesting.system.nstest.NsTest;
import org.apache.derbyTesting.system.nstest.tester.TesterObject;

public class Tester1
extends TesterObject {
    public Tester1(String name) {
        super(name);
    }

    @Override
    public void startTesting() {
        this.connex = this.getConnection();
        if (this.connex == null) {
            System.out.println("FAIL: " + this.getThread_id() + " could not get the database connection");
            return;
        }
        try {
            this.connex.setAutoCommit(false);
        }
        catch (Exception e) {
            System.out.println("FAIL: " + this.getThread_id() + "'s setAutoCommit() failed:");
            this.printException("setting AutoCommit", e);
        }
        this.setIsolationLevel(1);
        for (int i = 0; i < NsTest.MAX_ITERATIONS; ++i) {
            int rnum = (int)(Math.random() * 100.0) % 4;
            switch (rnum) {
                case 0: {
                    try {
                        int numSelected = this.doSelectOperation(NsTest.MAX_LOW_STRESS_ROWS);
                        System.out.println(this.getThread_id() + " selected " + numSelected + " rows");
                    }
                    catch (Exception e) {
                        System.out.println("--> Isolation Level is TRANSACTION_READ_UNCOMMITTED, hence SHOULD NOT FAIL ********* doSelect in thread " + this.getThread_id() + " threw " + e);
                        this.printException("doSelectOperation()", e);
                        e.printStackTrace();
                    }
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    for (int j = 0; j < NsTest.MAX_LOW_STRESS_ROWS; ++j) {
                        this.doIUDOperation();
                    }
                    break;
                }
            }
            try {
                this.connex.commit();
                continue;
            }
            catch (Exception e) {
                System.out.println("FAIL: " + this.getThread_id() + "'s commit() failed:");
                this.printException("committing Xn in Tester1", e);
            }
        }
        this.closeConnection();
        System.out.println("Thread " + this.getThread_id() + " is now terminating");
    }
}

