/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.system.nstest.tester;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.derbyTesting.system.nstest.NsTest;
import org.apache.derbyTesting.system.nstest.tester.TesterObject;

public class BackupRestoreReEncryptTester
extends TesterObject {
    String logFile = "backup.log";
    PrintWriter logger = new PrintWriter(new FileWriter(this.logFile));

    public BackupRestoreReEncryptTester(String name) throws IOException {
        super(name);
    }

    @Override
    public void startTesting() {
        for (int i = 0; i < NsTest.MAX_ITERATIONS; ++i) {
            this.log(this.getTimestamp() + " Thread " + this.getThread_id() + " starting");
            String message = "";
            this.connex = this.getConnection();
            if (this.connex == null) {
                System.out.println("FAIL: " + this.getThread_id() + " could not get the database connection");
                return;
            }
            this.setIsolationLevel(1);
            try {
                this.doBackup();
            }
            catch (Exception e) {
                message = this.getTimestamp() + "FAILED - BackUp thread doBackup" + this.getThread_id() + " threw " + e;
                System.out.println(message);
                this.log(message);
                this.printException("call to doBackup() in BackupThread ", e);
                e.printStackTrace();
            }
            try {
                this.doRestoreandReEncrypt();
            }
            catch (SQLException e) {
                e.printStackTrace();
                System.out.println("FAILED at doRestoreandReEncrypt() - BackUp thread " + this.getThread_id() + " threw " + e);
                this.printException("call to doRestoreandReEncrypt() in BackupThread ", e);
                this.log(this.getTimestamp() + " call to doRestoreandReEncrypt() in BackupThread FAILED " + e.getSQLState() + " " + e);
                e.printStackTrace(this.logger);
            }
            this.closeConnection();
            try {
                this.log(this.getTimestamp() + " Thread " + this.getThread_id() + " sleeping");
                Thread.sleep(600000L);
                continue;
            }
            catch (InterruptedException ie) {
                message = this.getTimestamp() + "FAILED - " + this.getThread_id() + " Sleep interrupted " + ie;
                this.log(message);
            }
        }
        System.out.println("Thread " + this.getThread_id() + " is now terminating");
    }

    public void doBackup() throws SQLException {
        this.log("--------------------- B A C K U P  S E C T I O N  B E G I N ------------------------");
        CallableStatement cs = this.connex.prepareCall("CALL SYSCS_UTIL.BACKUP_DATABASE_AND_ENABLE_LOG_ARCHIVE_MODE_NOWAIT(?, ?)");
        cs.setString(1, NsTest.BACKUPDIR);
        cs.setInt(2, 1);
        long start = System.currentTimeMillis();
        cs.execute();
        cs.close();
        long end = System.currentTimeMillis();
        this.log(this.getTimestamp() + " Backup completed successfully in " + (end - start) / 100L + " seconds");
        try {
            String backupDbURL = NsTest.getDriverURL() + NsTest.BACKUPDIR + File.separator + "nstestdb" + ";" + "bootPassword=12345678";
            this.doConsistCheck(backupDbURL, "BACKUP");
        }
        catch (Exception e) {
            String message = this.getTimestamp() + "FAILED - BackUp thread doConsistCheck() " + this.getThread_id() + " threw " + e;
            this.log(message);
            this.printException("call to doConsistCheck() in BackupThread ", e);
            e.printStackTrace(this.logger);
        }
        this.log("--------------------- B A C K U P  S E C T I O N  E N D ----------------------------");
    }

    public void doConsistCheck(String dbURL, String dbType) throws SQLException {
        Connection conn = DriverManager.getConnection(dbURL);
        Statement stmt = conn.createStatement();
        long start = System.currentTimeMillis();
        ResultSet rs = stmt.executeQuery("SELECT schemaname, tablename,\tSYSCS_UTIL.CHECK_TABLE(schemaname, tablename)\tFROM sys.sysschemas s, sys.systables t\tWHERE s.schemaid = t.schemaid");
        while (rs.next()) {
            rs.getString(1);
            rs.getString(2);
            rs.getString(3);
        }
        long end = System.currentTimeMillis();
        this.log(this.getTimestamp() + " Consistency Check on the " + dbType + " database Completed successfully " + (end - start) / 100L + " seconds");
        stmt.close();
        conn.close();
        this.shutDownDB(dbURL, dbType);
    }

    public void doRestoreandReEncrypt() throws SQLException {
        this.log("--------------------- R E S T O R E   S E C T I O N  B E G I N ------------------------");
        String dbType = "RESTORED";
        Connection conn = null;
        long newKey = System.currentTimeMillis();
        String restoreDbURL = NsTest.getDriverURL() + NsTest.RESTOREDIR + File.separator + "nstestdb";
        String dbUrl = restoreDbURL + ";" + "bootPassword=12345678" + ";restoreFrom=" + NsTest.BACKUPDIR + File.separator + "nstestdb";
        try {
            conn = DriverManager.getConnection(dbUrl);
            this.log(this.getTimestamp() + " Database restored successfully " + dbUrl);
        }
        catch (SQLException e) {
            this.log(this.getTimestamp() + " FAILURE ! to restore database " + dbUrl);
            e.printStackTrace(this.logger);
        }
        conn.close();
        dbUrl = restoreDbURL + ";" + "bootPassword=12345678";
        this.doConsistCheck(dbUrl, dbType);
        this.log("--------------------- R E S T O R E   S E C T I O N  E N D ----------------------------");
        conn = DriverManager.getConnection(dbUrl);
        CallableStatement cs = conn.prepareCall("CALL SYSCS_UTIL.DISABLE_LOG_ARCHIVE_MODE(?)");
        cs.setInt(1, 1);
        cs.execute();
        conn.close();
        this.log(this.getTimestamp() + " Disable log archival mode to enable re-encryption " + dbUrl);
        this.shutDownDB(restoreDbURL, dbType);
        this.log("--------------------- ENCRYPT AND RECONNECT  S E C T I O N  BEGIN ------------------------");
        String encryptDbURL = restoreDbURL + ";dataEncryption=true;";
        encryptDbURL = encryptDbURL + ";bootPassword=12345678;newBootPassword=" + newKey;
        long start = System.currentTimeMillis();
        this.log(this.getTimestamp() + " Encrypting database, url = " + encryptDbURL);
        conn = DriverManager.getConnection(encryptDbURL);
        conn.close();
        long end = System.currentTimeMillis();
        this.log(this.getTimestamp() + " Re-encryption completed on restored database in " + (end - start) / 100L + " seconds, url = " + encryptDbURL);
        dbType = "ENCRYPTED";
        this.shutDownDB(restoreDbURL, dbType);
        try {
            conn = DriverManager.getConnection(dbUrl);
            this.log(this.getTimestamp() + " FAILURE ! - Attempt to boot with old password/url should have failed, url =" + dbUrl);
        }
        catch (SQLException sqe) {
            if (sqe.getSQLState().equalsIgnoreCase("XJ040") || sqe.getSQLState().equalsIgnoreCase("XBM06")) {
                this.log(this.getTimestamp() + " PASS - Unsuccessful attempt to boot with old password/url, " + dbUrl);
            }
            throw sqe;
        }
        this.log("--------------------- ENCRYPT AND RECONNECT  S E C T I O N  END --------------------------");
    }

    private void shutDownDB(String dbURL, String dbType) throws SQLException {
        Connection conn = null;
        dbURL = dbURL + ";shutdown=true";
        try {
            conn = DriverManager.getConnection(dbURL);
        }
        catch (SQLException sqe) {
            if (conn != null) {
                conn.close();
            }
            if (!sqe.getSQLState().equalsIgnoreCase("08006")) {
                throw sqe;
            }
            this.log(this.getTimestamp() + " " + dbType + " database shutdown completed, url = " + dbURL);
        }
    }

    public void log(String msg) {
        this.logger.write(msg + "\n");
        this.logger.flush();
        System.out.println(msg);
    }
}

