/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.system.nstest;

import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;
import org.apache.derbyTesting.system.nstest.init.DbSetup;
import org.apache.derbyTesting.system.nstest.init.Initializer;
import org.apache.derbyTesting.system.nstest.init.NWServerThread;
import org.apache.derbyTesting.system.nstest.tester.BackupRestoreReEncryptTester;
import org.apache.derbyTesting.system.nstest.tester.Tester1;
import org.apache.derbyTesting.system.nstest.tester.Tester2;
import org.apache.derbyTesting.system.nstest.tester.Tester3;
import org.apache.derbyTesting.system.nstest.utils.MemCheck;

public class NsTest
extends Thread {
    public static final String dbName = "nstestdb";
    public static final String user = "nstest";
    public static final String password = "nstest";
    public static final String clientURL = "jdbc:derby://localhost:1900/";
    public static final String embedURL = "jdbc:derby:";
    public static final String dataEncypt = "dataEncryption=true";
    public static final String bootPwd = "bootPassword=12345678";
    public static final String clientDbURL = new String("jdbc:derby://localhost:1900/nstestdb;create=true");
    public static final String retrieveMessagePart = "retrieveMessagesFromServerOnGetMessage=true;";
    public static final String embedDbURL = new String("jdbc:derby:nstestdb;create=true");
    public static boolean embeddedMode = false;
    public static final String driver = new String("com.pivotal.gemfirexd.jdbc.ClientDriver");
    public static final String embedDriver = new String("com.pivotal.gemfirexd.jdbc.EmbeddedDriver");
    public static Properties prop = new Properties();
    public static int INIT = 0;
    public static int TESTER1 = 1;
    public static int TESTER2 = 2;
    public static int TESTER3 = 3;
    public static int BACKUP = 4;
    public static String BACKUPDIR = "backupdir";
    public static String RESTOREDIR = "restoredir";
    public static boolean START_SERVER_IN_SAME_VM = false;
    public static boolean AUTO_COMMIT_OFF = false;
    public static boolean CREATE_DATABASE_ONLY = false;
    public static boolean schemaCreated = false;
    public static int INIT_THREADS = 6;
    public static int MAX_INITIAL_ROWS = 6000;
    public static int MAX_ITERATIONS = 2000;
    public static int MAX_LOW_STRESS_ROWS = 30;
    public static int MAX_OPERATIONS_PER_CONN = 25;
    public static int NUMTESTER1 = 15;
    public static int NUMTESTER2 = 45;
    public static int NUMTESTER3 = 10;
    public static int NUM_HIGH_STRESS_ROWS = 25000;
    public static int NUM_UNTOUCHED_ROWS = 6000;
    public static int numInserts = 0;
    public static int numUpdates = 0;
    public static int numDeletes = 0;
    public static int numSelects = 0;
    public static int numFailedInserts = 0;
    public static int numFailedUpdates = 0;
    public static int numFailedDeletes = 0;
    public static int numFailedSelects = 0;
    public static int numConnections = 0;
    public static int INSERT = 0;
    public static int UPDATE = 1;
    public static int DELETE = 2;
    public static int SELECT = 3;
    public static int FAILED_INSERT = 4;
    public static int FAILED_UPDATE = 5;
    public static int FAILED_DELETE = 6;
    public static int FAILED_SELECT = 7;
    public static int CONNECTIONS_MADE = 8;
    public static final String SUCCESS = " *** SUCCESS *** ";
    public static String driver_type = null;
    private int type;

    public static synchronized void addStats(int type, int addValue) {
        switch (type) {
            case 0: {
                numInserts += addValue;
                break;
            }
            case 1: {
                numUpdates += addValue;
                break;
            }
            case 2: {
                numDeletes += addValue;
                break;
            }
            case 3: {
                numSelects += addValue;
                break;
            }
            case 4: {
                numFailedInserts += addValue;
                break;
            }
            case 5: {
                numFailedUpdates += addValue;
                break;
            }
            case 6: {
                numFailedDeletes += addValue;
                break;
            }
            case 7: {
                numFailedSelects += addValue;
                break;
            }
            case 8: {
                numConnections += addValue;
            }
        }
    }

    NsTest(int ttype, int k) throws Exception {
        this.type = ttype;
        if (ttype == INIT) {
            this.setName("InitThread " + k);
        } else if (ttype == TESTER1 || ttype == TESTER2 || ttype == TESTER3) {
            this.setName("Thread " + k);
        }
    }

    public static void main(String[] args) throws SQLException, IOException, InterruptedException, Exception, Throwable {
        Connection conn = null;
        if (args.length == 1) {
            driver_type = args[0];
            if (!driver_type.equalsIgnoreCase("DerbyClient") && !driver_type.equalsIgnoreCase("Embedded")) {
                NsTest.printUsage();
                return;
            }
            System.out.println("Test nstest starting....., using driver: " + driver_type);
        } else {
            driver_type = "DerbyClient";
        }
        String jdbcUrl = "";
        try {
            if (driver_type.equalsIgnoreCase("Embedded")) {
                System.out.println("Loading the embedded driver...");
                Class.forName(embedDriver).newInstance();
                jdbcUrl = embedDbURL + ";" + dataEncypt + ";" + bootPwd;
                embeddedMode = true;
            } else {
                System.out.println("Driver type : " + driver_type);
                System.out.println("Loading the Derby Client driver..." + driver);
                Class.forName(driver).newInstance();
                System.out.println("Client Driver loaded");
                jdbcUrl = clientDbURL + ";" + dataEncypt + ";" + bootPwd;
            }
            if (!embeddedMode && START_SERVER_IN_SAME_VM) {
                NsTest.startNetworkServer();
            }
            prop.setProperty("user", "nstest");
            prop.setProperty("password", "nstest");
            System.out.println("Getting a connection using the url: " + jdbcUrl);
            System.out.println("JDBC url= " + jdbcUrl);
            conn = DriverManager.getConnection(jdbcUrl, prop);
        }
        catch (SQLException sqe) {
            System.out.println("\n\n " + sqe + sqe.getErrorCode() + " " + sqe.getSQLState());
            if (sqe.getErrorCode() == 40000 || sqe.getSQLState().equalsIgnoreCase("08001")) {
                System.out.println("\n Unable to connect, test cannot proceed. Please verify if the Network Server is started on port 1900.");
                return;
            }
        }
        catch (ClassNotFoundException cnfe) {
            System.out.println("Driver not found: " + cnfe.getMessage());
            cnfe.printStackTrace();
            return;
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("Unexpected Failure");
            NsTest.printException("nstest.main() method ==> ", e);
        }
        if (!DbSetup.doIt(conn)) {
            System.out.println("Error in dbSetup, test will exit");
            System.exit(1);
        }
        try {
            conn.close();
        }
        catch (Exception e) {
            System.out.println("FAIL - Error closing the connection in nstest.main():");
            NsTest.printException("Closing connection in nstest.main()", e);
        }
        System.out.println("Starting memory checker thread");
        MemCheck mc = new MemCheck(200000);
        mc.start();
        if (!schemaCreated) {
            int i;
            System.out.println("Kicking off initialization threads that will populate the test table");
            NsTest[] initThreads = new NsTest[INIT_THREADS];
            for (i = 0; i < INIT_THREADS; ++i) {
                initThreads[i] = new NsTest(INIT, i);
                initThreads[i].start();
                NsTest.sleep(3000L);
            }
            for (i = 0; i < INIT_THREADS; ++i) {
                initThreads[i].join();
            }
        }
        if (schemaCreated) {
            System.out.println("Schema has already been created by another process!");
        }
        if (CREATE_DATABASE_ONLY) {
            System.out.println("Finished creating the database, TEST THREADS WILL NOT RUN!!");
            mc.stopNow = true;
            mc.join();
            return;
        }
        System.out.println("Kicking off test threads that will work over the test table");
        int numTestThread = 0;
        int maxTestThreads = 1 + NUMTESTER1 + NUMTESTER2 + NUMTESTER3;
        NsTest[] testThreads = new NsTest[maxTestThreads];
        while (numTestThread < maxTestThreads) {
            int j;
            String runBackup = System.getProperty("derby.nstest.backupRestore");
            if (runBackup != null && runBackup.equalsIgnoreCase("false")) {
                System.out.println("BackupRestore Thread not started...");
            } else {
                testThreads[numTestThread] = new NsTest(BACKUP, numTestThread);
                testThreads[numTestThread].start();
                ++numTestThread;
            }
            for (j = 0; j < NUMTESTER1; ++j) {
                testThreads[numTestThread] = new NsTest(TESTER1, numTestThread);
                testThreads[numTestThread].start();
                NsTest.sleep(3000L);
                ++numTestThread;
            }
            for (j = 0; j < NUMTESTER2; ++j) {
                testThreads[numTestThread] = new NsTest(TESTER2, numTestThread);
                testThreads[numTestThread].start();
                NsTest.sleep(3000L);
                ++numTestThread;
            }
            for (j = 0; j < NUMTESTER3; ++j) {
                testThreads[numTestThread] = new NsTest(TESTER3, numTestThread);
                testThreads[numTestThread].start();
                NsTest.sleep(3000L);
                ++numTestThread;
            }
        }
        for (int j = 0; j < maxTestThreads; ++j) {
            System.out.println("Waiting for thread " + j + " to join back/finish");
            testThreads[j].join();
        }
        System.out.println("");
        System.out.println("STATISTICS OF OPERATIONS DONE");
        System.out.println("-----------------------------");
        System.out.println("");
        System.out.println("SUCCESSFUL: ");
        System.out.println("\tNumber of INSERTS = " + numInserts);
        System.out.println("\tNumber of UPDATES = " + numUpdates);
        System.out.println("\tNumber of DELETES = " + numDeletes);
        System.out.println("\tNumber of SELECTS = " + numSelects);
        System.out.println("");
        System.out.println("FAILED: ");
        System.out.println("\tNumber of failed INSERTS = " + numFailedInserts);
        System.out.println("\tNumber of failed UPDATES = " + numFailedUpdates);
        System.out.println("\tNumber of failed DELETES = " + numFailedDeletes);
        System.out.println("\tNumber of failed SELECTS = " + numFailedSelects);
        System.out.println("");
        System.out.println("  Note that this may not be the same as the server side connections made    to the database especially if connection pooling is employed");
        System.out.println("");
        System.out.println("NOTE: Failing operations could be because of locking issue that are directly related to the application logic.  They are not necessarily bugs.");
        mc.stopNow = true;
        mc.join();
        System.out.println("End of test nstest! Look for 'FAIL' messages in the output and gemfirexd.log");
    }

    @Override
    public void run() {
        System.out.println(this.getName() + " is now running");
        if (this.type == INIT) {
            Initializer Init = new Initializer(this.getName());
            Init.startInserts();
        } else if (this.type == TESTER1) {
            Tester1 Tstr1 = new Tester1("Tester1" + this.getName());
            Tstr1.startTesting();
        } else if (this.type == TESTER2) {
            Tester2 Tstr2 = new Tester2("Tester2" + this.getName());
            Tstr2.startTesting();
        } else if (this.type == TESTER3) {
            Tester3 Tstr3 = new Tester3("Tester3" + this.getName());
            Tstr3.startTesting();
        } else if (this.type == BACKUP) {
            BackupRestoreReEncryptTester Tstr4 = null;
            try {
                Tstr4 = new BackupRestoreReEncryptTester("BackupRestoreReEncrypt" + this.getName());
            }
            catch (IOException ioe) {
                System.out.println(ioe + "=====> Unable to create backup log file, test cannot proceed ");
                ioe.printStackTrace();
                return;
            }
            Tstr4.startTesting();
        } else {
            System.out.println("FAIL: Invalid thread type, should be INIT or TESTERx or BACKUP");
            System.out.println("You should check the code and restart");
            return;
        }
        System.out.println(this.getName() + " finished and is now exiting");
    }

    public static synchronized void printException(String where, Exception e) {
        if (e instanceof SQLException) {
            SQLException se = (SQLException)e;
            if (se.getSQLState() != null) {
                if (se.getSQLState().equals("40001")) {
                    System.out.println("deadlocked detected");
                }
                if (se.getSQLState().equals("40XL1")) {
                    System.out.println(" lock timeout exception");
                }
                if (se.getSQLState().equals("23500")) {
                    System.out.println(" duplicate key violation");
                }
            }
            if (se.getNextException() != null) {
                String m = se.getNextException().getSQLState();
                System.out.println(se.getNextException().getMessage() + " SQLSTATE: " + m);
            }
        }
        if (e.getMessage().equals(null)) {
            System.out.println("NULL error message detected");
            System.out.println("Here is the NULL exection - " + e.toString());
            System.out.println("Stack trace of the NULL exception - ");
            e.printStackTrace(System.out);
        }
        System.out.println("At this point - " + where + ", exception thrown was : " + e.getMessage());
    }

    public static String getDriverURL() {
        if (driver_type.equalsIgnoreCase("DerbyClient")) {
            return clientURL;
        }
        return embedURL;
    }

    public static void startNetworkServer() throws Exception {
        try {
            NWServerThread nsw = new NWServerThread("localhost", 1900);
            nsw.start();
            Thread.sleep(10000L);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    public static void printUsage() {
        System.out.println("Usage:");
        System.out.println("java org.apache.derbyTesting.system.nstest.NsTest DerbyClient|Embedded");
        System.out.println("\nNo argument/Default value is 'DerbyClient'");
    }
}

