/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.system.mailjdbc.utils;

import com.pivotal.gemfirexd.internal.tools.ij;
import java.io.File;
import java.io.InputStream;
import java.io.Reader;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Random;
import org.apache.derbyTesting.functionTests.util.streams.CharAlphabet;
import org.apache.derbyTesting.functionTests.util.streams.LoopingAlphabetReader;
import org.apache.derbyTesting.functionTests.util.streams.LoopingAlphabetStream;
import org.apache.derbyTesting.system.mailjdbc.MailJdbc;
import org.apache.derbyTesting.system.mailjdbc.utils.LogFile;
import org.apache.derbyTesting.system.mailjdbc.utils.PerfTime;
import org.apache.derbyTesting.system.mailjdbc.utils.Statements;

public class DbTasks {
    public static LogFile log = new LogFile("performance.out");
    static boolean saveAutoCommit;
    private static int id_count;
    public static int insert_count;
    public static int delete_count;
    public static int clob_count;
    public static int blob_count;
    public static Random Rn;

    public static void jdbcLoad(String driverType) {
        if (driverType.equalsIgnoreCase("embedded")) {
            DbTasks.setSystemProperty("driver", "com.pivotal.gemfirexd.jdbc.EmbeddedDriver");
            MailJdbc.logAct.logMsg(" \n*****************************************************");
            MailJdbc.logAct.logMsg("\n\n\tStarting the test in Embedded mode");
            MailJdbc.logAct.logMsg("\n\n*****************************************************");
            DbTasks.setSystemProperty("database", "jdbc:derby:mailsdb;create=true");
            DbTasks.setSystemProperty("ij.user", "REFRESH");
            DbTasks.setSystemProperty("ij.password", "Refresh");
        } else {
            DbTasks.setSystemProperty("driver", "com.pivotal.gemfirexd.jdbc.ClientDriver");
            DbTasks.setSystemProperty("database", "jdbc:derby://localhost:1527/mailsdb;create=true;user=REFRESH;password=Refresh");
            MailJdbc.logAct.logMsg(" \n*****************************************************");
            MailJdbc.logAct.logMsg("\n\n\tStarting the test in NetworkServer mode");
            MailJdbc.logAct.logMsg("\n\n*****************************************************");
        }
        try {
            long s_schema = System.currentTimeMillis();
            ij.main((String[])new String[]{"-fr", "/org/apache/derbyTesting/system/mailjdbc/schema/schema.sql"});
            long e_schema = System.currentTimeMillis();
            log.logMsg(" \n*****************************************************");
            log.logMsg("\n\n\tPerformance Info for the Test on" + s_schema);
            log.logMsg("\n\n*****************************************************");
            log.logMsg(LogFile.INFO + "Schema Creation :" + PerfTime.readableTime(e_schema - s_schema));
            System.out.println("created the schema");
        }
        catch (Exception e) {
            log.logMsg(LogFile.ERROR + "Exception while running loading and creating tables: " + e.getMessage());
            e.printStackTrace();
            DbTasks.errorPrint(e);
        }
    }

    public static Connection getConnection(String usr, String passwd) {
        try {
            Class.forName(System.getProperty("driver")).newInstance();
            Connection con = DriverManager.getConnection(System.getProperty("database"), usr, passwd);
            return con;
        }
        catch (Exception e) {
            log.logMsg(LogFile.ERROR + "Error while getting connection for threads:" + e.getMessage());
            e.printStackTrace();
            DbTasks.errorPrint(e);
            return null;
        }
    }

    public void readMail(Connection conn, String thread_name) {
        Statement stmt = null;
        Statement stmt1 = null;
        int count = 0;
        int count1 = 0;
        long size = 0L;
        try {
            saveAutoCommit = conn.getAutoCommit();
            conn.setAutoCommit(false);
            conn.setTransactionIsolation(1);
            long s_select = System.currentTimeMillis();
            stmt = conn.createStatement();
            stmt1 = conn.createStatement();
            ResultSet rs = stmt.executeQuery(Statements.getRowCount);
            ResultSet rs1 = stmt1.executeQuery(Statements.getRowCountAtach);
            while (rs.next()) {
                count = rs.getInt(1);
            }
            while (rs1.next()) {
                count1 = rs1.getInt(1);
            }
            if (count == 0) {
                MailJdbc.logAct.logMsg(LogFile.INFO + thread_name + " : " + "Inbox is empty");
            }
            long e_select = System.currentTimeMillis();
            MailJdbc.logAct.logMsg(LogFile.INFO + thread_name + " : " + "The number of mails in the REFRESH.INBOX are : " + count);
            MailJdbc.logAct.logMsg(LogFile.INFO + thread_name + " : " + "The number of mails in the attachment table are : " + count1);
            log.logMsg(LogFile.INFO + thread_name + " : " + "Time taken to scan the entire REFRESH.INBOX for count :" + PerfTime.readableTime(e_select - s_select));
            rs.close();
            stmt1.close();
            rs1.close();
        }
        catch (SQLException sqe) {
            MailJdbc.logAct.logMsg(LogFile.ERROR + thread_name + " : " + "SQL Exception while reading : " + sqe.getMessage());
            sqe.printStackTrace();
            DbTasks.errorPrint(sqe);
            try {
                conn.rollback();
            }
            catch (SQLException sq) {
                MailJdbc.logAct.logMsg(LogFile.ERROR + thread_name + " : " + "Exception while rolling back: " + sq);
                DbTasks.errorPrint(sq);
                sq.printStackTrace();
            }
        }
        try {
            int attach_id = 0;
            attach_id = count - 1 <= 0 ? 0 : Rn.nextInt(count - 1);
            ResultSet rs = stmt.executeQuery("select attachment from REFRESH.attach where id  = " + attach_id);
            long start = System.currentTimeMillis();
            if (rs.next()) {
                size = rs.getBlob(1).length();
                MailJdbc.logAct.logMsg(LogFile.INFO + thread_name + " : " + "size of the attachment for id " + attach_id + " is : " + size);
            } else {
                MailJdbc.logAct.logMsg(LogFile.INFO + thread_name + " : " + "no attachment");
            }
            rs.close();
            long end = System.currentTimeMillis();
            log.logMsg(LogFile.INFO + thread_name + " : " + "Time taken to get the blob :" + PerfTime.readableTime(end - start));
            rs = stmt.executeQuery("select message from REFRESH.INBOX where id  = " + attach_id);
            long start_t = System.currentTimeMillis();
            if (rs.next()) {
                size = rs.getClob(1).length();
                MailJdbc.logAct.logMsg(LogFile.INFO + thread_name + " : " + "size of the message for id " + attach_id + " is : " + size);
            } else {
                MailJdbc.logAct.logMsg(LogFile.INFO + thread_name + " : " + "mail with the id " + attach_id + " does not exist");
            }
            long end_t = System.currentTimeMillis();
            log.logMsg(LogFile.INFO + thread_name + " : " + "Time taken to get the clob :" + PerfTime.readableTime(end_t - start_t));
            rs.close();
            stmt.close();
            conn.commit();
            conn.setAutoCommit(saveAutoCommit);
        }
        catch (SQLException sqe) {
            MailJdbc.logAct.logMsg(LogFile.ERROR + thread_name + " : " + "SQL Exception while getting the message and attach size : " + sqe.getMessage());
            sqe.printStackTrace();
            DbTasks.errorPrint(sqe);
            try {
                conn.rollback();
            }
            catch (SQLException sq) {
                MailJdbc.logAct.logMsg(LogFile.ERROR + thread_name + " : " + "Exception while rolling back: " + sq);
                sq.printStackTrace();
                DbTasks.errorPrint(sq);
            }
        }
    }

    public synchronized void deleteMailByUser(Connection conn, String thread_name) {
        int id_count = 0;
        int id = 0;
        int for_id = 0;
        try {
            saveAutoCommit = conn.getAutoCommit();
            conn.setAutoCommit(false);
            PreparedStatement updateUser = conn.prepareStatement(Statements.updateStr);
            Statement stmt = conn.createStatement();
            ResultSet rs = stmt.executeQuery("select max(id)from REFRESH.INBOX ");
            if (rs.next()) {
                id_count = rs.getInt(1);
            }
            short to_delete = 1;
            id = id_count - 1 <= 0 ? id_count : Rn.nextInt(id_count - 1);
            long s_update = System.currentTimeMillis();
            int delete_count = 0;
            for (int i = 0; i < id; ++i) {
                updateUser.setShort(1, to_delete);
                for_id = id_count - 1 <= 0 ? id_count : Rn.nextInt(id_count - 1);
                updateUser.setInt(2, for_id);
                int del = updateUser.executeUpdate();
                delete_count += del;
            }
            long e_update = System.currentTimeMillis();
            log.logMsg(LogFile.INFO + thread_name + " : " + " Time taken to mark the mails to be deleted :" + PerfTime.readableTime(e_update - s_update));
            MailJdbc.logAct.logMsg(LogFile.INFO + thread_name + " : " + "The number of mails marked to be deleted  by user:" + delete_count);
            rs.close();
            updateUser.close();
            stmt.close();
            conn.commit();
            conn.setAutoCommit(saveAutoCommit);
        }
        catch (SQLException sqe) {
            MailJdbc.logAct.logMsg(LogFile.ERROR + thread_name + " : " + "Exception while deleting mail by user: " + sqe.getMessage());
            sqe.printStackTrace();
            DbTasks.errorPrint(sqe);
            try {
                conn.rollback();
            }
            catch (SQLException sq) {
                MailJdbc.logAct.logMsg(LogFile.ERROR + thread_name + " : " + "Exception while rolling back: " + sq);
                sq.printStackTrace();
                DbTasks.errorPrint(sq);
            }
        }
    }

    public void deleteMailByThread(Connection conn, String thread_name) throws Exception {
        try {
            saveAutoCommit = conn.getAutoCommit();
            conn.setAutoCommit(false);
            PreparedStatement deleteThread = conn.prepareStatement(Statements.deleteStr);
            Statement stmt = conn.createStatement();
            ResultSet rs = stmt.executeQuery("select count(*) from REFRESH.INBOX where to_delete=1");
            long s_delete = System.currentTimeMillis();
            int count = 0;
            count = deleteThread.executeUpdate();
            long e_delete = System.currentTimeMillis();
            log.logMsg(LogFile.INFO + thread_name + " : " + "Time taken to delete mails by thread :" + PerfTime.readableTime(e_delete - s_delete));
            MailJdbc.logAct.logMsg(LogFile.INFO + thread_name + " : " + count + " rows deleted");
            delete_count += count;
            deleteThread.close();
            rs.close();
            stmt.close();
            conn.commit();
            conn.setAutoCommit(saveAutoCommit);
        }
        catch (SQLException sqe) {
            MailJdbc.logAct.logMsg(LogFile.ERROR + thread_name + " : " + "Exception while deleting mail by Thread: " + sqe.getMessage());
            sqe.printStackTrace();
            DbTasks.errorPrint(sqe);
            try {
                conn.rollback();
            }
            catch (SQLException sq) {
                MailJdbc.logAct.logMsg(LogFile.ERROR + thread_name + " : " + "Exception while rolling back: " + sq);
                sq.printStackTrace();
                DbTasks.errorPrint(sq);
                throw sqe;
            }
        }
    }

    public void moveToFolders(Connection conn, String thread_name) {
        try {
            saveAutoCommit = conn.getAutoCommit();
            conn.setAutoCommit(false);
            Statement stmt = conn.createStatement();
            PreparedStatement moveToFolder = conn.prepareStatement(Statements.movefolder);
            ResultSet rs = stmt.executeQuery(Statements.getRowCount);
            if (!rs.next()) {
                MailJdbc.logAct.logMsg(LogFile.INFO + thread_name + " : " + "no message in the REFRESH.INBOX to move");
            } else {
                int message_id = 0;
                int count = rs.getInt(1);
                int folder_id = Rn.nextInt(4);
                message_id = count == 0 ? 0 : Rn.nextInt(count - 1);
                moveToFolder.setInt(1, folder_id);
                moveToFolder.setInt(2, message_id);
                long s_folder = System.currentTimeMillis();
                moveToFolder.executeUpdate();
                long e_folder = System.currentTimeMillis();
                log.logMsg(LogFile.INFO + thread_name + " : " + "Time taken to move a mail to the folder :" + PerfTime.readableTime(e_folder - s_folder));
                MailJdbc.logAct.logMsg(LogFile.INFO + thread_name + " : " + "Mail with id : " + message_id + " is moved to folder with id : " + folder_id);
            }
            stmt.close();
            moveToFolder.close();
            rs.close();
            conn.commit();
            conn.setAutoCommit(saveAutoCommit);
        }
        catch (SQLException sqe) {
            MailJdbc.logAct.logMsg(LogFile.ERROR + thread_name + " : " + "Exception while moving mail to folders: " + sqe.getMessage());
            sqe.printStackTrace();
            DbTasks.errorPrint(sqe);
            try {
                conn.rollback();
            }
            catch (SQLException sq) {
                MailJdbc.logAct.logMsg(LogFile.ERROR + thread_name + " : " + "Exception while rolling back: " + sq);
                sq.printStackTrace();
                DbTasks.errorPrint(sq);
            }
        }
    }

    public void insertMail(Connection conn, String thread_name) throws Exception {
        Statement stmt = conn.createStatement();
        int num = Rn.nextInt(9);
        LoopingAlphabetStream streamIn = null;
        Reader streamReader = null;
        try {
            saveAutoCommit = conn.getAutoCommit();
            conn.setAutoCommit(false);
            PreparedStatement insertFirst = conn.prepareStatement(Statements.insertStr, 1);
            String name = new String("ABCD");
            String l_name = new String("WXYZ");
            long s_insert = System.currentTimeMillis();
            for (int i = 0; i < num; ++i) {
                String new_name = new String(DbTasks.increment(name, 60));
                String new_lname = new String(DbTasks.decrement(l_name, 60));
                insertFirst.setString(1, new_name);
                insertFirst.setString(2, new_lname);
                insertFirst.setTimestamp(3, new Timestamp(System.currentTimeMillis()));
                name = new_name;
                l_name = new_lname;
                try {
                    int clobLength = Rn.nextInt(3077801) + 200;
                    streamReader = new LoopingAlphabetReader((long)clobLength, CharAlphabet.modernLatinLowercase());
                    insertFirst.setCharacterStream(4, streamReader, clobLength);
                }
                catch (Exception e) {
                    MailJdbc.logAct.logMsg(LogFile.ERROR + thread_name + " : " + "File not found Exception : " + e.getMessage());
                    DbTasks.errorPrint(e);
                    throw e;
                }
                int rand_num = Rn.nextInt(9);
                if (i == rand_num) {
                    ResultSet rs = stmt.executeQuery("select count(*) from REFRESH.INBOX where attach_id>0");
                    while (rs.next()) {
                        id_count = rs.getInt(1);
                        insertFirst.setInt(5, rs.getInt(1) + 1);
                    }
                    rs.close();
                    conn.setTransactionIsolation(2);
                } else {
                    insertFirst.setInt(5, 0);
                }
                insertFirst.setString(6, "This column is used only to by pass the space problem. If the problem still exists, then we are going to have a serious issue here.*****************************************************************************************************");
                int result = insertFirst.executeUpdate();
                if (result == 0) continue;
                ++insert_count;
            }
            insertFirst.close();
            conn.commit();
            streamReader.close();
            long e_insert = System.currentTimeMillis();
            log.logMsg(LogFile.INFO + thread_name + " : " + "Time taken to insert " + num + "rows :" + PerfTime.readableTime(e_insert - s_insert));
            MailJdbc.logAct.logMsg(LogFile.INFO + thread_name + " : " + "number of mails inserted : " + num);
        }
        catch (SQLException sqe) {
            MailJdbc.logAct.logMsg(LogFile.INFO + thread_name + " : " + "Error while inserting into REFRESH.INBOX:" + sqe.getMessage());
            sqe.printStackTrace();
            DbTasks.errorPrint(sqe);
            try {
                conn.rollback();
            }
            catch (SQLException sq) {
                MailJdbc.logAct.logMsg(LogFile.INFO + thread_name + " : " + "Exception while rolling back: " + sq);
                sq.printStackTrace();
                DbTasks.errorPrint(sq);
                throw sqe;
            }
        }
        try {
            PreparedStatement insertAttach = conn.prepareStatement(Statements.insertStrAttach);
            Statement stmt1 = conn.createStatement();
            ResultSet rs = stmt1.executeQuery("select id,attach_id from REFRESH.INBOX where attach_id >" + id_count);
            int row_count = 0;
            long a_start = System.currentTimeMillis();
            while (rs.next()) {
                insertAttach.setInt(1, rs.getInt(1));
                insertAttach.setInt(2, rs.getInt(2));
                try {
                    int blobLength = Rn.nextInt(5130001) + 0;
                    streamIn = new LoopingAlphabetStream(blobLength);
                    insertAttach.setBinaryStream(3, (InputStream)streamIn, blobLength);
                }
                catch (Exception e) {
                    MailJdbc.logAct.logMsg(LogFile.ERROR + thread_name + " : " + "Exception : " + e.getMessage());
                    DbTasks.errorPrint(e);
                    throw e;
                }
                int result_attach = insertAttach.executeUpdate();
                streamIn.close();
                if (result_attach == 0) continue;
                ++blob_count;
                ++row_count;
            }
            long a_end = System.currentTimeMillis();
            log.logMsg(LogFile.INFO + thread_name + " : " + "Time taken to insert " + row_count + "attachments :" + PerfTime.readableTime(a_end - a_start));
            ++id_count;
            rs.close();
            stmt.close();
            stmt1.close();
            insertAttach.close();
            conn.commit();
            conn.setAutoCommit(saveAutoCommit);
        }
        catch (SQLException sqe) {
            MailJdbc.logAct.logMsg(LogFile.INFO + thread_name + " : " + "Error while inserting attachments:" + sqe.getMessage());
            sqe.printStackTrace();
            DbTasks.errorPrint(sqe);
            try {
                conn.rollback();
            }
            catch (SQLException sq) {
                MailJdbc.logAct.logMsg(LogFile.INFO + thread_name + " : " + "Exception while rolling back: " + sq);
                sq.printStackTrace();
                DbTasks.errorPrint(sq);
                throw sqe;
            }
        }
    }

    public synchronized void deleteMailByExp(Connection conn, String thread_name) {
        try {
            saveAutoCommit = conn.getAutoCommit();
            conn.setAutoCommit(false);
            long s_delExp = System.currentTimeMillis();
            Statement selExp = conn.createStatement();
            PreparedStatement deleteExp = conn.prepareStatement(Statements.delExp);
            MailJdbc.logAct.logMsg(LogFile.INFO + thread_name + " : " + "delete mails which are older than 1 day");
            int count = 0;
            count = selExp.executeUpdate(Statements.del_jdbc_exp);
            long e_delExp = System.currentTimeMillis();
            log.logMsg(LogFile.INFO + thread_name + " : " + "Time taken to delete " + count + "mails :" + PerfTime.readableTime(e_delExp - s_delExp));
            MailJdbc.logAct.logMsg(LogFile.INFO + thread_name + " : " + " number of mails deleted : " + count);
            delete_count += count;
            deleteExp.close();
            selExp.close();
            conn.commit();
            conn.setAutoCommit(saveAutoCommit);
        }
        catch (SQLException sqe) {
            MailJdbc.logAct.logMsg(LogFile.ERROR + thread_name + " : " + "Error while deleting mails by expiry manager: " + sqe.getMessage());
            sqe.printStackTrace();
            DbTasks.errorPrint(sqe);
            try {
                conn.rollback();
            }
            catch (SQLException sq) {
                MailJdbc.logAct.logMsg(LogFile.ERROR + thread_name + " : " + "Exception while rolling back: " + sq);
                sq.printStackTrace();
                DbTasks.errorPrint(sq);
            }
        }
    }

    public void Backup(Connection conn, String thread_name) {
        long s_backup = System.currentTimeMillis();
        try {
            saveAutoCommit = conn.getAutoCommit();
            conn.setAutoCommit(true);
            CallableStatement cs = conn.prepareCall("CALL SYSCS_UTIL.BACKUP_DATABASE_AND_ENABLE_LOG_ARCHIVE_MODE_NOWAIT(?, ?)");
            cs.setString(1, System.getProperty("user.dir") + File.separator + "mailbackup");
            cs.setInt(2, 1);
            cs.execute();
            cs.close();
            MailJdbc.logAct.logMsg(LogFile.INFO + thread_name + " : " + "Finished backing up the Database");
            conn.commit();
            conn.setAutoCommit(saveAutoCommit);
        }
        catch (Throwable sqe) {
            MailJdbc.logAct.logMsg(LogFile.ERROR + thread_name + " : " + "Error while doing the backup system procedure: " + sqe.getMessage());
            sqe.printStackTrace();
            DbTasks.errorPrint(sqe);
        }
        long e_backup = System.currentTimeMillis();
        log.logMsg(LogFile.INFO + thread_name + " : " + "Time taken to do backup :" + PerfTime.readableTime(e_backup - s_backup));
    }

    public void compressTable(Connection conn, String tabname, String thread_name) {
        long s_compress = System.currentTimeMillis();
        long dbsize = DbTasks.databaseSize("mailsdb/seg0");
        MailJdbc.logAct.logMsg(LogFile.INFO + thread_name + " : " + "dbsize before compress : " + dbsize);
        try {
            boolean saveAutoCommit = conn.getAutoCommit();
            conn.setAutoCommit(true);
            CallableStatement cs = conn.prepareCall("CALL SYSCS_UTIL.INPLACE_COMPRESS_TABLE(?, ?, ?, ?, ?)");
            cs.setString(1, "REFRESH");
            cs.setString(2, tabname);
            cs.setShort(3, (short)1);
            cs.setShort(4, (short)1);
            cs.setShort(5, (short)1);
            cs.execute();
            conn.setAutoCommit(saveAutoCommit);
            cs.close();
        }
        catch (Throwable sqe) {
            MailJdbc.logAct.logMsg(LogFile.ERROR + thread_name + " : " + "Error while doing the Compress procedure: " + sqe.getMessage());
            sqe.printStackTrace();
            DbTasks.errorPrint(sqe);
        }
        long e_compress = System.currentTimeMillis();
        MailJdbc.logAct.logMsg(LogFile.INFO + thread_name + " : " + "Finished Compressing the table: " + tabname);
        log.logMsg(LogFile.INFO + thread_name + " : " + "Time taken to compress the table : " + tabname + PerfTime.readableTime(e_compress - s_compress));
        dbsize = DbTasks.databaseSize("mailsdb/seg0");
        MailJdbc.logAct.logMsg(LogFile.INFO + thread_name + " : " + "dbsize after compress : " + dbsize);
    }

    public synchronized void checkDbSize(Connection conn, String thread_name) {
        try {
            int del_count = 0;
            int count = 0;
            int diff = 0;
            ArrayList<Integer> idArray = new ArrayList<Integer>();
            Integer id_element = new Integer(0);
            Statement stmt = conn.createStatement();
            Statement stmt1 = conn.createStatement();
            Statement stmt2 = conn.createStatement();
            Statement stmt3 = conn.createStatement();
            ResultSet rs = stmt.executeQuery("select count(*) from REFRESH.INBOX ");
            while (rs.next()) {
                count = rs.getInt(1);
            }
            if (count > 12) {
                diff = count - 12;
                ResultSet rs1 = stmt1.executeQuery("select id from REFRESH.INBOX");
                while (rs1.next()) {
                    id_element = new Integer(rs1.getInt(1));
                    idArray.add(id_element);
                }
                for (int i = 0; i <= diff; ++i) {
                    del_count += stmt3.executeUpdate("delete from REFRESH.INBOX where id =" + idArray.get(i));
                }
                rs1.close();
            }
            delete_count += del_count;
            rs.close();
            stmt.close();
            stmt1.close();
            stmt2.close();
            stmt3.close();
        }
        catch (Exception fe) {
            MailJdbc.logAct.logMsg(LogFile.ERROR + thread_name + " :  " + fe.getMessage());
            DbTasks.errorPrint(fe);
        }
    }

    public void grantRevoke(Connection conn, String thread_name) {
        try {
            saveAutoCommit = conn.getAutoCommit();
            Statement stmt = conn.createStatement();
            stmt.execute(Statements.grantSel1);
            stmt.execute(Statements.grantSel2);
            stmt.execute(Statements.grantSel3);
            stmt.execute(Statements.grantSel4);
            stmt.execute(Statements.grantSel5);
            stmt.execute(Statements.grantSel6);
            stmt.execute(Statements.grantSel7);
            stmt.execute(Statements.grantIns1);
            stmt.execute(Statements.grantIns2);
            stmt.execute(Statements.grantIns3);
            stmt.execute(Statements.grantUp1);
            stmt.execute(Statements.grantUp2);
            stmt.execute(Statements.grantUp3);
            stmt.execute(Statements.grantDel1);
            stmt.execute(Statements.grantDel2);
            stmt.execute(Statements.grantDel3);
            stmt.execute(Statements.grantExe1);
            stmt.execute(Statements.grantExe2);
            stmt.execute(Statements.grantExe3);
            stmt.execute(Statements.grantExe4);
            stmt.execute(Statements.grantExe5);
            conn.commit();
            conn.setAutoCommit(saveAutoCommit);
            stmt.close();
            MailJdbc.logAct.logMsg(LogFile.INFO + thread_name + " : " + "Finished Granting permissions");
        }
        catch (Throwable sqe) {
            MailJdbc.logAct.logMsg(LogFile.ERROR + thread_name + " : " + "Error while doing Grant Revoke: " + sqe.getMessage());
            sqe.printStackTrace();
            DbTasks.errorPrint(sqe);
        }
    }

    public static long databaseSize(String dbname) {
        File dir = new File(dbname);
        File[] files = dir.listFiles();
        long length = 0L;
        int count = 0;
        for (int i = 0; i < files.length; ++i) {
            length += files[i].length();
            ++count;
        }
        return length;
    }

    public static void setSystemProperty(String key, String value) {
        String svalue = System.getProperty(key);
        if (svalue == null) {
            System.setProperty(key, value);
        } else {
            value = svalue;
        }
        MailJdbc.logAct.logMsg(LogFile.INFO + key + "=" + value);
    }

    public void totals() {
        MailJdbc.logAct.logMsg(LogFile.INFO + " total number of inserts : " + insert_count);
        MailJdbc.logAct.logMsg(LogFile.INFO + " total number of deletes : " + delete_count);
        MailJdbc.logAct.logMsg(LogFile.INFO + " total number of clobs inserted : " + insert_count);
        MailJdbc.logAct.logMsg(LogFile.INFO + " total number of blobs inserted : " + blob_count);
    }

    public static String decrement(String name, int maxLength) {
        int i;
        StringBuilder buff = new StringBuilder(name);
        StringBuilder tempBuff = new StringBuilder();
        if (name.length() == 1 && name.charAt(0) == DbTasks.firstChar()) {
            for (int i2 = 0; i2 < maxLength; ++i2) {
                tempBuff.append(DbTasks.lastChar());
            }
            return tempBuff.toString();
        }
        boolean isAll0 = true;
        for (i = 0; i < buff.length(); ++i) {
            if (buff.charAt(i) == DbTasks.firstChar()) continue;
            isAll0 = false;
            break;
        }
        if (isAll0) {
            buff.deleteCharAt(0);
            for (i = 0; i < buff.length(); ++i) {
                buff.setCharAt(i, DbTasks.lastChar());
            }
        } else {
            for (i = buff.length() - 1; i >= 0; --i) {
                if (buff.charAt(i) > DbTasks.firstChar()) {
                    buff.setCharAt(i, DbTasks.previousChar(buff.charAt(i)));
                } else {
                    buff.setCharAt(i, DbTasks.lastChar());
                    if (buff.charAt(i - 1) >= DbTasks.firstChar()) continue;
                    buff.setCharAt(i - 1, DbTasks.previousChar(buff.charAt(i - 1)));
                }
                break;
            }
        }
        return buff.toString();
    }

    private static char firstChar() {
        return '0';
    }

    private static char lastChar() {
        return 'z';
    }

    private static char previousChar(char c) {
        if (c <= 'A' && c >= ';') {
            return '9';
        }
        if (c <= 'a' && c >= '\\') {
            return 'Z';
        }
        return (char)(c - '\u0001');
    }

    public static String increment(String name, int maxLength) {
        int i;
        StringBuilder buff = new StringBuilder(name);
        boolean isAllZ = true;
        for (i = 0; i < name.length(); ++i) {
            if (name.charAt(i) == DbTasks.lastChar()) continue;
            isAllZ = false;
            break;
        }
        if (isAllZ) {
            if (name.length() >= maxLength) {
                return "0";
            }
            for (i = 0; i < buff.length(); ++i) {
                buff.setCharAt(i, DbTasks.firstChar());
            }
            buff.append('0');
        } else {
            for (i = buff.length() - 1; i >= 0; --i) {
                if (buff.charAt(i) < DbTasks.lastChar()) {
                    buff.setCharAt(i, DbTasks.nextChar(buff.charAt(i)));
                    break;
                }
                buff.setCharAt(i, DbTasks.firstChar());
                if (buff.charAt(i - 1) >= DbTasks.lastChar()) continue;
                buff.setCharAt(i - 1, DbTasks.nextChar(buff.charAt(i - 1)));
                break;
            }
        }
        return buff.toString();
    }

    private static char nextChar(char c) {
        if (c <= '?' && c >= '9') {
            return 'A';
        }
        if (c <= '_' && c >= 'Z') {
            return 'a';
        }
        return (char)(c + '\u0001');
    }

    static void errorPrint(Throwable e) {
        if (e instanceof SQLException) {
            DbTasks.SQLExceptionPrint((SQLException)e);
        } else {
            System.out.println("A non SQL error occured.");
            e.printStackTrace();
        }
    }

    static void SQLExceptionPrint(SQLException sqle) {
        while (sqle != null) {
            System.out.println("\n---SQLException Caught---\n");
            System.out.println("SQLState:   " + sqle.getSQLState());
            System.out.println("Severity: " + sqle.getErrorCode());
            System.out.println("Message:  " + sqle.getMessage());
            sqle.printStackTrace();
            sqle = sqle.getNextException();
        }
    }

    static {
        id_count = 0;
        insert_count = 0;
        delete_count = 0;
        clob_count = 0;
        blob_count = 0;
        Rn = new Random();
    }
}

