/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.system.mailjdbc.tasks;

import java.sql.Connection;
import org.apache.derbyTesting.system.mailjdbc.MailJdbc;
import org.apache.derbyTesting.system.mailjdbc.tasks.Refresh;
import org.apache.derbyTesting.system.mailjdbc.utils.DbTasks;
import org.apache.derbyTesting.system.mailjdbc.utils.LogFile;
import org.apache.derbyTesting.system.mailjdbc.utils.ThreadUtils;

public class Browse
extends Thread {
    private DbTasks dbtasks = new DbTasks();
    private Connection conn = DbTasks.getConnection("BROWSE", "Browse");

    public Browse(String name) {
        this.setName(name);
    }

    @Override
    public void run() {
        try {
            while (true) {
                this.readInbox(this.conn, this.getName());
                this.deleteMailByUser(this.conn, this.getName());
                this.moveToFolders(this.conn, this.getName());
                Thread.sleep(30000L);
                if (ThreadUtils.isThreadRunning("Refresh Thread")) {
                    MailJdbc.logAct.logMsg("******** Refresh is running");
                    continue;
                }
                Refresh th = (Refresh)ThreadUtils.getThread("Refresh Thread");
                th.interrupt();
            }
        }
        catch (Exception e) {
            MailJdbc.logAct.logMsg(LogFile.ERROR + "Error while sleeping the thread in Browse: " + e.getMessage());
            e.printStackTrace();
            return;
        }
    }

    public void readInbox(Connection conn, String thread_name) {
        this.dbtasks.readMail(conn, thread_name);
        this.dbtasks.totals();
    }

    public void deleteMailByUser(Connection conn, String thread_name) {
        this.dbtasks.deleteMailByUser(conn, thread_name);
    }

    public void moveToFolders(Connection conn, String thread_name) {
        this.dbtasks.moveToFolders(conn, thread_name);
    }
}

