/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.perf.clients;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Random;
import org.apache.derbyTesting.perf.clients.Client;
import org.apache.derbyTesting.perf.clients.SingleRecordFiller;

public class SingleRecordUpdateClient
implements Client {
    private Connection conn;
    private final PreparedStatement[] pss;
    private final Random r;
    private final int tableSize;

    public SingleRecordUpdateClient(int records, int tables2) {
        this.tableSize = records;
        this.r = new Random();
        this.pss = new PreparedStatement[tables2];
    }

    @Override
    public void init(Connection c) throws SQLException {
        for (int i = 0; i < this.pss.length; ++i) {
            String tableName = SingleRecordFiller.getTableName(this.tableSize, i);
            String sql = "UPDATE " + tableName + " SET TEXT = ? WHERE ID = ?";
            this.pss[i] = c.prepareStatement(sql);
        }
        c.setAutoCommit(false);
        this.conn = c;
    }

    @Override
    public void doWork() throws SQLException {
        PreparedStatement ps = this.pss[this.r.nextInt(this.pss.length)];
        ps.setString(1, SingleRecordFiller.randomString(this.r.nextInt()));
        ps.setInt(2, this.r.nextInt(this.tableSize));
        ps.executeUpdate();
        this.conn.commit();
    }
}

