/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.perf.clients;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Random;
import org.apache.derbyTesting.perf.clients.DBFiller;
import org.apache.derbyTesting.perf.clients.WisconsinFiller;

public class SingleRecordFiller
implements DBFiller {
    private final int numberOfTables;
    private final int tableSize;
    private static final int TEXT_SIZE = 100;
    private static final String[] RANDOM_STRINGS = new String[16];

    public SingleRecordFiller(int records, int tables2) {
        this.tableSize = records;
        this.numberOfTables = tables2;
    }

    @Override
    public void fill(Connection c) throws SQLException {
        c.setAutoCommit(false);
        Statement s = c.createStatement();
        for (int table = 0; table < this.numberOfTables; ++table) {
            String tableName = SingleRecordFiller.getTableName(this.tableSize, table);
            WisconsinFiller.dropTable(c, tableName);
            s.executeUpdate("CREATE TABLE " + tableName + "(ID INT PRIMARY KEY, " + "TEXT VARCHAR(" + 100 + "))");
            PreparedStatement ps = c.prepareStatement("INSERT INTO " + tableName + "(ID, TEXT) VALUES (?, ?)");
            for (int i = 0; i < this.tableSize; ++i) {
                ps.setInt(1, i);
                ps.setString(2, SingleRecordFiller.randomString(i));
                ps.executeUpdate();
                if (i % 1000 != 0) continue;
                c.commit();
            }
            ps.close();
            c.commit();
        }
        s.close();
    }

    static String randomString(int seed) {
        return RANDOM_STRINGS[(seed & Integer.MAX_VALUE) % RANDOM_STRINGS.length];
    }

    static String getTableName(int records, int table) {
        return "SINGLE_RECORD_" + records + "_" + table;
    }

    static {
        String alphabet = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ01234567890_-+*/(){}[]&%$#!";
        Random r = new Random();
        for (int i = 0; i < RANDOM_STRINGS.length; ++i) {
            StringBuilder buf = new StringBuilder(100);
            for (int x = 0; x < 100; ++x) {
                buf.append("abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ01234567890_-+*/(){}[]&%$#!".charAt(r.nextInt("abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ01234567890_-+*/(){}[]&%$#!".length())));
            }
            SingleRecordFiller.RANDOM_STRINGS[i] = buf.toString();
        }
    }
}

