/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.perf.clients;

import java.io.PrintStream;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import org.apache.derbyTesting.perf.clients.BackToBackLoadGenerator;
import org.apache.derbyTesting.perf.clients.Client;
import org.apache.derbyTesting.perf.clients.DBFiller;
import org.apache.derbyTesting.perf.clients.IndexJoinClient;
import org.apache.derbyTesting.perf.clients.LoadGenerator;
import org.apache.derbyTesting.perf.clients.PoissonLoadGenerator;
import org.apache.derbyTesting.perf.clients.SingleRecordFiller;
import org.apache.derbyTesting.perf.clients.SingleRecordSelectClient;
import org.apache.derbyTesting.perf.clients.SingleRecordUpdateClient;
import org.apache.derbyTesting.perf.clients.WisconsinFiller;

public class Runner {
    private static final String DERBY_EMBEDDED_DRIVER = "com.pivotal.gemfirexd.jdbc.EmbeddedDriver";
    private static final String DEFAULT_URL = "jdbc:derby:db;create=true";
    private static String driver = "com.pivotal.gemfirexd.jdbc.EmbeddedDriver";
    private static String url = "jdbc:derby:db;create=true";
    private static String user = "test";
    private static String password = "test";
    private static boolean init = false;
    private static String load;
    private static String generator;
    private static int threads;
    private static int requestsPerSecond;
    private static int warmupSec;
    private static int steadySec;
    private static final String USAGE = "Valid parameters:\n  -driver: JDBC driver class, default: com.pivotal.gemfirexd.jdbc.EmbeddedDriver\n  -url: JDBC connection url, default: jdbc:derby:db;create=true\n  -user: JDBC user name, default: test\n  -pass: JDBC user password, default: test\n  -init: initialize database (otherwise, reuse database)\n  -load: type of load, required argument, valid types:\n      * sr_select - single-record (primary key) select from table with\n                    100 000 rows\n      * sr_update - single-record (primary key) update on table with\n                    100 000 rows\n      * sr_select_big - single-record (primary key) select from table with\n                    100 000 000 rows\n      * sr_update_big - single-record (primary key) update on table with\n                    100 000 000 rows\n      * sr_select_multi - single-record select from a random table\n                    (32 tables with a single row each)\n      * sr_update_multi - single-record update on a random table\n                    (32 tables with a single row each)\n      * index_join - join of two tables (using indexed columns)\n  -gen: load generator, default: b2b, valid types:\n      * b2b - clients perform operations back-to-back\n      * poisson - load is Poisson distributed\n  -threads: number of threads performing operations, default: 1\n  -rate: average number of transactions per second to inject when\n         load generator is \"poisson\", default: 100\n  -wt: warmup time in seconds, default: 30\n  -rt: time in seconds to collect results, default: 60";

    public static void main(String[] args) throws Exception {
        try {
            Runner.parseArgs(args);
        }
        catch (Exception e) {
            System.err.println(e);
            Runner.printUsage(System.err);
            System.exit(1);
        }
        Class.forName(driver).newInstance();
        if (init) {
            DBFiller filler = Runner.getDBFiller();
            Connection conn = DriverManager.getConnection(url, user, password);
            System.out.println("initializing database...");
            filler.fill(conn);
            conn.close();
        }
        Client[] clients = new Client[threads];
        for (int i = 0; i < clients.length; ++i) {
            Connection c = DriverManager.getConnection(url, user, password);
            c.setTransactionIsolation(2);
            clients[i] = Runner.newClient();
            clients[i].init(c);
        }
        LoadGenerator gen = Runner.getLoadGenerator();
        gen.init(clients);
        System.out.println("starting warmup...");
        gen.startWarmup();
        Thread.sleep(1000L * (long)warmupSec);
        System.out.println("entering steady state...");
        gen.startSteadyState();
        Thread.sleep(1000L * (long)steadySec);
        System.out.println("stopping threads...");
        gen.stop();
        gen.printReport(System.out);
        Runner.shutdownDatabase();
    }

    private static void parseArgs(String[] args) throws Exception {
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-driver")) {
                driver = args[++i];
                continue;
            }
            if (args[i].equals("-url")) {
                url = args[++i];
                continue;
            }
            if (args[i].equals("-user")) {
                user = args[++i];
                continue;
            }
            if (args[i].equals("-pass")) {
                password = args[++i];
                continue;
            }
            if (args[i].equals("-init")) {
                init = true;
                continue;
            }
            if (args[i].equals("-load")) {
                load = args[++i];
                continue;
            }
            if (args[i].equals("-gen")) {
                generator = args[++i];
                continue;
            }
            if (args[i].equals("-threads")) {
                threads = Integer.parseInt(args[++i]);
                continue;
            }
            if (args[i].equals("-rate")) {
                requestsPerSecond = Integer.parseInt(args[++i]);
                continue;
            }
            if (args[i].equals("-wt")) {
                warmupSec = Integer.parseInt(args[++i]);
                continue;
            }
            if (args[i].equals("-rt")) {
                steadySec = Integer.parseInt(args[++i]);
                continue;
            }
            throw new Exception("invalid argument: " + args[i]);
        }
        if (load == null) {
            throw new Exception("required parameter -load not specified");
        }
    }

    private static void printUsage(PrintStream out) {
        out.println(USAGE);
    }

    private static DBFiller getDBFiller() {
        if (load.equals("sr_select") || load.equals("sr_update")) {
            return new SingleRecordFiller(100000, 1);
        }
        if (load.equals("sr_select_big") || load.equals("sr_update_big")) {
            return new SingleRecordFiller(100000000, 1);
        }
        if (load.equals("sr_select_multi") || load.equals("sr_update_multi")) {
            return new SingleRecordFiller(1, 32);
        }
        if (load.equals("index_join")) {
            return new WisconsinFiller();
        }
        System.err.println("unknown load: " + load);
        Runner.printUsage(System.err);
        System.exit(1);
        return null;
    }

    private static Client newClient() {
        if (load.equals("sr_select")) {
            return new SingleRecordSelectClient(100000, 1);
        }
        if (load.equals("sr_update")) {
            return new SingleRecordUpdateClient(100000, 1);
        }
        if (load.equals("sr_select_big")) {
            return new SingleRecordSelectClient(100000000, 1);
        }
        if (load.equals("sr_update_big")) {
            return new SingleRecordUpdateClient(100000000, 1);
        }
        if (load.equals("sr_select_multi")) {
            return new SingleRecordSelectClient(1, 32);
        }
        if (load.equals("sr_update_multi")) {
            return new SingleRecordUpdateClient(1, 32);
        }
        if (load.equals("index_join")) {
            return new IndexJoinClient();
        }
        System.err.println("unknown load: " + load);
        Runner.printUsage(System.err);
        System.exit(1);
        return null;
    }

    private static LoadGenerator getLoadGenerator() {
        if (generator.equals("b2b")) {
            return new BackToBackLoadGenerator();
        }
        if (generator.equals("poisson")) {
            double avgWaitTime = 1000.0 * (double)threads / (double)requestsPerSecond;
            return new PoissonLoadGenerator(avgWaitTime);
        }
        System.err.println("unknown load generator: " + generator);
        Runner.printUsage(System.err);
        System.exit(1);
        return null;
    }

    private static void shutdownDatabase() throws SQLException {
        block3: {
            if (driver.equals(DERBY_EMBEDDED_DRIVER)) {
                try {
                    DriverManager.getConnection(url + ";shutdown=true");
                    System.err.println("WARNING: Shutdown of database didn't throw expected exception");
                }
                catch (SQLException e) {
                    if ("08006".equals(e.getSQLState())) break block3;
                    System.err.println("WARNING: Shutdown of database threw unexpected exception");
                    e.printStackTrace();
                }
            }
        }
    }

    static {
        generator = "b2b";
        threads = 1;
        requestsPerSecond = 100;
        warmupSec = 30;
        steadySec = 60;
    }
}

