/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.junit;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.lang.reflect.Method;
import java.net.URL;
import java.security.PrivilegedActionException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.StringTokenizer;
import junit.framework.Assert;
import org.apache.derbyTesting.junit.BaseTestCase;
import org.apache.derbyTesting.junit.JAXPFinder;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.SupportFilesSetup;

public class XML {
    private static int[] MIN_XALAN_VERSION = new int[]{2, 5, 0};
    private static final boolean HAVE_JAXP = JDBC.haveClass("org.w3c.dom.Document");
    private static final boolean HAVE_XALAN = JDBC.haveClass("com.sun.org.apache.xpath.internal.XPath") && JDBC.haveClass("com.sun.org.apache.xalan.internal.xslt.EnvironmentCheck") || JDBC.haveClass("org.apache.xpath.XPath") && JDBC.haveClass("org.apache.xalan.xslt.EnvironmentCheck");
    private static final boolean HAVE_MIN_XALAN = HAVE_XALAN && XML.checkXalanVersion();
    private static final String HELPER_FILE_LOCATION = "org/apache/derbyTesting/functionTests/tests/lang/xmlTestFiles/";

    public static boolean classpathHasXalanAndJAXP() {
        return HAVE_JAXP && HAVE_XALAN;
    }

    public static boolean classpathMeetsXMLReqs() {
        return HAVE_JAXP && HAVE_MIN_XALAN;
    }

    public static void insertFile(Connection conn, String tableName, String colName, String fName, int numRows) throws IOException, SQLException, PrivilegedActionException {
        fName = HELPER_FILE_LOCATION + fName;
        URL xFile = BaseTestCase.getTestResource(fName);
        Assert.assertNotNull((String)("XML input file missing: " + fName), (Object)xFile);
        int charCount = 0;
        char[] cA = new char[1024];
        InputStreamReader reader = new InputStreamReader(BaseTestCase.openTestResource(xFile));
        int len = reader.read(cA, 0, cA.length);
        while (len != -1) {
            charCount += len;
            len = reader.read(cA, 0, cA.length);
        }
        reader.close();
        PreparedStatement pSt = conn.prepareStatement("insert into " + tableName + "(" + colName + ") values " + "(xmlparse(document cast (? as clob) preserve whitespace))");
        for (int i = 0; i < numRows; ++i) {
            reader = new InputStreamReader(BaseTestCase.openTestResource(xFile));
            pSt.setCharacterStream(1, (Reader)reader, charCount);
            pSt.execute();
            reader.close();
        }
        pSt.close();
    }

    public static void insertDocWithDTD(Connection conn, String tableName, String colName, String fName, String dtdName, int numRows) throws IOException, SQLException, PrivilegedActionException {
        fName = HELPER_FILE_LOCATION + fName;
        URL xFile = BaseTestCase.getTestResource(fName);
        Assert.assertNotNull((String)("XML input file missing: " + fName), (Object)xFile);
        int charCount = 0;
        char[] cA = new char[1024];
        StringBuilder sBuf = new StringBuilder();
        InputStreamReader reader = new InputStreamReader(BaseTestCase.openTestResource(xFile));
        int len = reader.read(cA, 0, cA.length);
        while (len != -1) {
            sBuf.append(cA, 0, len);
            charCount += len;
            len = reader.read(cA, 0, cA.length);
        }
        reader.close();
        URL dtdURL = SupportFilesSetup.getReadOnlyURL(dtdName);
        Assert.assertNotNull((String)("DTD file missing: " + dtdName), (Object)dtdURL);
        String docAsString = sBuf.toString();
        int pos = docAsString.indexOf(dtdName);
        if (pos != -1) {
            sBuf.replace(pos, pos + dtdName.length(), dtdURL.toExternalForm());
        }
        docAsString = sBuf.toString();
        PreparedStatement pSt = conn.prepareStatement("insert into " + tableName + "(" + colName + ") values " + "(xmlparse(document cast (? as clob) preserve whitespace))");
        for (int i = 0; i < numRows; ++i) {
            pSt.setString(1, docAsString);
            pSt.execute();
        }
        pSt.close();
    }

    private static boolean checkXalanVersion() {
        boolean haveMinXalanVersion = false;
        try {
            Class<?> cl;
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            PrintWriter pW = new PrintWriter(bos);
            try {
                cl = Class.forName("com.sun.org.apache.xalan.internal.xslt.EnvironmentCheck");
            }
            catch (Exception ex) {
                cl = null;
            }
            if (cl == null) {
                cl = Class.forName("org.apache.xalan.xslt.EnvironmentCheck");
            }
            Method meth = cl.getMethod("checkEnvironment", PrintWriter.class);
            Boolean boolObj = (Boolean)meth.invoke(cl.newInstance(), pW);
            pW.flush();
            bos.flush();
            cl = null;
            meth = null;
            pW = null;
            if (boolObj.booleanValue()) {
                String checkEnvOutput = bos.toString();
                bos.close();
                int pos = checkEnvOutput.indexOf("version.xalan2_2=");
                if (pos < 0) {
                    return false;
                }
                String ver = checkEnvOutput.substring(pos, checkEnvOutput.indexOf("\n", pos));
                boolean bl = haveMinXalanVersion = ver != null;
                if (haveMinXalanVersion) {
                    int i = 0;
                    StringTokenizer tok = new StringTokenizer(ver, ". ");
                    while (tok.hasMoreTokens()) {
                        String str = tok.nextToken().trim();
                        if (Character.isDigit(str.charAt(0))) {
                            int val = Integer.valueOf(str);
                            if (val < MIN_XALAN_VERSION[i]) {
                                haveMinXalanVersion = false;
                                break;
                            }
                            ++i;
                        }
                        if (i < MIN_XALAN_VERSION.length) continue;
                        break;
                    }
                    if (i < MIN_XALAN_VERSION.length) {
                        haveMinXalanVersion = false;
                    }
                }
            }
        }
        catch (Throwable t) {
            System.out.println("Unexpected exception while trying to find Xalan version:");
            t.printStackTrace(System.err);
            haveMinXalanVersion = false;
        }
        return haveMinXalanVersion;
    }

    protected static String getJAXPParserLocation() {
        if (!XML.classpathHasXalanAndJAXP()) {
            return null;
        }
        return JAXPFinder.getJAXPParserLocation();
    }
}

