/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.junit;

import com.pivotal.gemfirexd.internal.tools.sysinfo;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import org.apache.derbyTesting.junit.BaseTestCase;
import org.apache.derbyTesting.junit.NetworkServerTestSetup;

public class Utilities {
    public static String stringToHexLiteral(String s) {
        String hexLiteral = null;
        try {
            byte[] bytes = s.getBytes("UTF-16BE");
            hexLiteral = Utilities.convertToHexString(bytes);
        }
        catch (UnsupportedEncodingException ue) {
            System.out.println("This shouldn't happen as UTF-16BE should be supported");
            ue.printStackTrace();
        }
        return hexLiteral;
    }

    private static String convertToHexString(byte[] buf) {
        StringBuilder str = new StringBuilder();
        str.append("X'");
        for (int i = 0; i < buf.length; ++i) {
            int byteVal = buf[i] & 0xFF;
            String val = Integer.toHexString(byteVal);
            if (val.length() < 2) {
                str.append("0");
            }
            str.append(val);
        }
        return str.toString() + "'";
    }

    public static String repeatChar(String c, int repeatCount) {
        char ch = c.charAt(0);
        char[] chArray = new char[repeatCount];
        for (int i = 0; i < repeatCount; ++i) {
            chArray[i] = ch;
        }
        return new String(chArray);
    }

    public static void showResultSet(ResultSet rs) throws SQLException {
        System.out.print("{");
        int row = 0;
        boolean next = rs.next();
        while (next) {
            ++row;
            ResultSetMetaData rsmd = rs.getMetaData();
            int nocols = rsmd.getColumnCount();
            System.out.print("{");
            for (int i = 0; i < nocols; ++i) {
                String val = rs.getString(i + 1);
                if (val == null) {
                    System.out.print("null");
                } else {
                    System.out.print("\"" + rs.getString(i + 1) + "\"");
                }
                if (i == nocols - 1) {
                    System.out.print("}");
                    continue;
                }
                System.out.print(",");
            }
            next = rs.next();
            if (next) {
                System.out.println(",");
                continue;
            }
            System.out.println("};\n");
        }
    }

    public static Process execJavaCmd(String[] args) throws IOException, InterruptedException {
        int totalSize = 3 + args.length;
        String[] cmd = new String[totalSize];
        cmd[0] = "java";
        cmd[1] = "-classpath";
        cmd[2] = BaseTestCase.getSystemProperty("java.class.path");
        System.arraycopy(args, 0, cmd, 3, args.length);
        final String[] command = cmd;
        Process pr = null;
        try {
            pr = (Process)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException {
                    Process result = null;
                    result = Runtime.getRuntime().exec(command);
                    return result;
                }
            });
        }
        catch (PrivilegedActionException pe) {
            Exception e = pe.getException();
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            throw (SecurityException)e;
        }
        return pr;
    }

    public static BufferedReader getSysinfoLocally() {
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream(20480);
        PrintWriter pw = new PrintWriter(byteStream, true);
        sysinfo.getInfo((PrintWriter)pw);
        pw.flush();
        pw.close();
        byte[] outBytes = byteStream.toByteArray();
        BufferedReader sysinfoOutput = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(outBytes)));
        return sysinfoOutput;
    }

    public static BufferedReader getSysinfoFromServer() throws Exception {
        return new BufferedReader(new StringReader(NetworkServerTestSetup.getNetworkServerControl().getSysinfo()));
    }
}

