/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.junit;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.RuntimeStatisticsParser;

public class SQLUtilities {
    public static String VALID_DATE_STRING = "'2000-01-01'";
    public static String VALID_TIME_STRING = "'15:30:20'";
    public static String VALID_TIMESTAMP_STRING = "'2000-01-01 15:30:20'";
    public static String NULL_VALUE = "NULL";
    public static String[] allDataTypesColumnNames = new String[]{"SMALLINTCOL", "INTEGERCOL", "BIGINTCOL", "DECIMALCOL", "REALCOL", "DOUBLECOL", "CHARCOL", "VARCHARCOL", "LONGVARCHARCOL", "CHARFORBITCOL", "VARCHARFORBITCOL", "LVARCHARFORBITCOL", "CLOBCOL", "DATECOL", "TIMECOL", "TIMESTAMPCOL", "BLOBCOL"};
    private static String[][] allDataTypesSQLData = new String[][]{{NULL_VALUE, "0", "1", "2"}, {NULL_VALUE, "0", "1", "21"}, {NULL_VALUE, "0", "1", "22"}, {NULL_VALUE, "0.0", "1.0", "23.0"}, {NULL_VALUE, "0.0", "1.0", "24.0"}, {NULL_VALUE, "0.0", "1.0", "25.0"}, {NULL_VALUE, "'0'", "'aa'", "'2.0'"}, {NULL_VALUE, "'0'", "'aa'", VALID_TIME_STRING}, {NULL_VALUE, "'0'", "'aa'", VALID_TIMESTAMP_STRING}, {NULL_VALUE, "X'10aa'", NULL_VALUE, "X'10aaaa'"}, {NULL_VALUE, "X'10aa'", NULL_VALUE, "X'10aaba'"}, {NULL_VALUE, "X'10aa'", NULL_VALUE, "X'10aaca'"}, {NULL_VALUE, "'13'", "'14'", NULL_VALUE}, {NULL_VALUE, VALID_DATE_STRING, VALID_DATE_STRING, NULL_VALUE}, {NULL_VALUE, VALID_TIME_STRING, VALID_TIME_STRING, VALID_TIME_STRING}, {NULL_VALUE, VALID_TIMESTAMP_STRING, VALID_TIMESTAMP_STRING, VALID_TIMESTAMP_STRING}, {NULL_VALUE, NULL_VALUE, NULL_VALUE, NULL_VALUE}};
    public static String[] SQLTypes = new String[]{"SMALLINT", "INTEGER", "BIGINT", "DECIMAL(10,5)", "REAL", "DOUBLE", "CHAR(60)", "VARCHAR(60)", "LONG VARCHAR", "CHAR(60) FOR BIT DATA", "VARCHAR(60) FOR BIT DATA", "LONG VARCHAR FOR BIT DATA", "CLOB(1k)", "DATE", "TIME", "TIMESTAMP", "BLOB(1k)"};

    public static void createAndPopulateAllDataTypesTable(Statement s) throws SQLException {
        try {
            s.executeUpdate("DROP TABLE AllDataTypesTable");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        StringBuilder createSQL = new StringBuilder("create table AllDataTypesTable (");
        for (int type = 0; type < SQLTypes.length - 1; ++type) {
            createSQL.append(allDataTypesColumnNames[type] + " " + SQLTypes[type] + ",");
        }
        createSQL.append(allDataTypesColumnNames[SQLTypes.length - 1] + " " + SQLTypes[SQLTypes.length - 1] + ")");
        s.executeUpdate(createSQL.toString());
        for (int row = 0; row < allDataTypesSQLData[0].length; ++row) {
            createSQL = new StringBuilder("insert into AllDataTypesTable values(");
            for (int type = 0; type < SQLTypes.length - 1; ++type) {
                createSQL.append(allDataTypesSQLData[type][row] + ",");
            }
            createSQL.append(allDataTypesSQLData[SQLTypes.length - 1][row] + ")");
            s.executeUpdate(createSQL.toString());
        }
    }

    public static RuntimeStatisticsParser getRuntimeStatisticsParser(Statement s) throws SQLException {
        ResultSet rs = s.executeQuery("values SYSCS_UTIL.GET_RUNTIMESTATISTICS()");
        rs.next();
        String rts = rs.getString(1);
        rs.close();
        return new RuntimeStatisticsParser(rts);
    }

    public static RuntimeStatisticsParser executeAndGetRuntimeStatistics(Connection conn, String sql) throws SQLException {
        Statement s = conn.createStatement();
        Statement s2 = conn.createStatement();
        CallableStatement cs = conn.prepareCall("call SYSCS_UTIL.SET_RUNTIMESTATISTICS(1)");
        cs.execute();
        cs.close();
        s.execute(sql);
        ResultSet rs = s.getResultSet();
        if (rs != null) {
            JDBC.assertDrainResults(rs);
        }
        RuntimeStatisticsParser parser = SQLUtilities.getRuntimeStatisticsParser(s2);
        s.close();
        s2.close();
        return parser;
    }
}

