/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.junit;

import java.util.HashSet;
import java.util.StringTokenizer;
import org.apache.derbyTesting.junit.BaseTestCase;

public class RuntimeStatisticsParser {
    private int isolationLevel = 0;
    private boolean distinctScan = false;
    private boolean eliminatedDuplicates = false;
    private boolean tableScan = false;
    private final boolean indexScan;
    private final boolean indexRowToBaseRow;
    private String statistics = "";
    private boolean scrollInsensitive = false;
    private final HashSet qualifiers;

    public RuntimeStatisticsParser(String rts) {
        this.statistics = rts;
        if (rts.indexOf(" at serializable isolation level ") != -1) {
            this.isolationLevel = 8;
        } else if (rts.indexOf("at read uncommitted isolation level") != -1) {
            this.isolationLevel = 1;
        } else if (rts.indexOf("at read committed isolation level") != -1) {
            this.isolationLevel = 2;
        } else if (rts.indexOf("at repeatable read isolation level") != -1) {
            this.isolationLevel = 4;
        }
        if (rts.indexOf("Distinct Scan ResultSet") > 0) {
            this.distinctScan = true;
        }
        if (rts.indexOf("Table Scan ResultSet") > 0) {
            this.tableScan = true;
        }
        this.indexScan = rts.indexOf("Index Scan ResultSet") >= 0;
        boolean bl = this.indexRowToBaseRow = rts.indexOf("Index Row to Base Row ResultSet") >= 0;
        if (rts.indexOf("Eliminate duplicates = true") > 0) {
            this.eliminatedDuplicates = true;
        }
        if (rts.indexOf("Scroll Insensitive ResultSet:") > 0) {
            this.scrollInsensitive = true;
        }
        this.qualifiers = this.findQualifiers();
    }

    private HashSet findQualifiers() {
        HashSet<Qualifier> set = new HashSet<Qualifier>();
        int startPos = this.statistics.indexOf("qualifiers:\n");
        if (startPos >= 0) {
            String searchString = this.statistics.substring(startPos + 12);
            StringTokenizer t = new StringTokenizer(searchString, "\n");
            while (t.hasMoreTokens()) {
                String s = t.nextToken();
                if (!s.startsWith("Operator: ")) continue;
                String operator = s.substring(10);
                t.nextToken();
                t.nextToken();
                s = t.nextToken();
                if (!s.startsWith("Negate comparison result: ")) {
                    throw new AssertionError((Object)"Expected to find \"Negate comparison result\"");
                }
                boolean negated = Boolean.valueOf(s.substring(26));
                set.add(new Qualifier(operator, negated));
            }
        }
        return set;
    }

    public int getIsolationLevel() {
        return this.isolationLevel;
    }

    public boolean usedDistinctScan() {
        return this.distinctScan;
    }

    public boolean usedTableScan() {
        return this.tableScan;
    }

    public boolean usedIndexScan() {
        return this.indexScan;
    }

    public boolean usedIndexRowToBaseRow() {
        return this.indexRowToBaseRow;
    }

    public boolean eliminatedDuplicates() {
        return this.eliminatedDuplicates;
    }

    public boolean isScrollInsensitive() {
        return this.scrollInsensitive;
    }

    public boolean hasGreaterThanOrEqualQualifier() {
        return this.qualifiers.contains(new Qualifier("<", true));
    }

    public boolean hasLessThanQualifier() {
        return this.qualifiers.contains(new Qualifier("<", false));
    }

    public boolean rowsQualifiedEquals(int qualRows) {
        boolean retVal;
        boolean bl = retVal = this.statistics.indexOf("Number of rows qualified=" + qualRows + "\n") != -1;
        if (!retVal) {
            BaseTestCase.println("RuntimeStatisticsParser#rowsQualifiedEquals expects " + qualRows + " rows qualified in " + this.statistics);
        }
        return retVal;
    }

    private static class Qualifier {
        String operator;
        boolean negated;

        Qualifier(String operator, boolean negated) {
            this.operator = operator;
            this.negated = negated;
        }

        public int hashCode() {
            if (this.negated) {
                return ~this.operator.hashCode();
            }
            return this.operator.hashCode();
        }

        public boolean equals(Object o) {
            if (o instanceof Qualifier) {
                Qualifier q = (Qualifier)o;
                return this.negated == q.negated && this.operator.equals(q.operator);
            }
            return false;
        }

        public String toString() {
            return (this.negated ? "\u00ac" : "") + this.operator;
        }
    }
}

