/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.junit;

import com.pivotal.gemfirexd.internal.drda.NetworkServerControl;
import com.pivotal.gemfirexd.internal.engine.store.GemFireStore;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.sql.DriverManager;
import java.util.ArrayList;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseTestCase;
import org.apache.derbyTesting.junit.BaseTestSetup;
import org.apache.derbyTesting.junit.SpawnedProcess;
import org.apache.derbyTesting.junit.TestConfiguration;

public final class NetworkServerTestSetup
extends BaseTestSetup {
    private static final long WAIT_TIME = 40000L;
    private static final int SLEEP_TIME = 100;
    public static final String HOST_OPTION = "-h";
    private static long waitTime = 40000L;
    private FileOutputStream serverOutput;
    private final boolean asCommand;
    private final boolean startServerAtSetup;
    private final boolean useSeparateProcess;
    private final boolean serverShouldComeUp;
    private final String[] systemProperties;
    private String[] startupArgs;
    private SpawnedProcess spawnedServer;
    private NetworkServerControl networkServerController;

    public NetworkServerTestSetup(Test test, boolean asCommand) {
        super(test);
        this.asCommand = asCommand;
        this.systemProperties = null;
        this.startupArgs = null;
        this.useSeparateProcess = false;
        this.serverShouldComeUp = true;
        this.startServerAtSetup = true;
    }

    public NetworkServerTestSetup(Test test, boolean asCommand, boolean startServerAtSetup) {
        super(test);
        this.asCommand = asCommand;
        this.systemProperties = null;
        this.startupArgs = null;
        this.useSeparateProcess = false;
        this.serverShouldComeUp = true;
        this.startServerAtSetup = startServerAtSetup;
    }

    public NetworkServerTestSetup(Test test, String[] systemProperties, String[] startupArgs, boolean serverShouldComeUp) {
        super(test);
        this.asCommand = true;
        this.systemProperties = systemProperties;
        this.startupArgs = startupArgs;
        this.useSeparateProcess = true;
        this.serverShouldComeUp = serverShouldComeUp;
        this.startServerAtSetup = true;
    }

    protected void setUp() throws Exception {
        BaseTestCase.println("Starting network server:");
        this.networkServerController = NetworkServerTestSetup.getNetworkServerControl();
        if (this.startServerAtSetup) {
            if (this.useSeparateProcess) {
                this.spawnedServer = this.startSeparateProcess();
            } else if (this.asCommand) {
                this.startWithCommand();
            } else {
                this.startWithAPI();
            }
            if (this.serverShouldComeUp && !NetworkServerTestSetup.pingForServerStart(this.networkServerController)) {
                String msg = "Timed out waiting for network server to start";
                if (this.spawnedServer != null) {
                    this.spawnedServer.complete(true);
                    msg = this.spawnedServer.getFailMessage(msg);
                    this.spawnedServer = null;
                }
                NetworkServerTestSetup.fail((String)msg);
            }
        }
    }

    private void startWithAPI() throws Exception {
        System.setProperty("gemfire.mcast-port", "0");
        if (GemFireStore.getBootingInstance() == null) {
            DriverManager.getConnection("jdbc:gemfirexd:");
        }
        this.serverOutput = (FileOutputStream)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                File logs = new File("logs");
                logs.mkdir();
                File console = new File(logs, "serverConsoleOutput.log");
                FileOutputStream fos = null;
                try {
                    fos = new FileOutputStream(console.getPath(), true);
                }
                catch (FileNotFoundException ex) {
                    ex.printStackTrace();
                }
                return fos;
            }
        });
        this.networkServerController.start(new PrintWriter(this.serverOutput));
    }

    private void startWithCommand() throws Exception {
        TestConfiguration config = TestConfiguration.getCurrent();
        System.setProperty("gemfire.mcast-port", "0");
        if (GemFireStore.getBootingInstance() == null) {
            DriverManager.getConnection("jdbc:gemfirexd:");
        }
        new Thread(new Runnable(){

            @Override
            public void run() {
                String[] args = NetworkServerTestSetup.getDefaultStartupArgs(false);
                NetworkServerControl.main((String[])args);
            }
        }, "NetworkServerTestSetup command").start();
    }

    private SpawnedProcess startSeparateProcess() throws Exception {
        Process serverProcess;
        int i;
        int i2;
        int i3;
        ArrayList<String> al = new ArrayList<String>();
        String classpath = BaseTestCase.getSystemProperty("java.class.path");
        boolean skipHostName = false;
        al.add("java");
        al.add("-classpath");
        al.add(classpath);
        boolean setNoSecurityManager = true;
        for (i3 = 0; i3 < this.systemProperties.length; ++i3) {
            if (!this.systemProperties[i3].startsWith("java.security.")) continue;
            setNoSecurityManager = false;
            break;
        }
        for (i3 = 0; i3 < this.startupArgs.length; ++i3) {
            if (!this.startupArgs[i3].equals("-noSecurityManager")) continue;
            setNoSecurityManager = false;
            break;
        }
        if (setNoSecurityManager) {
            String[] newArgs = new String[this.startupArgs.length + 1];
            System.arraycopy(this.startupArgs, 0, newArgs, 0, this.startupArgs.length);
            newArgs[newArgs.length - 1] = "-noSecurityManager";
            this.startupArgs = newArgs;
        }
        int count = this.systemProperties.length;
        for (i2 = 0; i2 < count; ++i2) {
            al.add("-D" + this.systemProperties[i2]);
        }
        al.add("-Dgemfire.mcast-port=0");
        al.add("com.pivotal.gemfirexd.internal.drda.NetworkServerControl");
        count = this.startupArgs.length;
        for (i2 = 0; i2 < count; ++i2) {
            if (!HOST_OPTION.equals(this.startupArgs[i2])) continue;
            skipHostName = true;
        }
        String[] defaultArgs = NetworkServerTestSetup.getDefaultStartupArgs(skipHostName);
        count = defaultArgs.length;
        for (i = 0; i < count; ++i) {
            al.add(defaultArgs[i]);
        }
        count = this.startupArgs.length;
        for (i = 0; i < count; ++i) {
            al.add(this.startupArgs[i]);
        }
        final String[] command = new String[al.size()];
        al.toArray(command);
        NetworkServerTestSetup.stopGemFireXDServer();
        try {
            serverProcess = (Process)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException {
                    return Runtime.getRuntime().exec(command);
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw e.getException();
        }
        return new SpawnedProcess(serverProcess, "SpawnedNetworkServer");
    }

    public SpawnedProcess getServerProcess() {
        return this.spawnedServer;
    }

    protected void tearDown() throws Exception {
        if (this.networkServerController != null) {
            boolean running = false;
            try {
                this.networkServerController.ping();
                running = true;
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (running) {
                try {
                    this.networkServerController.shutdown();
                }
                catch (Throwable t) {
                    t.printStackTrace(System.out);
                }
            }
            if (this.serverOutput != null) {
                this.serverOutput.close();
            }
            this.networkServerController = null;
            this.serverOutput = null;
            if (this.spawnedServer != null) {
                this.spawnedServer.complete(false);
                this.spawnedServer = null;
            }
        }
    }

    public static String[] getDefaultStartupArgs(boolean skipHostName) {
        TestConfiguration config = TestConfiguration.getCurrent();
        ArrayList<String> argsList = new ArrayList<String>();
        argsList.add("start");
        if (!skipHostName) {
            argsList.add(HOST_OPTION);
            argsList.add(config.getHostName());
        }
        argsList.add("-p");
        argsList.add(Integer.toString(config.getPort()));
        if (config.getSsl() != null) {
            argsList.add("-ssl");
            argsList.add(config.getSsl());
        }
        String[] retval = new String[argsList.size()];
        argsList.toArray(retval);
        return retval;
    }

    public static NetworkServerControl getNetworkServerControl() throws Exception {
        TestConfiguration config = TestConfiguration.getCurrent();
        InetAddress host = InetAddress.getByName(config.getHostName());
        int port = config.getPort();
        String user = config.getUserName();
        String password = config.getUserPassword();
        if (config.getSsl() == null) {
            return new NetworkServerControl(host, port, user, password);
        }
        String oldValue = BaseTestCase.getSystemProperty("gemfirexd.drda.sslMode");
        BaseTestCase.setSystemProperty("gemfirexd.drda.sslMode", config.getSsl());
        NetworkServerControl control = new NetworkServerControl(host, port, user, password);
        if (oldValue == null) {
            BaseTestCase.removeSystemProperty("gemfirexd.drda.sslMode");
        } else {
            BaseTestCase.setSystemProperty("gemfirexd.drda.sslMode", oldValue);
        }
        return control;
    }

    public static NetworkServerControl getNetworkServerControl(int port) throws Exception {
        TestConfiguration config = TestConfiguration.getCurrent();
        InetAddress host = InetAddress.getByName(config.getHostName());
        String user = config.getUserName();
        String password = config.getUserPassword();
        return new NetworkServerControl(host, port, user, password);
    }

    public static NetworkServerControl getNetworkServerControlDefault() throws Exception {
        TestConfiguration config = TestConfiguration.getCurrent();
        String user = config.getUserName();
        String password = config.getUserPassword();
        return new NetworkServerControl(user, password);
    }

    public static void waitForServerStart(NetworkServerControl networkServerController) throws InterruptedException {
        if (!NetworkServerTestSetup.pingForServerStart(networkServerController)) {
            NetworkServerTestSetup.fail((String)"Timed out waiting for network server to start");
        }
    }

    public static void setWaitTime(long newWaitTime) {
        waitTime = newWaitTime;
    }

    public static void setDefaultWaitTime() {
        waitTime = 40000L;
    }

    public static boolean pingForServerUp(NetworkServerControl networkServerController, Process serverProcess, boolean expectServerUp) throws InterruptedException {
        long startTime = System.currentTimeMillis();
        while (true) {
            try {
                networkServerController.ping();
                if (expectServerUp) {
                    return true;
                }
                if (System.currentTimeMillis() - startTime > waitTime) {
                    return true;
                }
            }
            catch (Throwable e) {
                if (!NetworkServerTestSetup.vetPing(e)) {
                    e.printStackTrace(System.out);
                    return false;
                }
                if (expectServerUp) {
                    if (System.currentTimeMillis() - startTime > waitTime) {
                        return false;
                    }
                }
                return false;
            }
            if (serverProcess != null) {
                try {
                    int exitVal = serverProcess.exitValue();
                    return false;
                }
                catch (IllegalThreadStateException exitVal) {
                }
                catch (Throwable t) {
                    t.printStackTrace(System.out);
                    return false;
                }
            }
            Thread.sleep(100L);
        }
    }

    private static boolean vetPing(Throwable t) {
        if (!t.getClass().getName().equals("java.lang.Exception")) {
            return false;
        }
        return t.getMessage().startsWith("DRDA_NoIO.S:Could not connect to ");
    }

    private static boolean isDRDAerror(Throwable t) {
        if (!t.getClass().getName().equals("java.lang.Exception")) {
            return false;
        }
        return t.getMessage().startsWith("DRDA");
    }

    public static boolean pingForServerStart(NetworkServerControl control) throws InterruptedException {
        return NetworkServerTestSetup.pingForServerUp(control, null, true);
    }
}

