/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.junit;

import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.sql.SQLException;
import java.util.HashMap;
import javax.sql.DataSource;
import junit.framework.Assert;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.TestConfiguration;

public class JDBCDataSource {
    public static DataSource getDataSource() {
        return JDBCDataSource.getDataSource(TestConfiguration.getCurrent(), null);
    }

    public static DataSource getDataSource(String dbName) {
        DataSource ds = JDBCDataSource.getDataSource();
        JDBCDataSource.setBeanProperty(ds, "databaseName", dbName);
        return ds;
    }

    public static DataSource getDataSourceLogical(String logicalDatabasename) {
        DataSource ds = JDBCDataSource.getDataSource();
        TestConfiguration current = TestConfiguration.getCurrent();
        String physicalName = current.getPhysicalDatabaseName(logicalDatabasename);
        JDBCDataSource.setBeanProperty(ds, "databaseName", physicalName);
        return ds;
    }

    static DataSource getDataSource(TestConfiguration config, HashMap beanProperties) {
        return (DataSource)JDBCDataSource.getDataSource(config, beanProperties, config.getJDBCClient().getDataSourceClassName());
    }

    static Object getDataSource(TestConfiguration config, HashMap beanProperties, String dsClassName) {
        if (beanProperties == null) {
            beanProperties = JDBCDataSource.getDataSourceProperties(config);
        }
        return (DataSource)JDBCDataSource.getDataSourceObject(dsClassName, beanProperties);
    }

    static HashMap getDataSourceProperties(TestConfiguration config) {
        HashMap<String, Object> beanProperties = new HashMap<String, Object>();
        if (!config.getJDBCClient().isEmbedded()) {
            beanProperties.put("serverName", config.getHostName());
            beanProperties.put("portNumber", new Integer(config.getPort()));
        }
        beanProperties.put("user", config.getUserName());
        beanProperties.put("password", config.getUserPassword());
        beanProperties.put("connectionAttributes", "mcast-port=0;host-data=true");
        return beanProperties;
    }

    static Object getDataSourceObject(String classname, HashMap beanProperties) {
        ClassLoader contextLoader = (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return Thread.currentThread().getContextClassLoader();
            }
        });
        try {
            Object ds = null;
            if (contextLoader != null) {
                try {
                    ds = Class.forName(classname, true, contextLoader).newInstance();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (ds == null) {
                ds = Class.forName(classname).newInstance();
            }
            for (String property : beanProperties.keySet()) {
                Object value = beanProperties.get(property);
                JDBCDataSource.setBeanProperty(ds, property, value);
            }
            return ds;
        }
        catch (Exception e) {
            Assert.fail((String)e.toString());
            return null;
        }
    }

    public static void setBeanProperty(Object ds, String property, Object value) {
        String setterName = JDBCDataSource.getSetterName(property);
        Class<Object> clazz = value.getClass();
        if (Integer.class.equals(clazz)) {
            clazz = Integer.TYPE;
        } else if (Boolean.class.equals(clazz)) {
            clazz = Boolean.TYPE;
        }
        try {
            Method setter = ds.getClass().getMethod(setterName, clazz);
            setter.invoke(ds, value);
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
    }

    public static Object getBeanProperty(Object ds, String property) throws Exception {
        String getterName = JDBCDataSource.getGetterName(property);
        Method getter = ds.getClass().getMethod(getterName, new Class[0]);
        return getter.invoke(ds, new Object[0]);
    }

    public static void clearStringBeanProperty(Object ds, String property) {
        String setterName = JDBCDataSource.getSetterName(property);
        try {
            Method setter = ds.getClass().getMethod(setterName, String.class);
            setter.invoke(ds, new Object[]{null});
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
    }

    private static String getSetterName(String attribute) {
        return "set" + Character.toUpperCase(attribute.charAt(0)) + attribute.substring(1);
    }

    private static String getGetterName(String attribute) {
        return "get" + Character.toUpperCase(attribute.charAt(0)) + attribute.substring(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void shutdownDatabase(DataSource ds) {
        JDBCDataSource.setBeanProperty(ds, "shutdownDatabase", "shutdown");
        try {
            ds.getConnection();
            Assert.fail((String)"Database failed to shut down");
        }
        catch (SQLException e) {
            BaseJDBCTestCase.assertSQLState("Database shutdown", "XJ015", e);
        }
        finally {
            JDBCDataSource.clearStringBeanProperty(ds, "shutdownDatabase");
        }
    }
}

