/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.junit;

import junit.framework.Assert;
import org.apache.derbyTesting.junit.JDBC;

public final class JDBCClient {
    static final JDBCClient EMBEDDED_30 = new JDBCClient("Embedded_30", "com.pivotal.gemfirexd.jdbc.EmbeddedDriver", "com.pivotal.gemfirexd.internal.jdbc.EmbeddedDataSource", "com.pivotal.gemfirexd.internal.jdbc.EmbeddedConnectionPoolDataSource", "com.pivotal.gemfirexd.internal.jdbc.EmbeddedXADataSource", "jdbc:gemfirexd:");
    static final JDBCClient EMBEDDED_40 = new JDBCClient("Embedded_40", "com.pivotal.gemfirexd.jdbc.EmbeddedDriver", "com.pivotal.gemfirexd.internal.jdbc.EmbeddedDataSource40", "com.pivotal.gemfirexd.internal.jdbc.EmbeddedConnectionPoolDataSource40", "com.pivotal.gemfirexd.internal.jdbc.EmbeddedXADataSource40", "jdbc:gemfirexd:");
    private static final JDBCClient EMBEDDED_169 = new JDBCClient("Embedded_169", null, "com.pivotal.gemfirexd.internal.jdbc.EmbeddedSimpleDataSource", null, null, null);
    static final JDBCClient DERBYNETCLIENT = new JDBCClient("DerbyNetClient", "com.pivotal.gemfirexd.jdbc.ClientDriver", JDBC.vmSupportsJDBC4() ? "com.pivotal.gemfirexd.internal.jdbc.ClientDataSource40" : "com.pivotal.gemfirexd.internal.jdbc.ClientDataSource", JDBC.vmSupportsJDBC4() ? "com.pivotal.gemfirexd.internal.jdbc.ClientConnectionPoolDataSource40" : "com.pivotal.gemfirexd.internal.jdbc.ClientConnectionPoolDataSource", JDBC.vmSupportsJDBC4() ? "com.pivotal.gemfirexd.internal.jdbc.ClientXADataSource40" : "com.pivotal.gemfirexd.internal.jdbc.ClientXADataSource", "jdbc:gemfirexd://");
    static final JDBCClient DERBYNETCLIENT_30 = new JDBCClient("DerbyNetClient", "com.pivotal.gemfirexd.jdbc.ClientDriver", "com.pivotal.gemfirexd.internal.jdbc.ClientDataSource", "com.pivotal.gemfirexd.internal.jdbc.ClientConnectionPoolDataSource", "com.pivotal.gemfirexd.internal.jdbc.ClientXADataSource", "jdbc:gemfirexd://");
    static final JDBCClient DB2CLIENT = new JDBCClient("DB2Client", "com.ibm.db2.jcc.DB2Driver", null, null, null, "jdbc:gemfirexd:net://");
    private final String frameWork;
    private final String driverClassName;
    private final String dsClassName;
    private final String poolDsClassName;
    private final String xaDsClassName;
    private final String urlBase;

    static JDBCClient getDefaultEmbedded() {
        if (JDBC.vmSupportsJDBC4()) {
            return EMBEDDED_40;
        }
        if (JDBC.vmSupportsJDBC2()) {
            return EMBEDDED_30;
        }
        if (JDBC.vmSupportsJSR169()) {
            return EMBEDDED_169;
        }
        Assert.fail((String)"Unknown JVM environment");
        return null;
    }

    public boolean isEmbedded() {
        return this.getName().startsWith("Embedded");
    }

    public boolean isDerbyNetClient() {
        return this.getName().equals(DERBYNETCLIENT.getName());
    }

    public boolean isDB2Client() {
        return this.getName().equals(DB2CLIENT.getName());
    }

    public String getName() {
        return this.frameWork;
    }

    public String getJDBCDriverName() {
        return this.driverClassName;
    }

    public String getDataSourceClassName() {
        return this.dsClassName;
    }

    public String getConnectionPoolDataSourceClassName() {
        return this.poolDsClassName;
    }

    public String getXADataSourceClassName() {
        return this.xaDsClassName;
    }

    public String getUrlBase() {
        return this.urlBase;
    }

    public String toString() {
        return this.frameWork;
    }

    private JDBCClient(String frameWork, String driverClassName, String dataSourceClassName, String connectionPoolDataSourceClassName, String xaDataSourceClassName, String urlBase) {
        this.frameWork = frameWork;
        this.driverClassName = driverClassName;
        this.dsClassName = dataSourceClassName;
        this.poolDsClassName = connectionPoolDataSourceClassName;
        this.xaDsClassName = xaDataSourceClassName;
        this.urlBase = urlBase;
    }
}

