/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.junit;

import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.internal.cache.CacheObserver;
import com.gemstone.gemfire.internal.cache.CacheObserverAdapter;
import com.gemstone.gemfire.internal.cache.CacheObserverHolder;
import com.gemstone.gemfire.internal.cache.EntryEventImpl;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.OffHeapRegionEntry;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gemfire.internal.cache.RegionEntry;
import com.gemstone.gemfire.internal.cache.TXStateProxy;
import com.gemstone.gemfire.internal.cache.Token;
import com.gemstone.gemfire.internal.offheap.OffHeapRegionEntryHelper;
import com.gemstone.gemfire.internal.offheap.SimpleMemoryAllocatorImpl;
import com.gemstone.gemfire.internal.shared.ClientSharedUtils;
import com.gemstone.gemfire.internal.util.ArrayUtils;
import com.gemstone.gnu.trove.THashMap;
import com.pivotal.gemfirexd.callbacks.Event;
import com.pivotal.gemfirexd.execute.CallbackStatement;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserver;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserverHolder;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.engine.access.index.OpenMemIndex;
import com.pivotal.gemfirexd.internal.engine.distributed.GfxdConnectionWrapper;
import com.pivotal.gemfirexd.internal.engine.distributed.message.StatementExecutorMessage;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.ComparisonQueryInfo;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.QueryInfo;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.SelectQueryInfo;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.SubQueryInfo;
import com.pivotal.gemfirexd.internal.engine.procedure.ProcedureChunkMessage;
import com.pivotal.gemfirexd.internal.engine.procedure.cohort.ProcedureSender;
import com.pivotal.gemfirexd.internal.engine.sql.conn.GfxdHeapThresholdListener;
import com.pivotal.gemfirexd.internal.engine.sql.execute.AbstractGemFireActivation;
import com.pivotal.gemfirexd.internal.engine.sql.execute.AbstractGemFireResultSet;
import com.pivotal.gemfirexd.internal.engine.store.CompactCompositeIndexKey;
import com.pivotal.gemfirexd.internal.engine.store.GemFireContainer;
import com.pivotal.gemfirexd.internal.engine.store.RowFormatter;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.sql.Activation;
import com.pivotal.gemfirexd.internal.iapi.sql.ParameterValueSet;
import com.pivotal.gemfirexd.internal.iapi.sql.ResultSet;
import com.pivotal.gemfirexd.internal.iapi.sql.conn.LanguageConnectionContext;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.TriggerDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ExecRow;
import com.pivotal.gemfirexd.internal.iapi.store.access.ColumnOrdering;
import com.pivotal.gemfirexd.internal.iapi.store.access.conglomerate.Conglomerate;
import com.pivotal.gemfirexd.internal.iapi.types.RowLocation;
import com.pivotal.gemfirexd.internal.impl.jdbc.EmbedConnection;
import com.pivotal.gemfirexd.internal.impl.jdbc.EmbedPreparedStatement;
import com.pivotal.gemfirexd.internal.impl.jdbc.EmbedResultSet;
import com.pivotal.gemfirexd.internal.impl.jdbc.EmbedStatement;
import com.pivotal.gemfirexd.internal.impl.sql.GenericParameterValueSet;
import com.pivotal.gemfirexd.internal.impl.sql.GenericPreparedStatement;
import com.pivotal.gemfirexd.internal.impl.sql.StatementStats;
import com.pivotal.gemfirexd.internal.impl.sql.compile.DropTableNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.FromBaseTable;
import com.pivotal.gemfirexd.internal.impl.sql.compile.SelectNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.StatementNode;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.Serializable;
import java.sql.BatchUpdateException;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import junit.framework.Assert;
import junit.framework.AssertionFailedError;

public class JDBC {
    public static final String[] GET_TABLES_TABLE = new String[]{"TABLE"};
    public static final String[] GET_TABLES_VIEW = new String[]{"VIEW"};
    public static final String[] GET_TABLES_SYNONYM = new String[]{"SYNONYM"};
    public static final int SQLXML = 2009;
    private static final boolean HAVE_DRIVER = JDBC.haveClass("java.sql.Driver");
    private static final boolean HAVE_SAVEPOINT = JDBC.haveClass("java.sql.Savepoint");
    private static final boolean HAVE_SQLXML = JDBC.haveClass("java.sql.SQLXML");

    static boolean haveClass(String className) {
        try {
            Class.forName(className);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean vmSupportsJDBC4() {
        return HAVE_DRIVER && HAVE_SQLXML;
    }

    public static boolean vmSupportsJDBC3() {
        return HAVE_DRIVER && HAVE_SAVEPOINT;
    }

    public static boolean vmSupportsJDBC2() {
        return HAVE_DRIVER;
    }

    public static boolean vmSupportsJSR169() {
        return !HAVE_DRIVER && HAVE_SAVEPOINT;
    }

    public static void cleanup(Connection conn) throws SQLException {
        if (conn == null) {
            return;
        }
        if (conn.isClosed()) {
            return;
        }
        SQLException sqle = null;
        try {
            conn.rollback();
        }
        catch (SQLException e) {
            sqle = e;
        }
        try {
            conn.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public static void dropSchema(DatabaseMetaData dmd, String schema) throws SQLException {
        Statement s;
        Connection conn;
        block6: {
            LanguageConnectionContext lcc;
            boolean doDrop;
            conn = dmd.getConnection();
            s = dmd.getConnection().createStatement();
            PreparedStatement psf = conn.prepareStatement("SELECT ALIAS FROM SYS.SYSALIASES A, SYS.SYSSCHEMAS S WHERE A.SCHEMAID = S.SCHEMAID  AND CHAR(A.ALIASTYPE) = ?  AND S.SCHEMANAME = ?");
            psf.setString(1, "F");
            psf.setString(2, schema);
            java.sql.ResultSet rs = psf.executeQuery();
            JDBC.dropUsingDMD(s, rs, schema, "ALIAS", "FUNCTION");
            psf.setString(1, "R");
            psf.setString(2, schema);
            rs = psf.executeQuery();
            JDBC.dropUsingDMD(s, rs, schema, "ALIAS", "ALIAS");
            rs = dmd.getProcedures(null, schema, null);
            JDBC.dropUsingDMD(s, rs, schema, "PROCEDURE_NAME", "PROCEDURE");
            rs = dmd.getTables(null, schema, null, GET_TABLES_VIEW);
            JDBC.dropUsingDMD(s, rs, schema, "TABLE_NAME", "VIEW");
            rs = dmd.getTables(null, schema, null, GET_TABLES_TABLE);
            JDBC.dropUsingDMD(s, rs, schema, "TABLE_NAME", "TABLE");
            java.sql.ResultSet table_rs = dmd.getTables(null, schema, null, GET_TABLES_TABLE);
            while (table_rs.next()) {
                String tablename = table_rs.getString("TABLE_NAME");
                rs = dmd.getExportedKeys(null, schema, tablename);
                while (rs.next()) {
                    String fkName;
                    short keyPosition = rs.getShort("KEY_SEQ");
                    if (keyPosition != 1 || (fkName = rs.getString("FK_NAME")) == null) continue;
                    String fkSchema = rs.getString("FKTABLE_SCHEM");
                    String fkTable = rs.getString("FKTABLE_NAME");
                    String ddl = "ALTER TABLE " + JDBC.escape(fkSchema, fkTable) + " DROP FOREIGN KEY " + JDBC.escape(fkName);
                    s.executeUpdate(ddl);
                }
                rs.close();
            }
            table_rs.close();
            conn.commit();
            rs = dmd.getTables(null, schema, null, GET_TABLES_TABLE);
            JDBC.dropUsingDMD(s, rs, schema, "TABLE_NAME", "TABLE");
            psf.setString(1, "A");
            psf.setString(2, schema);
            rs = psf.executeQuery();
            JDBC.dropUsingDMD(s, rs, schema, "ALIAS", "TYPE");
            psf.close();
            rs = dmd.getTables(null, schema, null, GET_TABLES_SYNONYM);
            JDBC.dropUsingDMD(s, rs, schema, "TABLE_NAME", "SYNONYM");
            boolean bl = doDrop = !schema.equals("APP");
            if (doDrop && conn instanceof EmbedConnection && (lcc = ((EmbedConnection)conn).getLanguageConnection()) != null && schema.equals(lcc.getAuthorizationId())) {
                doDrop = false;
            }
            if (doDrop) {
                try {
                    s.executeUpdate("DROP SCHEMA IF EXISTS " + JDBC.escape(schema) + " RESTRICT");
                }
                catch (SQLException sqle) {
                    if ("X0Z08".equals(sqle.getSQLState())) break block6;
                    throw sqle;
                }
            }
        }
        conn.commit();
        s.close();
    }

    private static void dropUsingDMD(Statement s, java.sql.ResultSet rs, String schema, String mdColumn, String dropType) throws SQLException {
        boolean bl;
        int[] results;
        String dropLeadIn = "DROP " + dropType + " ";
        ArrayList<String> ddl = new ArrayList<String>();
        while (rs.next()) {
            String objectName = rs.getString(mdColumn);
            String raw = dropLeadIn + JDBC.escape(schema, objectName);
            if ("TYPE".equals(dropType)) {
                raw = raw + " restrict ";
            }
            ddl.add(raw);
        }
        rs.close();
        if (ddl.isEmpty()) {
            return;
        }
        s.clearBatch();
        int batchCount = 0;
        for (Object e : ddl) {
            if (e == null) continue;
            s.addBatch(e.toString());
            ++batchCount;
        }
        try {
            results = s.executeBatch();
            Assert.assertNotNull((Object)results);
            Assert.assertEquals((String)"Incorrect result length from executeBatch", (int)batchCount, (int)results.length);
            boolean bl2 = false;
        }
        catch (BatchUpdateException batchException) {
            results = batchException.getUpdateCounts();
            Assert.assertNotNull((Object)results);
            Assert.assertTrue((String)"Too many results in BatchUpdateException", (results.length <= batchCount ? 1 : 0) != 0);
            boolean bl3 = true;
        }
        boolean didDrop = false;
        for (int i = 0; i < results.length; ++i) {
            int result = results[i];
            if (result == -3) {
                bl = true;
            } else if (result == -2) {
                didDrop = true;
            } else if (result >= 0) {
                didDrop = true;
            } else {
                Assert.fail((String)"Negative executeBatch status");
            }
            if (!didDrop) continue;
            ddl.set(i, null);
        }
        s.clearBatch();
        if (didDrop) {
            s.getConnection().commit();
        }
        if (bl) {
            boolean bl4;
            do {
                bl4 = false;
                didDrop = false;
                ListIterator i = ddl.listIterator();
                while (i.hasNext()) {
                    Object sql = i.next();
                    if (sql == null) continue;
                    try {
                        s.executeUpdate(sql.toString());
                        i.set(null);
                        didDrop = true;
                    }
                    catch (SQLException e) {
                        bl4 = true;
                    }
                }
                if (!didDrop) continue;
                s.getConnection().commit();
            } while (bl4 && didDrop);
        }
    }

    public static void assertMetaDataMatch(DatabaseMetaData dmd, ResultSetMetaData rsmd) throws SQLException {
        for (int col = 1; col <= rsmd.getColumnCount(); ++col) {
            java.sql.ResultSet column = dmd.getColumns(rsmd.getCatalogName(col), rsmd.getSchemaName(col), rsmd.getTableName(col), rsmd.getColumnName(col));
            Assert.assertTrue((String)("Column missing " + rsmd.getColumnName(col)), (boolean)column.next());
            Assert.assertEquals((int)column.getInt("DATA_TYPE"), (int)rsmd.getColumnType(col));
            Assert.assertEquals((int)column.getInt("NULLABLE"), (int)rsmd.isNullable(col));
            Assert.assertEquals((String)column.getString("TYPE_NAME"), (String)rsmd.getColumnTypeName(col));
            column.close();
        }
    }

    public static void assertEmpty(java.sql.ResultSet rs) throws SQLException {
        JDBC.assertDrainResults(rs, 0);
    }

    public static void assertClosed(java.sql.ResultSet rs) {
        try {
            rs.next();
            Assert.fail((String)"ResultSet not closed");
        }
        catch (SQLException sqle) {
            Assert.assertEquals((String)"XCL16", (String)sqle.getSQLState());
        }
    }

    public static void assertNoWarnings(SQLWarning warning) {
        if (warning == null) {
            return;
        }
        Assert.fail((String)("Expected no SQLWarnings - got: " + warning.getSQLState() + " " + warning.getMessage()));
    }

    public static void assertNoMoreResults(Statement s) throws SQLException {
        Assert.assertFalse((boolean)s.getMoreResults());
        Assert.assertTrue((s.getUpdateCount() == -1 ? 1 : 0) != 0);
        Assert.assertNull((Object)s.getResultSet());
    }

    public static void assertGeneratedKeyResultSet(String description, java.sql.ResultSet keys) throws SQLException {
        Assert.assertNotNull((String)description, (Object)keys);
        Assert.assertEquals((String)(description + " - Required CONCUR_READ_ONLY for generated key result sets"), (int)1007, (int)keys.getConcurrency());
        int type = keys.getType();
        if (type != 1003 && type != 1004) {
            Assert.fail((String)(description + " - Invalid type for generated key result set" + type));
        }
    }

    public static void assertDrainResultsHasData(java.sql.ResultSet rs) throws SQLException {
        int rowCount = JDBC.assertDrainResults(rs, -1);
        Assert.assertTrue((String)"ResultSet expected to have data", (rowCount > 0 ? 1 : 0) != 0);
    }

    public static int assertDrainResults(java.sql.ResultSet rs) throws SQLException {
        return JDBC.assertDrainResults(rs, -1);
    }

    public static int assertDrainResults(java.sql.ResultSet rs, int expectedRows) throws SQLException {
        ResultSetMetaData rsmd = rs.getMetaData();
        int rows = 0;
        while (rs.next()) {
            for (int col = 1; col <= rsmd.getColumnCount(); ++col) {
                String s = rs.getString(col);
                Assert.assertEquals((s == null ? 1 : 0) != 0, (boolean)rs.wasNull());
                if (!rs.wasNull()) continue;
                JDBC.assertResultColumnNullable(rsmd, col);
            }
            ++rows;
        }
        rs.close();
        if (expectedRows >= 0) {
            Assert.assertEquals((String)"Unexpected row count:", (int)expectedRows, (int)rows);
        }
        return rows;
    }

    private static void assertResultColumnNullable(ResultSetMetaData rsmd, int col) throws SQLException {
        Assert.assertFalse((rsmd.isNullable(col) == 0 ? 1 : 0) != 0);
    }

    public static void assertColumnNames(java.sql.ResultSet rs, String[] expectedColNames) throws SQLException {
        ResultSetMetaData rsmd = rs.getMetaData();
        int actualCols = rsmd.getColumnCount();
        Assert.assertEquals((String)"Unexpected column count:", (int)expectedColNames.length, (int)rsmd.getColumnCount());
        for (int i = 0; i < actualCols; ++i) {
            Assert.assertEquals((String)"Column names do not match:", (String)expectedColNames[i], (String)rsmd.getColumnName(i + 1));
        }
    }

    public static void assertColumnTypes(java.sql.ResultSet rs, int[] expectedTypes) throws SQLException {
        ResultSetMetaData rsmd = rs.getMetaData();
        int actualCols = rsmd.getColumnCount();
        Assert.assertEquals((String)"Unexpected column count:", (int)expectedTypes.length, (int)rsmd.getColumnCount());
        for (int i = 0; i < actualCols; ++i) {
            Assert.assertEquals((String)("Column types do not match for column " + (i + 1)), (int)expectedTypes[i], (int)rsmd.getColumnType(i + 1));
        }
    }

    public static void assertParameterTypes(PreparedStatement ps, int[] expectedTypes) throws SQLException {
        ParameterMetaData pmd = ps.getParameterMetaData();
        int actualParams = pmd.getParameterCount();
        Assert.assertEquals((String)"Unexpected parameter count:", (int)expectedTypes.length, (int)pmd.getParameterCount());
        for (int i = 0; i < actualParams; ++i) {
            Assert.assertEquals((String)("Types do not match for parameter " + (i + 1)), (int)expectedTypes[i], (int)pmd.getParameterType(i + 1));
        }
    }

    public static void assertNullability(java.sql.ResultSet rs, boolean[] nullability) throws SQLException {
        ResultSetMetaData rsmd = rs.getMetaData();
        int actualCols = rsmd.getColumnCount();
        Assert.assertEquals((String)"Unexpected column count:", (int)nullability.length, (int)rsmd.getColumnCount());
        for (int i = 0; i < actualCols; ++i) {
            int expected = nullability[i] ? 1 : 0;
            Assert.assertEquals((String)("Column nullability do not match for column " + (i + 1)), (int)expected, (int)rsmd.isNullable(i + 1));
        }
    }

    public static void assertSingleValueResultSet(java.sql.ResultSet rs, String value) throws SQLException {
        String[] row = new String[]{value};
        String[][] set = new String[][]{row};
        JDBC.assertFullResultSet(rs, set);
    }

    public static void assertFullResultSet(java.sql.ResultSet rs, String[][] expectedRows) throws SQLException {
        JDBC.assertFullResultSet(rs, expectedRows, true);
    }

    public static void assertFullResultSet(java.sql.ResultSet rs, Object[][] expectedRows, boolean allAsTrimmedStrings) throws SQLException {
        JDBC.assertFullResultSet(rs, expectedRows, allAsTrimmedStrings, true);
    }

    public static void assertFullResultSet(java.sql.ResultSet rs, Object[][] expectedRows, boolean allAsTrimmedStrings, boolean closeResultSet) throws SQLException {
        ResultSetMetaData rsmd = rs.getMetaData();
        if (expectedRows.length > 0) {
            Assert.assertEquals((String)"Unexpected column count:", (int)expectedRows[0].length, (int)rsmd.getColumnCount());
        }
        int rows = 0;
        while (rs.next()) {
            if (rows < expectedRows.length) {
                JDBC.assertRowInResultSet(rs, rows + 1, expectedRows[rows], allAsTrimmedStrings);
            }
            ++rows;
        }
        if (closeResultSet) {
            rs.close();
        }
        Assert.assertEquals((String)"Unexpected row count:", (int)expectedRows.length, (int)rows);
    }

    public static void assertPartialResultSet(java.sql.ResultSet rs, Object[][] expectedRows, BitSet colsToCheck) throws SQLException {
        if (expectedRows.length > 0) {
            Assert.assertEquals((String)"Unexpected column count:", (int)expectedRows[0].length, (int)colsToCheck.cardinality());
        }
        int rows = 0;
        while (rs.next()) {
            if (rows < expectedRows.length) {
                JDBC.assertRowInResultSet(rs, rows + 1, expectedRows[rows], true, colsToCheck);
            }
            ++rows;
        }
        rs.close();
        Assert.assertEquals((String)"Unexpected row count:", (int)expectedRows.length, (int)rows);
    }

    private static void assertRowInResultSet(java.sql.ResultSet rs, int rowNum, Object[] expectedRow, boolean asTrimmedStrings) throws SQLException {
        JDBC.assertRowInResultSet(rs, rowNum, expectedRow, asTrimmedStrings, null);
    }

    private static void assertRowInResultSet(java.sql.ResultSet rs, int rowNum, Object[] expectedRow, boolean asTrimmedStrings, BitSet colsToCheck) throws SQLException {
        int cPos = 0;
        ResultSetMetaData rsmd = rs.getMetaData();
        for (int i = 0; i < expectedRow.length; ++i) {
            boolean ok;
            Object obj;
            int n = cPos = colsToCheck == null ? i + 1 : colsToCheck.nextSetBit(cPos) + 1;
            if (asTrimmedStrings) {
                String s;
                if (expectedRow[i] != null) {
                    expectedRow[i] = ((String)expectedRow[i]).trim();
                }
                obj = expectedRow[i] != null && rsmd.getColumnType(cPos) == 5 ? ((s = expectedRow[i].toString()).equals("true") || s.equals("false") ? (rs.getShort(cPos) == 0 ? "false" : "true") : rs.getString(cPos)) : rs.getString(cPos);
                if (obj != null) {
                    obj = ((String)obj).trim();
                }
            } else {
                obj = rs.getObject(cPos);
            }
            boolean bl = ok = rs.wasNull() && expectedRow[i] == null || !rs.wasNull() && expectedRow[i] != null && (expectedRow[i].equals(obj) || obj instanceof byte[] && Arrays.equals((byte[])obj, (byte[])expectedRow[i]) || obj instanceof Blob && Arrays.equals(((Blob)obj).getBytes(1L, (int)((Blob)obj).length()), (byte[])expectedRow[i]) || obj instanceof Clob && ((Clob)obj).getSubString(1L, (int)((Clob)obj).length()).equals(expectedRow[i]));
            if (!ok) {
                Object expected = expectedRow[i];
                Object found = obj;
                if (obj instanceof byte[]) {
                    expected = JDBC.bytesToString((byte[])expectedRow[i]);
                    found = JDBC.bytesToString((byte[])obj);
                }
                Assert.fail((String)("Column value mismatch @ column '" + rsmd.getColumnName(cPos) + "', row " + rowNum + ":\n    Expected: >" + expected + "<\n    Found:    >" + found + "<"));
            }
            if (!rs.wasNull()) continue;
            JDBC.assertResultColumnNullable(rsmd, cPos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void assertSameContents(java.sql.ResultSet rs1, java.sql.ResultSet rs2) throws SQLException {
        try {
            List<List<Object>> rs1RowList = JDBC.createListOfRows(rs1);
            List<List<Object>> rs2RowList = JDBC.createListOfRows(rs2);
            Assert.assertEquals((int)rs1RowList.size(), (int)rs2RowList.size());
            rs2RowList.removeAll(rs1RowList);
            Assert.assertTrue((boolean)rs2RowList.isEmpty());
        }
        finally {
            rs1.close();
            rs2.close();
        }
    }

    private static List<List<Object>> createListOfRows(java.sql.ResultSet rs) throws SQLException {
        ResultSetMetaData rsmd = rs.getMetaData();
        int columnCount = rsmd.getColumnCount();
        ArrayList<List<Object>> listOfRows = new ArrayList<List<Object>>();
        while (rs.next()) {
            ArrayList<Object> row = new ArrayList<Object>(columnCount);
            for (int col = 1; col <= columnCount; ++col) {
                switch (rsmd.getColumnType(col)) {
                    case 4: 
                    case 5: {
                        row.add(rs.getInt(col));
                        break;
                    }
                    case -5: {
                        row.add(rs.getLong(col));
                        break;
                    }
                    case 2004: {
                        row.add(new BlobComparator(rs.getBlob(col)));
                        break;
                    }
                    case 2005: {
                        row.add(new ClobComparator(rs.getClob(col)));
                        break;
                    }
                    default: {
                        row.add(rs.getString(col));
                    }
                }
                if (rs.wasNull()) {
                    row.add(null);
                }
                listOfRows.add(row);
            }
        }
        return listOfRows;
    }

    public static void assertUnorderedResultSet(java.sql.ResultSet rs, String[][] expectedRows) throws SQLException {
        JDBC.assertUnorderedResultSet(rs, expectedRows, true);
    }

    public static void assertUnorderedResultSet(java.sql.ResultSet rs, Object[][] expectedRows, boolean asTrimmedStrings) throws SQLException {
        JDBC.assertUnorderedResultSet(rs, expectedRows, asTrimmedStrings, false);
    }

    public static void assertUnorderedResultSet(java.sql.ResultSet rs, Object[][] expectedRows, boolean asTrimmedStrings, boolean booleansAsInts) throws SQLException {
        byte[] b;
        if (expectedRows.length == 0) {
            JDBC.assertEmpty(rs);
            return;
        }
        ResultSetMetaData rsmd = rs.getMetaData();
        Assert.assertEquals((String)"Unexpected column count", (int)expectedRows[0].length, (int)rsmd.getColumnCount());
        ArrayList expected = new ArrayList(expectedRows.length);
        for (int i = 0; i < expectedRows.length; ++i) {
            Assert.assertEquals((String)"Different column count in expectedRows", (int)expectedRows[0].length, (int)expectedRows[i].length);
            if (asTrimmedStrings) {
                ArrayList<String> row = new ArrayList<String>(expectedRows[i].length);
                for (int j = 0; j < expectedRows[i].length; ++j) {
                    String val = (String)expectedRows[i][j];
                    row.add(val == null ? null : val.trim());
                }
                expected.add(row);
                continue;
            }
            Object[] objs = expectedRows[i];
            ArrayList<Object> row = new ArrayList<Object>(objs.length);
            for (Object o : objs) {
                if (o instanceof byte[]) {
                    b = (byte[])o;
                    row.add(ClientSharedUtils.toHexString((byte[])b, (int)0, (int)b.length));
                    continue;
                }
                if (o instanceof Blob) {
                    Blob blob = (Blob)o;
                    byte[] b2 = blob.getBytes(1L, (int)blob.length());
                    row.add(ClientSharedUtils.toHexString((byte[])b2, (int)0, (int)b2.length));
                    continue;
                }
                if (o instanceof Clob) {
                    Clob clob = (Clob)o;
                    row.add(((Clob)o).getSubString(1L, (int)clob.length()));
                    continue;
                }
                row.add(o);
            }
            expected.add(row);
        }
        ArrayList actual = new ArrayList(expectedRows.length);
        ArrayList actual2 = new ArrayList(expectedRows.length);
        while (rs.next()) {
            ArrayList<Object> row = new ArrayList<Object>(expectedRows[0].length);
            ArrayList<String> row2 = new ArrayList<String>(expectedRows[0].length);
            actual2.add(row2);
            for (int i = 1; i <= expectedRows[0].length; ++i) {
                if (asTrimmedStrings) {
                    String s;
                    String s2 = s = rs.getString(i);
                    if (booleansAsInts && s != null && s.length() == 1 && rsmd.getColumnType(i) == 5) {
                        if (s.charAt(0) == '0') {
                            s2 = "false";
                        } else if (s.charAt(0) == '1') {
                            s2 = "true";
                        }
                    }
                    row2.add(s2 == null ? null : s2.trim());
                    row.add(s == null ? null : s.trim());
                } else {
                    Object o = rs.getObject(i);
                    if (o instanceof byte[]) {
                        byte[] b3 = (byte[])o;
                        row.add(ClientSharedUtils.toHexString((byte[])b3, (int)0, (int)b3.length));
                    } else if (o instanceof Blob) {
                        Blob blob = (Blob)o;
                        b = blob.getBytes(1L, (int)blob.length());
                        row.add(ClientSharedUtils.toHexString((byte[])b, (int)0, (int)b.length));
                    } else if (o instanceof Clob) {
                        Clob clob = (Clob)o;
                        row.add(((Clob)o).getSubString(1L, (int)clob.length()));
                    } else {
                        row.add(o);
                    }
                }
                if (!rs.wasNull()) continue;
                JDBC.assertResultColumnNullable(rsmd, i);
            }
            actual.add(row);
        }
        rs.close();
        if (actual.size() != expectedRows.length) {
            Assert.fail((String)("Unexpected row count " + actual.size() + "{" + actual + "}, expected=" + expectedRows.length));
        }
        if (booleansAsInts && asTrimmedStrings) {
            if (!actual2.containsAll(expected)) {
                Assert.assertTrue((String)("Missing rows in ResultSet " + actual + ", expected: " + expected), (boolean)actual.containsAll(expected));
            } else {
                actual = actual2;
            }
        } else {
            Assert.assertTrue((String)("Missing rows in ResultSet " + actual + ", expected: " + expected), (boolean)actual.containsAll(expected));
        }
        actual.removeAll(expected);
        Assert.assertTrue((String)("Extra rows in ResultSet: " + (actual.size() > 0 ? ArrayUtils.objectString(actual.get(0)) : "")), (boolean)actual.isEmpty());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void assertCurrentSchema(Connection con, String schema) throws SQLException {
        try (Statement stmt = con.createStatement();){
            JDBC.assertSingleValueResultSet(stmt.executeQuery("VALUES CURRENT SCHEMA"), schema);
        }
    }

    private static String bytesToString(byte[] ba) {
        if (ba == null) {
            return null;
        }
        StringBuilder s = new StringBuilder();
        for (int i = 0; i < ba.length; ++i) {
            s.append(Integer.toHexString(ba[i] & 0xFF));
        }
        return s.toString();
    }

    public static String escape(String name) {
        name = JDBC.doubleInternalDoubleQuotes(name);
        return "\"" + name + "\"";
    }

    public static String escape(String schema, String name) {
        name = JDBC.doubleInternalDoubleQuotes(name);
        schema = JDBC.doubleInternalDoubleQuotes(schema);
        return "\"" + schema + "\".\"" + name + "\"";
    }

    public static String doubleInternalDoubleQuotes(String s) {
        return s.replace("\"", "\"\"");
    }

    public static String sqlNameFromJdbc(int jdbcType) {
        switch (jdbcType) {
            case -7: {
                return "Types.BIT";
            }
            case 16: {
                return "Types.BOOLEAN";
            }
            case -6: {
                return "Types.TINYINT";
            }
            case 5: {
                return "SMALLINT";
            }
            case 4: {
                return "INTEGER";
            }
            case -5: {
                return "BIGINT";
            }
            case 6: {
                return "Types.FLOAT";
            }
            case 7: {
                return "REAL";
            }
            case 8: {
                return "DOUBLE";
            }
            case 2: {
                return "Types.NUMERIC";
            }
            case 3: {
                return "DECIMAL";
            }
            case 1: {
                return "CHAR";
            }
            case 12: {
                return "VARCHAR";
            }
            case -1: {
                return "LONG VARCHAR";
            }
            case 2005: {
                return "CLOB";
            }
            case 91: {
                return "DATE";
            }
            case 92: {
                return "TIME";
            }
            case 93: {
                return "TIMESTAMP";
            }
            case -2: {
                return "CHAR () FOR BIT DATA";
            }
            case -3: {
                return "VARCHAR () FOR BIT DATA";
            }
            case -4: {
                return "LONG VARCHAR FOR BIT DATA";
            }
            case 2004: {
                return "BLOB";
            }
            case 1111: {
                return "Types.OTHER";
            }
            case 0: {
                return "Types.NULL";
            }
        }
        return String.valueOf(jdbcType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void SQLUnitTestHelper(Statement stmt, Object[][] SQLToRun) throws Exception {
        boolean isOffHeap;
        SimpleMemoryAllocatorImpl allocator;
        int numMembers = 1;
        InternalDistributedSystem ids = InternalDistributedSystem.getConnectedInstance();
        if (ids != null) {
            numMembers += ids.getAllOtherMembers().size();
        }
        try {
            allocator = SimpleMemoryAllocatorImpl.getAllocator();
        }
        catch (Exception ignore) {
            allocator = null;
        }
        RegionMapClearDetector rmcd = null;
        boolean bl = isOffHeap = allocator != null && numMembers == 1;
        if (isOffHeap) {
            LocalRegion.ISSUE_CALLBACKS_TO_CACHE_OBSERVER = true;
            rmcd = new RegionMapClearDetector();
            CacheObserverHolder.setInstance((CacheObserver)rmcd);
            GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)rmcd);
        }
        try {
            for (int stmtNumber = 0; stmtNumber < SQLToRun.length; ++stmtNumber) {
                String stmtToExecute = (String)SQLToRun[stmtNumber][0];
                Object resultExpected = SQLToRun[stmtNumber][1];
                boolean haveResults = false;
                boolean foundResultSetError = false;
                boolean expectOrdered = false;
                long refCountBefore = isOffHeap ? (long)JDBC.getTotalRefCount(allocator) : 0L;
                int caseType = -1;
                if (stmtToExecute.toLowerCase().startsWith("insert")) {
                    caseType = 0;
                } else if (stmtToExecute.toLowerCase().startsWith("update")) {
                    caseType = 1;
                } else if (stmtToExecute.toLowerCase().startsWith("select")) {
                    caseType = 2;
                } else if (stmtToExecute.toLowerCase().startsWith("delete")) {
                    caseType = 3;
                } else if (stmtToExecute.toLowerCase().startsWith("noexec")) continue;
                System.out.print("Running statement#" + (stmtNumber + 1) + " : " + stmtToExecute + ", expected " + (expectOrdered ? "ordered" : "unordered") + " results = " + (resultExpected instanceof String[][] ? Arrays.deepToString((Object[])((String[][])resultExpected)) : resultExpected));
                System.out.println();
                if (stmtNumber + 1 == 159) {
                    System.out.println("debug");
                }
                try {
                    long refCountAfter;
                    haveResults = stmt.execute(stmtToExecute);
                    if (haveResults) {
                        if (resultExpected == null) {
                            Assert.fail((String)("Statement " + stmtToExecute + " returned results but we expected success and zero results!"));
                        } else if (resultExpected instanceof String) {
                            java.sql.ResultSet rsTmp = stmt.getResultSet();
                            if (rsTmp != null) {
                                try {
                                    JDBC.assertDrainResults(rsTmp, -1);
                                }
                                catch (SQLException e) {
                                    try {
                                        Assert.assertEquals((Object)resultExpected, (Object)e.getSQLState());
                                        foundResultSetError = true;
                                    }
                                    catch (AssertionFailedError afe) {
                                        throw new AssertionFailedError(afe.toString() + "for statement = " + stmtToExecute);
                                    }
                                }
                            }
                            if (!foundResultSetError) {
                                Assert.fail((String)("Statement " + stmtToExecute + " expected a SQLCODE " + resultExpected + " but succeeded and returned results with no SQLCODE!"));
                            }
                        } else {
                            java.sql.ResultSet rs = stmt.getResultSet();
                            try {
                                if (!expectOrdered) {
                                    JDBC.assertUnorderedResultSet(rs, (String[][])resultExpected);
                                }
                                JDBC.assertFullResultSet(rs, (String[][])resultExpected);
                            }
                            catch (AssertionFailedError afe) {
                                throw new AssertionFailedError(afe.toString() + "for statement = " + stmtToExecute);
                            }
                        }
                    } else if (resultExpected != null) {
                        Assert.fail((String)("Statement " + stmtToExecute + " returned no results and success, but we expected results looking like " + resultExpected));
                    }
                    if (isOffHeap) {
                        refCountAfter = JDBC.getTotalRefCount(allocator);
                        if (caseType == 0) {
                            int numInserted = stmt.getUpdateCount();
                            Assert.assertTrue((String)"The offheap in use count before and after  statement execution are not conserved", (refCountAfter >= refCountBefore ? 1 : 0) != 0);
                            Assert.assertTrue((String)"The offheap in use count before and after  statement execution are not conserved", (refCountAfter - refCountBefore <= (long)numInserted ? 1 : 0) != 0);
                            continue;
                        }
                        if (caseType == 3) {
                            int numDeleted = stmt.getUpdateCount();
                            Assert.assertTrue((String)"The offheap in use count before and after  statement execution are not conserved", (refCountAfter <= refCountBefore ? 1 : 0) != 0);
                            Assert.assertTrue((String)"The offheap in use count before and after  statement execution are not conserved", (refCountBefore - refCountAfter <= (long)numDeleted ? 1 : 0) != 0);
                            continue;
                        }
                        if (caseType != 1 && caseType != 2) continue;
                        Assert.assertEquals((String)"The offheap in use count before and after  statement execution are unequal", (long)refCountBefore, (long)refCountAfter);
                        continue;
                    }
                    refCountAfter = 0L;
                    continue;
                }
                catch (SQLException e) {
                    if (resultExpected != null && resultExpected instanceof String) {
                        try {
                            Assert.assertEquals((Object)resultExpected, (Object)e.getSQLState());
                            continue;
                        }
                        catch (AssertionFailedError afe) {
                            throw new AssertionFailedError(afe.toString() + "for statement = " + stmtToExecute);
                        }
                    }
                    throw new RuntimeException("Failed statement=" + stmtToExecute, e);
                }
                finally {
                    if (isOffHeap) {
                        rmcd.waitTillAllClear();
                        JDBC.assertLiveChunksAndRegionEntryValidity(allocator);
                    }
                }
            }
        }
        finally {
            LocalRegion.ISSUE_CALLBACKS_TO_CACHE_OBSERVER = false;
            CacheObserverHolder.setInstance(null);
            GemFireXDQueryObserverHolder.clearInstance();
        }
    }

    public static int getTotalRefCount(SimpleMemoryAllocatorImpl ma) {
        int totalRefCount = 0;
        if (ma != null) {
            List chunks = ma.getFreeList().getLiveChunks();
            for (SimpleMemoryAllocatorImpl.Chunk chunk : chunks) {
                totalRefCount += chunk.getRefCount();
            }
        }
        return totalRefCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void assertLiveChunksAndRegionEntryValidity(SimpleMemoryAllocatorImpl ma) {
        if (ma != null) {
            List chunks = ma.getFreeList().getLiveChunks();
            for (SimpleMemoryAllocatorImpl.Chunk chunk : chunks) {
                Assert.assertEquals((int)1, (int)chunk.getRefCount());
            }
        }
        GemFireCacheImpl cache = Misc.getGemFireCache();
        Set regions = cache.getAllRegions();
        for (LocalRegion lr : regions) {
            if (!lr.getEnableOffHeapMemory() || (lr instanceof PartitionedRegion ? ((PartitionedRegion)lr).entryCount(true) < 1 : lr.entryCount() < 1)) continue;
            for (Object key : lr.keys()) {
                OffHeapRegionEntry ohEntry = (OffHeapRegionEntry)lr.basicGetEntry(key);
                boolean doFree = false;
                try {
                    long address;
                    if (ohEntry == null || OffHeapRegionEntryHelper.isAddressInvalidOrRemoved((long)(address = ohEntry.getAddress()))) continue;
                    SimpleMemoryAllocatorImpl.skipRefCountTracking();
                    Object val = OffHeapRegionEntryHelper._getValueRetain((OffHeapRegionEntry)ohEntry, (boolean)false);
                    SimpleMemoryAllocatorImpl.unskipRefCountTracking();
                    Assert.assertFalse((boolean)Token.isInvalidOrRemoved((Object)val));
                    if (!(val instanceof SimpleMemoryAllocatorImpl.Chunk)) continue;
                    doFree = true;
                    Assert.assertEquals((int)2, (int)((SimpleMemoryAllocatorImpl.Chunk)val).getRefCount());
                }
                finally {
                    if (!doFree) continue;
                    SimpleMemoryAllocatorImpl.skipRefCountTracking();
                    SimpleMemoryAllocatorImpl.Chunk.release((long)ohEntry.getAddress(), (boolean)true);
                    SimpleMemoryAllocatorImpl.unskipRefCountTracking();
                }
            }
        }
    }

    private static class RegionMapClearDetector
    extends CacheObserverAdapter
    implements GemFireXDQueryObserver {
        private int numExpectedRegionClearCalls = 0;
        private int currentCallCount = 0;

        private RegionMapClearDetector() {
        }

        private void setNumExpectedRegionClearCalls(int numExpected) {
            this.numExpectedRegionClearCalls = numExpected;
            this.currentCallCount = 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void waitTillAllClear() throws InterruptedException {
            RegionMapClearDetector regionMapClearDetector = this;
            synchronized (regionMapClearDetector) {
                if (this.currentCallCount < this.numExpectedRegionClearCalls) {
                    ((Object)((Object)this)).wait();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void afterRegionCustomEntryConcurrentHashMapClear() {
            RegionMapClearDetector regionMapClearDetector = this;
            synchronized (regionMapClearDetector) {
                ++this.currentCallCount;
                if (this.currentCallCount == this.numExpectedRegionClearCalls) {
                    ((Object)((Object)this)).notifyAll();
                }
            }
        }

        public void afterPKBasedDBSynchExecution(Event.Type type, int numRowsModified, Statement stmt) {
        }

        public void afterBulkOpDBSynchExecution(Event.Type type, int numRowsModified, Statement stmt, String sql) {
        }

        public void afterCommitDBSynchExecution(List<Event> batchProcessed) {
        }

        public PreparedStatement afterQueryPrepareFailure(Connection conn, String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability, int autoGeneratedKeys, int[] columnIndexes, String[] columnNames, SQLException sqle) throws SQLException {
            return null;
        }

        public boolean afterQueryExecution(CallbackStatement stmt, SQLException sqle) throws SQLException {
            return false;
        }

        public void afterCommit(Connection conn) {
        }

        public void afterRollback(Connection conn) {
        }

        public void afterConnectionClose(Connection conn) {
        }

        public void close() {
        }

        public void afterQueryParsing(String query, StatementNode qt, LanguageConnectionContext lcc) {
            if (qt instanceof DropTableNode) {
                DropTableNode dtn = (DropTableNode)qt;
                String tableToDrop = dtn.getFullName();
                Region rgn = Misc.getRegionForTable((String)tableToDrop, (boolean)false);
                if (rgn != null && rgn.getAttributes().getEnableOffHeapMemory()) {
                    if (rgn.getAttributes().getDataPolicy().isPartition()) {
                        PartitionedRegion pr = (PartitionedRegion)rgn;
                        int numBucketsHosted = pr.getRegionAdvisor().getAllBucketAdvisors().size();
                        this.setNumExpectedRegionClearCalls(numBucketsHosted);
                    } else {
                        this.setNumExpectedRegionClearCalls(1);
                    }
                } else {
                    this.setNumExpectedRegionClearCalls(0);
                }
            } else {
                this.setNumExpectedRegionClearCalls(0);
            }
        }

        public void beforeOptimizedParsedTree(String query, StatementNode qt, LanguageConnectionContext lcc) {
        }

        public void afterOptimizedParsedTree(String query, StatementNode qt, LanguageConnectionContext lcc) {
        }

        public void subQueryInfoObjectFromOptmizedParsedTree(List<SubQueryInfo> qInfos, GenericPreparedStatement gps, LanguageConnectionContext lcc) {
        }

        public void queryInfoObjectFromOptmizedParsedTree(QueryInfo qInfo, GenericPreparedStatement gps, LanguageConnectionContext lcc) {
        }

        public void queryInfoObjectAfterPreparedStatementCompletion(QueryInfo qInfo, GenericPreparedStatement gps, LanguageConnectionContext lcc) {
        }

        public void beforeQueryExecution(EmbedStatement stmt, Activation activation) throws SQLException {
        }

        public void beforeBatchQueryExecution(EmbedStatement stmt, int batchSize) throws SQLException {
        }

        public void afterBatchQueryExecution(EmbedStatement stmt, int batchSize) {
        }

        public void beforeQueryExecution(GenericPreparedStatement stmt, LanguageConnectionContext lcc) throws StandardException {
        }

        public void afterQueryExecution(GenericPreparedStatement stmt, Activation activation) throws StandardException {
        }

        public void afterResultSetOpen(GenericPreparedStatement stmt, LanguageConnectionContext lcc, ResultSet resultSet) {
        }

        public void onEmbedResultSetMovePosition(EmbedResultSet rs, ExecRow newRow, ResultSet theResults) {
        }

        public void beforeGemFireActivationCreate(AbstractGemFireActivation ac) {
        }

        public void afterGemFireActivationCreate(AbstractGemFireActivation ac) {
        }

        public void beforeGemFireResultSetOpen(AbstractGemFireResultSet rs, LanguageConnectionContext lcc) throws StandardException {
        }

        public void afterGemFireResultSetOpen(AbstractGemFireResultSet rs, LanguageConnectionContext lcc) {
        }

        public void beforeFlushBatch(ResultSet rs, LanguageConnectionContext lcc) throws StandardException {
        }

        public void afterFlushBatch(ResultSet rs, LanguageConnectionContext lcc) throws StandardException {
        }

        public void beforeGemFireResultSetExecuteOnActivation(AbstractGemFireActivation activation) {
        }

        public void beforeComputeRoutingObjects(AbstractGemFireActivation activation) {
        }

        public void afterComputeRoutingObjects(AbstractGemFireActivation activation) {
        }

        public <T extends Serializable> void beforeQueryDistribution(StatementExecutorMessage<T> executorMessage, boolean streaming) {
        }

        public <T extends Serializable> void afterQueryDistribution(StatementExecutorMessage<T> executorMessage, boolean streaming) {
        }

        public void afterGemFireResultSetExecuteOnActivation(AbstractGemFireActivation activation) {
        }

        public void beforeGemFireResultSetClose(AbstractGemFireResultSet rs, String query) {
        }

        public void afterGemFireResultSetClose(AbstractGemFireResultSet rs, String query) {
        }

        public void beforeEmbedResultSetClose(EmbedResultSet rs, String query) {
        }

        public void createdGemFireXDResultSet(ResultSet rs) {
        }

        public void beforeQueryExecutionByStatementQueryExecutor(GfxdConnectionWrapper wrapper, EmbedStatement stmt, String query) {
        }

        public void afterQueryExecutionByStatementQueryExecutor(GfxdConnectionWrapper wrapper, EmbedStatement stmt, String query) {
        }

        public void beforeQueryExecutionByPrepStatementQueryExecutor(GfxdConnectionWrapper wrapper, EmbedPreparedStatement pstmt, String query) {
        }

        public void afterQueryExecutionByPrepStatementQueryExecutor(GfxdConnectionWrapper wrapper, EmbedPreparedStatement pstmt, String query) {
        }

        public void beforeResultHolderExecution(GfxdConnectionWrapper wrapper, EmbedStatement es) {
        }

        public void beforeResultHolderIteration(GfxdConnectionWrapper wrapper, EmbedStatement es) {
        }

        public void afterResultHolderIteration(GfxdConnectionWrapper wrapper, EmbedStatement es) {
        }

        public void beforeResultHolderSerialization(GfxdConnectionWrapper wrapper, EmbedStatement es) {
        }

        public void afterResultHolderSerialization(GfxdConnectionWrapper wrapper, EmbedStatement es) {
        }

        public void afterResultHolderExecution(GfxdConnectionWrapper wrapper, EmbedStatement es, String query) {
        }

        public void beforeResultSetHolderRowRead(RowFormatter rf, Activation act) {
        }

        public void afterResultSetHolderRowRead(RowFormatter rf, ExecRow row, Activation act) {
        }

        public void beforeIndexUpdatesAtRegionLevel(LocalRegion owner, EntryEventImpl event, RegionEntry entry) {
        }

        public void beforeForeignKeyConstraintCheckAtRegionLevel() {
        }

        public void beforeUniqueConstraintCheckAtRegionLevel() {
        }

        public void beforeGlobalIndexLookup(LanguageConnectionContext lcc, PartitionedRegion indexRegion, Serializable indexKey) {
        }

        public void afterGlobalIndexLookup(LanguageConnectionContext lcc, PartitionedRegion indexRegion, Serializable indexKey, Object result) {
        }

        public void scanControllerOpened(Object sc, Conglomerate conglom) {
        }

        public void beforeConnectionCloseByExecutorFunction(long[] connectionIDs) {
        }

        public void afterConnectionCloseByExecutorFunction(long[] connectionIDs) {
        }

        public void beforeORM(Activation activation, AbstractGemFireResultSet rs) {
        }

        public void afterORM(Activation activation, AbstractGemFireResultSet rs) {
        }

        public double overrideDerbyOptimizerIndexUsageCostForHash1IndexScan(OpenMemIndex memIndex, double optimzerEvalutatedCost) {
            return optimzerEvalutatedCost;
        }

        public double overrideDerbyOptimizerIndexUsageCostForSortedIndexScan(OpenMemIndex memIndex, double optimzerEvalutatedCost) {
            return optimzerEvalutatedCost;
        }

        public double overrideDerbyOptimizerCostForMemHeapScan(GemFireContainer gfContainer, double optimzerEvalutatedCost) {
            return optimzerEvalutatedCost;
        }

        public void criticalUpMemoryEvent(GfxdHeapThresholdListener listener) {
        }

        public void criticalDownMemoryEvent(GfxdHeapThresholdListener listener) {
        }

        public void estimatingMemoryUsage(String stmtText, Object resultSet) {
        }

        public long estimatedMemoryUsage(String stmtText, long memused) {
            return memused;
        }

        public void putAllCalledWithMapSize(int size) {
        }

        public void afterClosingWrapperPreparedStatement(long wrapperPrepStatementID, long wrapperConnectionID) {
        }

        public void updatingColocationCriteria(ComparisonQueryInfo cqi) {
        }

        public void statementStatsBeforeExecutingStatement(StatementStats stats) {
        }

        public void reset() {
        }

        public void subqueryNodeProcessedData(SelectQueryInfo qInfo, GenericPreparedStatement gps, String subquery, List<Integer> paramPositions) {
        }

        public void insertMultipleRowsBeingInvoked(int numElements) {
        }

        public void keyAndContainerAfterLocalIndexInsert(Object key, Object rowLocation, GemFireContainer container) {
        }

        public void keyAndContainerAfterLocalIndexDelete(Object key, Object rowLocation, GemFireContainer container) {
        }

        public void keyAndContainerBeforeLocalIndexDelete(Object key, Object rowLocation, GemFireContainer container) {
        }

        public void getAllInvoked(int numKeys) {
        }

        public void getAllGlobalIndexInvoked(int numKeys) {
        }

        public void getAllLocalIndexInvoked(int numKeys) {
        }

        public void getAllLocalIndexExecuted() {
        }

        public void ncjPullResultSetOpenCoreInvoked() {
        }

        public void getStatementIDs(long stID, long rootID, int stLevel) {
        }

        public void ncjPullResultSetVerifyBatchSize(int value) {
        }

        public void ncjPullResultSetVerifyCacheSize(int value) {
        }

        public void ncjPullResultSetVerifyVarInList(boolean value) {
        }

        public void independentSubqueryResultsetFetched(Activation activation, ResultSet results) {
        }

        public void beforeInvokingContainerGetTxRowLocation(RowLocation regionEntry) {
        }

        public void afterGetRoutingObject(Object routingObject) {
        }

        public long overrideUniqueID(long actualUniqueID, boolean forRegionKey) {
            return actualUniqueID;
        }

        public boolean beforeProcedureResultSetSend(ProcedureSender sender, EmbedResultSet rs) {
            return true;
        }

        public boolean beforeProcedureOutParamsSend(ProcedureSender sender, ParameterValueSet pvs) {
            return true;
        }

        public void beforeProcedureChunkMessageSend(ProcedureChunkMessage message) {
        }

        public void lockingRowForTX(TXStateProxy tx, GemFireContainer container, RegionEntry entry, boolean writeLock) {
        }

        public void attachingKeyInfoForUpdate(GemFireContainer container, RegionEntry entry) {
        }

        public boolean avoidMergeRuns() {
            return false;
        }

        public int overrideSortBufferSize(ColumnOrdering[] columnOrdering, int sortBufferMax) {
            return sortBufferMax;
        }

        public void callAtOldValueSameAsNewValueCheckInSM2IIOp() {
        }

        public void onGetNextRowCore(ResultSet resultSet) {
        }

        public void onGetNextRowCoreOfBulkTableScan(ResultSet resultSet) {
        }

        public void onGetNextRowCoreOfGfxdSubQueryResultSet(ResultSet resultSet) {
        }

        public void onDeleteResultSetOpen(ResultSet resultSet) {
        }

        public void onSortResultSetOpen(ResultSet resultSet) {
        }

        public void onGroupedAggregateResultSetOpen(ResultSet resultSet) {
        }

        public void onUpdateResultSetOpen(ResultSet resultSet) {
        }

        public void onUpdateResultSetDoneUpdate(ResultSet resultSet) {
        }

        public void onDeleteResultSetOpenAfterRefChecks(ResultSet resultSet) {
        }

        public void onDeleteResultSetOpenBeforeRefChecks(ResultSet resultSet) {
        }

        public void setRoutingObjectsBeforeExecution(Set<Object> routingKeysToExecute) {
        }

        public void beforeDropGatewayReceiver() {
        }

        public void beforeDropDiskStore() {
        }

        public void memberConnectionAuthenticationSkipped(boolean skipped) {
        }

        public void userConnectionAuthenticationSkipped(boolean skipped) {
        }

        public void regionSizeOptimizationTriggered(FromBaseTable fbt, SelectNode selectNode) {
        }

        public void invokeCacheCloseAtMultipleInsert() {
        }

        public boolean isCacheClosedForTesting() {
            return false;
        }

        public void afterGlobalIndexInsert(boolean posDup) {
        }

        public boolean needIndexRecoveryAccounting() {
            return false;
        }

        public void setIndexRecoveryAccountingMap(THashMap map) {
        }

        public void beforeQueryReprepare(GenericPreparedStatement gpst, LanguageConnectionContext lcc) throws StandardException {
        }

        public boolean throwPutAllPartialException() {
            return false;
        }

        public void afterIndexRowRequalification(Boolean success, CompactCompositeIndexKey ccKey, ExecRow row, Activation activation) {
        }

        public void beforeRowTrigger(LanguageConnectionContext lcc, ExecRow execRow, ExecRow newRow) {
        }

        public void afterRowTrigger(TriggerDescriptor trigD, GenericParameterValueSet gpvs) {
        }

        public void beforeGlobalIndexDelete() {
        }

        public void beforeDeferredUpdate() {
        }

        public void beforeDeferredDelete() {
        }

        public void bucketIdcalculated(int bid) {
        }

        public void beforeReturningCachedVal(Serializable globalIndexKey, Object cachedVal) {
        }

        public void afterPuttingInCached(Serializable globalIndexKey, Object result) {
        }

        public void afterSingleRowInsert(Object routingObj) {
        }

        public void afterQueryPlanGeneration() {
        }

        public void afterLockingTableDuringImport() {
        }

        public boolean testIndexRecreate() {
            return false;
        }

        public void regionSizeOptimizationTriggered2(SelectNode selectNode) {
        }
    }

    static class ClobComparator {
        private Clob b;

        ClobComparator(Clob b) {
            this.b = b;
        }

        public int hashCode() {
            return this.b.hashCode();
        }

        public boolean equals(Object other) {
            if (super.equals(other)) {
                return true;
            }
            if (!(other instanceof ClobComparator)) {
                return false;
            }
            try {
                Clob b1 = this.b;
                Clob b2 = ((ClobComparator)other).b;
                if (b1 == null) {
                    return b2 == null;
                }
                if (b2 == null) {
                    return b1 == null;
                }
                if (b1.length() != b2.length()) {
                    return false;
                }
                Reader is1 = b1.getCharacterStream();
                Reader is2 = b2.getCharacterStream();
                if (is1 == null || is2 == null) {
                    return false;
                }
                is1 = new BufferedReader(is1);
                is2 = new BufferedReader(is2);
                int by1 = is1.read();
                int by2 = is2.read();
                do {
                    if (by1 != by2) {
                        return false;
                    }
                    by1 = is1.read();
                    by2 = is2.read();
                } while (by1 != -1 || by2 != -1);
                is1.close();
                is2.close();
                return true;
            }
            catch (SQLException sqle) {
                AssertionFailedError ae = new AssertionFailedError();
                ae.initCause((Throwable)ae);
                throw ae;
            }
            catch (IOException ioe) {
                AssertionFailedError ae = new AssertionFailedError();
                ae.initCause((Throwable)ioe);
                throw ae;
            }
        }
    }

    static class BlobComparator {
        private Blob b;

        BlobComparator(Blob b) {
            this.b = b;
        }

        public int hashCode() {
            return this.b.hashCode();
        }

        public boolean equals(Object other) {
            if (super.equals(other)) {
                return true;
            }
            if (!(other instanceof BlobComparator)) {
                return false;
            }
            try {
                Blob b1 = this.b;
                Blob b2 = ((BlobComparator)other).b;
                if (b1 == null) {
                    return b2 == null;
                }
                if (b2 == null) {
                    return b1 == null;
                }
                if (b1.length() != b2.length()) {
                    return false;
                }
                InputStream is1 = b1.getBinaryStream();
                InputStream is2 = b2.getBinaryStream();
                if (is1 == null) {
                    return is2 == null;
                }
                if (is2 == null) {
                    return is1 == null;
                }
                is1 = new BufferedInputStream(is1);
                is2 = new BufferedInputStream(is2);
                int by1 = is1.read();
                int by2 = is2.read();
                do {
                    if (by1 != by2) {
                        return false;
                    }
                    by1 = is1.read();
                    by2 = is2.read();
                } while (by1 != -1 || by2 != -1);
                is1.close();
                is2.close();
                return true;
            }
            catch (SQLException sqle) {
                AssertionFailedError ae = new AssertionFailedError();
                ae.initCause((Throwable)ae);
                throw ae;
            }
            catch (IOException ioe) {
                AssertionFailedError ae = new AssertionFailedError();
                ae.initCause((Throwable)ioe);
                throw ae;
            }
        }
    }

    public static class GeneratedId {
        public boolean equals(Object o) {
            if (JDBC.vmSupportsJDBC3()) {
                return o instanceof String && ((String)o).matches("SQL[0-9]{15}");
            }
            String tmpstr = (String)o;
            boolean b = true;
            if (!(o instanceof String)) {
                b = false;
            }
            if (!tmpstr.startsWith("SQL")) {
                b = false;
            }
            if (tmpstr.length() != 18) {
                b = false;
            }
            for (int i = 3; i < 18; ++i) {
                if (Character.isDigit(tmpstr.charAt(i))) continue;
                b = false;
                break;
            }
            return b;
        }

        public String toString() {
            return "xxxxGENERATED-IDxxxx";
        }
    }
}

