/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.junit;

import java.io.File;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.sql.SQLException;
import javax.sql.DataSource;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseTestCase;
import org.apache.derbyTesting.junit.BaseTestSetup;
import org.apache.derbyTesting.junit.JDBCDataSource;
import org.apache.derbyTesting.junit.TestConfiguration;

class DropDatabaseSetup
extends BaseTestSetup {
    final String logicalDBName;

    DropDatabaseSetup(Test test, String logicalDBName) {
        super(test);
        this.logicalDBName = logicalDBName;
    }

    protected void tearDown() throws Exception {
        boolean shutdown2;
        TestConfiguration config = TestConfiguration.getCurrent();
        try {
            config.openConnection(this.logicalDBName).close();
            shutdown2 = true;
        }
        catch (SQLException e) {
            if ("XJ040".equals(e.getSQLState())) {
                shutdown2 = false;
            }
            throw e;
        }
        if (shutdown2) {
            DataSource ds = JDBCDataSource.getDataSourceLogical(this.logicalDBName);
            JDBCDataSource.shutdownDatabase(ds);
        }
        this.removeDatabase();
    }

    void removeDatabase() {
        TestConfiguration config = TestConfiguration.getCurrent();
        String dbName = config.getPhysicalDatabaseName(this.logicalDBName);
        dbName = dbName.replace('/', File.separatorChar);
        String dsh = BaseTestCase.getSystemProperty("gemfirexd.system.home");
        if (dsh == null) {
            DropDatabaseSetup.fail((String)"not implemented");
        } else {
            dbName = dsh + File.separator + dbName;
        }
        DropDatabaseSetup.removeDirectory(dbName);
    }

    static void removeDirectory(String path) {
        File dir = new File(path);
        DropDatabaseSetup.removeDirectory(dir);
    }

    static void removeDirectory(final File dir) {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                DropDatabaseSetup.removeDir(dir);
                return null;
            }
        });
    }

    private static void removeDir(File dir) {
        if (!dir.exists()) {
            return;
        }
        String[] list = dir.list();
        if (list != null) {
            for (int i = 0; i < list.length; ++i) {
                File entry = new File(dir, list[i]);
                if (entry.isDirectory()) {
                    DropDatabaseSetup.removeDir(entry);
                    continue;
                }
                DropDatabaseSetup.assertTrue((String)entry.getPath(), (boolean)entry.delete());
            }
        }
        DropDatabaseSetup.assertTrue((String)dir.getPath(), (boolean)dir.delete());
    }
}

