/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.junit;

import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.pivotal.gemfirexd.TestUtil;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;
import org.apache.derbyTesting.junit.Connector;
import org.apache.derbyTesting.junit.TestConfiguration;

public class DriverManagerConnector
implements Connector {
    private TestConfiguration config;

    @Override
    public void setConfiguration(TestConfiguration config) {
        this.config = config;
    }

    @Override
    public Connection openConnection() throws SQLException {
        return this.openConnection(this.config.getDefaultDatabaseName(), this.config.getUserName(), this.config.getUserPassword());
    }

    @Override
    public Connection openConnection(String databaseName) throws SQLException {
        return this.openConnection(databaseName, this.config.getUserName(), this.config.getUserPassword());
    }

    @Override
    public Connection openConnection(String user, String password) throws SQLException {
        return this.openConnection(this.config.getDefaultDatabaseName(), user, password);
    }

    @Override
    public Connection openConnection(String databaseName, String user, String password) throws SQLException {
        String url = this.config.getJDBCUrl(databaseName);
        try {
            DriverManager.getDriver(url);
        }
        catch (SQLException e) {
            this.loadJDBCDriver();
        }
        try {
            Properties props = new Properties();
            if (user != null) {
                props.setProperty(PartitionedRegion.rand.nextBoolean() ? "user" : "UserName", user);
                props.setProperty("password", password);
            }
            props = TestUtil.doMinimalSetup(props);
            return DriverManager.getConnection(url, props);
        }
        catch (SQLException e) {
            String expectedState;
            String string = expectedState = this.config.getJDBCClient().isEmbedded() ? "XJ004" : "08004";
            if (!expectedState.equals(e.getSQLState())) {
                throw e;
            }
            return this.getConnectionByAttributes(url, "create", "true");
        }
    }

    @Override
    public void shutDatabase() throws SQLException {
        this.getConnectionByAttributes(this.config.getJDBCUrl(), "shutdown", "true");
    }

    @Override
    public void shutEngine() throws SQLException {
        this.getConnectionByAttributes("jdbc:gemfirexd:", "shutdown", "true");
    }

    private Connection getConnectionByAttributes(String url, String key, String value) throws SQLException {
        Properties attributes = new Properties();
        attributes.setProperty("user", this.config.getUserName());
        attributes.setProperty("password", this.config.getUserPassword());
        attributes.setProperty(key, value);
        return DriverManager.getConnection(url, attributes);
    }

    private void loadJDBCDriver() throws SQLException {
        String driverClass = this.config.getJDBCClient().getJDBCDriverName();
        try {
            Class.forName(driverClass).newInstance();
        }
        catch (ClassNotFoundException cnfe) {
            throw new SQLException("Failed to load JDBC driver '" + driverClass + "': " + cnfe.getMessage());
        }
        catch (IllegalAccessException iae) {
            throw new SQLException("Failed to load JDBC driver '" + driverClass + "': " + iae.getMessage());
        }
        catch (InstantiationException ie) {
            throw new SQLException("Failed to load JDBC driver '" + driverClass + "': " + ie.getMessage());
        }
    }
}

