/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.junit;

import java.sql.Connection;
import java.sql.SQLException;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestSetup;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.TestConfiguration;

public abstract class BaseJDBCTestSetup
extends BaseTestSetup {
    private Connection conn;

    public BaseJDBCTestSetup(Test test) {
        super(test);
    }

    public final TestConfiguration getTestConfiguration() {
        return TestConfiguration.getCurrent();
    }

    public final Connection getConnection() throws SQLException {
        if (this.conn != null) {
            if (!this.conn.isClosed()) {
                return this.conn;
            }
            this.conn = null;
        }
        this.conn = this.getTestConfiguration().openDefaultConnection();
        return this.conn;
    }

    public void println(String text) {
        if (this.getTestConfiguration().isVerbose()) {
            System.out.println("DEBUG: " + text);
        }
    }

    protected void tearDown() throws Exception {
        JDBC.cleanup(this.conn);
        this.conn = null;
        BaseJDBCTestSetup.stopGemFireXDServer();
    }

    protected void preTearDown() throws Exception {
        BaseJDBCTestCase.preTearDown();
    }
}

