/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.util.streams;

import com.pivotal.gemfirexd.internal.iapi.types.Resetable;
import java.io.InputStream;
import org.apache.derbyTesting.functionTests.util.streams.ByteAlphabet;

public class LoopingAlphabetStream
extends InputStream
implements Resetable {
    private static final int MAX_BUF_SIZE = 32768;
    private static final byte SPACE = 32;
    private final long length;
    private final int trailingBlanks;
    private long remainingBlanks;
    private long remainingNonBlanks;
    private byte[] buffer = new byte[0];
    private final ByteAlphabet alphabet;

    public LoopingAlphabetStream(long length) {
        this(length, 0);
    }

    public LoopingAlphabetStream(long length, int trailingBlanks) {
        if ((long)trailingBlanks > length) {
            throw new IllegalArgumentException("Number of trailing blanks cannot be greater than the total length.");
        }
        this.length = length;
        this.trailingBlanks = trailingBlanks;
        this.remainingNonBlanks = length - (long)trailingBlanks;
        this.remainingBlanks = trailingBlanks;
        this.alphabet = ByteAlphabet.modernLatinLowercase();
        this.fillBuffer(this.alphabet.byteCount());
    }

    public LoopingAlphabetStream(long length, ByteAlphabet alphabet) {
        this(length, alphabet, 0);
    }

    public LoopingAlphabetStream(long length, ByteAlphabet alphabet, int trailingBlanks) {
        this.length = length;
        this.trailingBlanks = trailingBlanks;
        this.remainingNonBlanks = length - (long)trailingBlanks;
        this.remainingBlanks = trailingBlanks;
        this.alphabet = alphabet;
        this.fillBuffer(alphabet.byteCount());
    }

    @Override
    public int read() {
        if (this.remainingBlanks <= 0L && this.remainingNonBlanks <= 0L) {
            return -1;
        }
        if (this.remainingNonBlanks <= 0L) {
            --this.remainingBlanks;
            return 32;
        }
        --this.remainingNonBlanks;
        return this.alphabet.nextByte() & 0xFF;
    }

    @Override
    public int read(byte[] buf, int off, int length) {
        int read;
        if (this.remainingBlanks <= 0L && this.remainingNonBlanks <= 0L) {
            return -1;
        }
        int nonBlankLength = (int)Math.min(this.remainingNonBlanks, (long)length);
        this.fillBuffer(nonBlankLength);
        int bOff = this.alphabet.nextByteToRead(0);
        if (nonBlankLength <= this.buffer.length - bOff) {
            System.arraycopy(this.buffer, bOff, buf, off, nonBlankLength);
            this.remainingNonBlanks -= (long)nonBlankLength;
            read = nonBlankLength;
            this.alphabet.nextByteToRead(nonBlankLength);
        } else {
            int toRead = 0;
            for (read = 0; this.remainingNonBlanks > 0L && read < nonBlankLength; read += toRead) {
                bOff = this.alphabet.nextByteToRead(toRead);
                toRead = Math.min(this.buffer.length - bOff, nonBlankLength - read);
                System.arraycopy(this.buffer, bOff, buf, off + read, toRead);
                this.remainingNonBlanks -= (long)toRead;
            }
            bOff = this.alphabet.nextByteToRead(toRead);
        }
        if (read < length && this.remainingBlanks > 0L) {
            read += this.fillBlanks(buf, off + read, length - read);
        }
        return read;
    }

    @Override
    public void reset() {
        this.remainingNonBlanks = this.length - (long)this.trailingBlanks;
        this.remainingBlanks = this.trailingBlanks;
        this.alphabet.reset();
    }

    @Override
    public int available() {
        return (int)(this.remainingNonBlanks + this.remainingBlanks);
    }

    private void fillBuffer(int bufSize) {
        if (bufSize > 32768) {
            bufSize = 32768;
        }
        if (bufSize <= this.buffer.length) {
            return;
        }
        int curOff = this.alphabet.nextByteToRead(0);
        this.alphabet.reset();
        this.buffer = new byte[bufSize];
        for (int i = 0; i < bufSize; ++i) {
            this.buffer[i] = this.alphabet.nextByte();
        }
        this.alphabet.reset();
        this.alphabet.nextByteToRead(curOff);
    }

    private int fillBlanks(byte[] buf, int off, int length) {
        int i;
        for (i = 0; i < length && this.remainingBlanks > 0L; ++i) {
            buf[off + i] = 32;
            --this.remainingBlanks;
        }
        return i;
    }

    public void resetStream() {
        this.reset();
    }

    public void initStream() {
        this.reset();
    }

    public void closeStream() {
    }
}

