/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.util.streams;

import java.io.IOException;
import java.io.Reader;
import org.apache.derbyTesting.functionTests.util.streams.CharAlphabet;

public class LoopingAlphabetReader
extends Reader {
    private static final int MAX_BUF_SIZE = 32768;
    private static final int SPACE = 32;
    private final long length;
    private final int trailingBlanks;
    private long remainingNonBlanks;
    private long remainingBlanks;
    private char[] buffer = new char[0];
    private final CharAlphabet alphabet;
    private boolean closed = false;

    public LoopingAlphabetReader(long length) {
        this(length, 0);
    }

    public LoopingAlphabetReader(long length, int trailingBlanks) {
        this.length = length;
        this.trailingBlanks = trailingBlanks;
        this.remainingNonBlanks = length - (long)trailingBlanks;
        this.remainingBlanks = trailingBlanks;
        this.alphabet = CharAlphabet.modernLatinLowercase();
        this.fillBuffer(this.alphabet.charCount());
    }

    public LoopingAlphabetReader(long length, CharAlphabet alphabet) {
        this(length, alphabet, 0);
    }

    public LoopingAlphabetReader(long length, CharAlphabet alphabet, int trailingBlanks) {
        this.length = length;
        this.trailingBlanks = trailingBlanks;
        this.remainingNonBlanks = length - (long)trailingBlanks;
        this.remainingBlanks = trailingBlanks;
        this.alphabet = alphabet;
        this.fillBuffer(alphabet.charCount());
    }

    @Override
    public int read() throws IOException {
        this.ensureOpen();
        if (this.remainingBlanks <= 0L && this.remainingNonBlanks <= 0L) {
            return -1;
        }
        if (this.remainingNonBlanks <= 0L) {
            --this.remainingBlanks;
            return 32;
        }
        --this.remainingNonBlanks;
        return this.alphabet.nextCharAsInt();
    }

    @Override
    public int read(char[] buf, int off, int length) throws IOException {
        int read;
        this.ensureOpen();
        if (this.remainingBlanks <= 0L && this.remainingNonBlanks <= 0L) {
            return -1;
        }
        int nonBlankLength = Math.min((int)this.remainingNonBlanks, length);
        this.fillBuffer(nonBlankLength);
        int cOff = this.alphabet.nextCharToRead(0);
        if (nonBlankLength <= this.buffer.length - cOff) {
            System.arraycopy(this.buffer, cOff, buf, off, nonBlankLength);
            this.remainingNonBlanks -= (long)nonBlankLength;
            read = nonBlankLength;
            this.alphabet.nextCharToRead(nonBlankLength);
        } else {
            int toRead = 0;
            for (read = 0; this.remainingNonBlanks > 0L && read < nonBlankLength; read += toRead) {
                cOff = this.alphabet.nextCharToRead(toRead);
                toRead = Math.min(this.buffer.length - cOff, nonBlankLength - read);
                System.arraycopy(this.buffer, cOff, buf, off + read, toRead);
                this.remainingNonBlanks -= (long)toRead;
            }
            cOff = this.alphabet.nextCharToRead(toRead);
        }
        if (read < length && this.remainingBlanks > 0L) {
            read += this.fillBlanks(buf, off + read, length - read);
        }
        return read;
    }

    @Override
    public void reset() throws IOException {
        this.ensureOpen();
        this.remainingNonBlanks = this.length - (long)this.trailingBlanks;
        this.remainingBlanks = this.trailingBlanks;
        this.alphabet.reset();
    }

    public int available() {
        return (int)(this.remainingNonBlanks + this.remainingBlanks);
    }

    @Override
    public void close() {
        this.closed = true;
    }

    private void fillBuffer(int bufSize) {
        if (bufSize > 32768) {
            bufSize = 32768;
        }
        if (bufSize <= this.buffer.length) {
            return;
        }
        int curOff = this.alphabet.nextCharToRead(0);
        this.alphabet.reset();
        this.buffer = new char[bufSize];
        for (int i = 0; i < bufSize; ++i) {
            this.buffer[i] = this.alphabet.nextChar();
        }
        this.alphabet.reset();
        this.alphabet.nextCharToRead(curOff);
    }

    private int fillBlanks(char[] buf, int off, int length) {
        int i;
        for (i = 0; i < length && this.remainingBlanks > 0L; ++i) {
            buf[off + i] = 32;
            --this.remainingBlanks;
        }
        return i;
    }

    private final void ensureOpen() throws IOException {
        if (this.closed) {
            throw new IOException("Reader closed");
        }
    }
}

