/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.util.streams;

public class CharAlphabet {
    public static char[] MODERNLATINLOWER = new char[]{'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z'};
    public static char[] NO_DK_LOWER = new char[]{'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '\u00e6', '\u00f8', '\u00e5'};
    public static char[] TAMIL = new char[]{'\u0b85', '\u0b86', '\u0b87', '\u0b88', '\u0b89', '\u0b8a', '\u0b8e', '\u0b8f', '\u0b90', '\u0b92', '\u0b93', '\u0b94', '\u0b95', '\u0b99', '\u0b9a', '\u0b9c', '\u0b9e', '\u0b9f', '\u0ba3', '\u0ba4', '\u0ba8', '\u0ba9', '\u0baa', '\u0bae', '\u0baf', '\u0bb0', '\u0bb1', '\u0bb2', '\u0bb3', '\u0bb4', '\u0bb5', '\u0bb6', '\u0bb7', '\u0bb8', '\u0bb9', '\u0bbe', '\u0bbf', '\u0bc0', '\u0bc1', '\u0bc2', '\u0bc6', '\u0bc7', '\u0bc8', '\u0bca', '\u0bcb', '\u0bcc'};
    public static char[] CJKSUBSET = new char[]{'\u4e00', '\u4e01', '\u4e02', '\u4e03', '\u4e04', '\u4e05', '\u4e06', '\u4e07', '\u4e08', '\u4e09', '\u4e0a', '\u4e0b'};
    private final String name;
    private final char[] chars;
    private final int charCount;
    private int off = 0;

    public static CharAlphabet modernLatinLowercase() {
        return new CharAlphabet("Modern latin lowercase", MODERNLATINLOWER);
    }

    public static CharAlphabet cjkSubset() {
        return new CharAlphabet("CJK subset", CJKSUBSET);
    }

    public static CharAlphabet tamil() {
        return new CharAlphabet("Tamil", TAMIL);
    }

    private CharAlphabet(String name, char[] chars) {
        this.name = name;
        this.chars = chars;
        this.charCount = chars.length;
    }

    public String getName() {
        return this.name;
    }

    public int charCount() {
        return this.charCount;
    }

    public int nextCharAsInt() {
        if (this.off >= this.charCount) {
            this.off = 0;
        }
        return this.chars[this.off++];
    }

    public char nextChar() {
        if (this.off >= this.charCount) {
            this.off = 0;
        }
        return this.chars[this.off++];
    }

    public int nextCharToRead(int charsRead) {
        this.off = (this.off + charsRead % this.charCount) % this.charCount;
        return this.off;
    }

    public void reset() {
        this.off = 0;
    }
}

