/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.util;

import com.pivotal.gemfirexd.internal.iapi.db.Factory;
import com.pivotal.gemfirexd.internal.iapi.db.TriggerExecutionContext;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;

public class Triggers {
    private Triggers() {
    }

    public static String triggerFiresMinimal(String string) throws Throwable {
        System.out.println("TRIGGER: <" + string + ">");
        return "";
    }

    public static String triggerFires(String string) throws Throwable {
        TriggerExecutionContext tec = Factory.getTriggerExecutionContext();
        System.out.println("TRIGGER: <" + string + "> on statement " + tec.getEventStatementText());
        Triggers.printTriggerChanges();
        return "";
    }

    public static int doNothingInt() throws Throwable {
        return 1;
    }

    public static void doNothing() throws Throwable {
    }

    public static int doConnCommitInt() throws Throwable {
        Connection conn = DriverManager.getConnection("jdbc:default:connection");
        conn.commit();
        return 1;
    }

    public static void doConnCommit() throws Throwable {
        Connection conn = DriverManager.getConnection("jdbc:default:connection");
        conn.commit();
    }

    public static void doConnRollback() throws Throwable {
        Connection conn = DriverManager.getConnection("jdbc:default:connection");
        conn.rollback();
    }

    public static void doConnectionSetIsolation() throws Throwable {
        Connection conn = DriverManager.getConnection("jdbc:default:connection");
        conn.setTransactionIsolation(8);
    }

    public static int doConnStmtIntNoRS(String text) throws Throwable {
        Triggers.doConnStmtNoRS(text);
        return 1;
    }

    public static void doConnStmtNoRS(String text) throws Throwable {
        Connection conn = DriverManager.getConnection("jdbc:default:connection");
        Statement stmt = conn.createStatement();
        stmt.execute(text);
    }

    public static int doConnStmtInt(String text) throws Throwable {
        Triggers.doConnStmt(text);
        return 1;
    }

    public static void doConnStmt(String text) throws Throwable {
        Connection conn = DriverManager.getConnection("jdbc:default:connection");
        Statement stmt = conn.createStatement();
        if (stmt.execute(text)) {
            ResultSet rs = stmt.getResultSet();
            while (rs.next()) {
            }
            rs.close();
        }
        stmt.close();
        conn.close();
    }

    public static void getConnection() throws Throwable {
        Connection conn = DriverManager.getConnection("jdbc:default:connection");
        conn.close();
        System.out.println("getConnection() called");
    }

    static void zipThroughRs(ResultSet s) throws SQLException {
        if (s == null) {
            return;
        }
        while (s.next()) {
        }
    }

    private static void printTriggerChanges() throws Throwable {
        TriggerExecutionContext tec = Factory.getTriggerExecutionContext();
        System.out.println("BEFORE RESULT SET");
        Triggers.dumpRS(tec.getOldRowSet());
        System.out.println("\nAFTER RESULT SET");
        Triggers.dumpRS(tec.getNewRowSet());
    }

    private static void dumpRS(ResultSet s) throws SQLException {
        if (s == null) {
            System.out.println("<NULL>");
            return;
        }
        ResultSetMetaData rsmd = s.getMetaData();
        int numCols = rsmd.getColumnCount();
        if (numCols <= 0) {
            System.out.println("(no columns!)");
            return;
        }
        StringBuilder heading = new StringBuilder("\t ");
        StringBuilder underline = new StringBuilder("\t ");
        for (int i = 1; i <= numCols; ++i) {
            if (i > 1) {
                heading.append(",");
                underline.append(" ");
            }
            int len = heading.length();
            heading.append(rsmd.getColumnLabel(i));
            for (int j = len = heading.length() - len; j > 0; --j) {
                underline.append("-");
            }
        }
        System.out.println(heading.toString());
        System.out.println(underline.toString());
        StringBuilder row = new StringBuilder();
        while (s.next()) {
            row.append("\t{");
            for (int i = 1; i <= numCols; ++i) {
                if (i > 1) {
                    row.append(",");
                }
                row.append(s.getString(i));
            }
            row.append("}\n");
        }
        System.out.println(row.toString());
        s.close();
    }

    public static long returnPrimLong(long x) {
        return x;
    }

    public static Long returnLong(Long x) {
        return x;
    }
}

