/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.util;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;

public class TestRoutines {
    public static void installRoutines() throws SQLException {
        Connection conn = DriverManager.getConnection("jdbc:default:connection");
        TestRoutines.installRoutines(conn);
    }

    public static void installRoutines(Connection conn) throws SQLException {
        Statement s = conn.createStatement();
        s.execute("CREATE PROCEDURE TESTROUTINE.SET_SYSTEM_PROPERTY(IN PROPERTY_KEY VARCHAR(32000), IN PROPERTY_VALUE VARCHAR(32000)) NO SQL EXTERNAL NAME 'org.apache.derbyTesting.functionTests.util.TestRoutines.setSystemProperty' language java parameter style java");
        s.execute("CREATE PROCEDURE TESTROUTINE.SLEEP(IN SLEEP_TIME_MS BIGINT) NO SQL EXTERNAL NAME 'org.apache.derbyTesting.functionTests.util.TestRoutines.sleep' language java parameter style java");
        s.execute("CREATE FUNCTION TESTROUTINE.HAS_SECURITY_MANAGER() RETURNS INT NO SQL EXTERNAL NAME 'org.apache.derbyTesting.functionTests.util.TestRoutines.hasSecurityManager' language java parameter style java");
        s.execute("CREATE FUNCTION TESTROUTINE.READ_FILE(FILE_NAME VARCHAR(60), ENCODING VARCHAR(60)) RETURNS VARCHAR(32000) NO SQL EXTERNAL NAME 'org.apache.derbyTesting.functionTests.util.TestRoutines.readFile' language java parameter style java");
        s.close();
    }

    public static void setSystemProperty(final String key, final String value) {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                System.setProperty(key, value);
                return null;
            }
        });
    }

    public static void sleep(long ms) throws InterruptedException {
        Thread.sleep(ms);
    }

    public static int hasSecurityManager() {
        return System.getSecurityManager() == null ? 0 : 1;
    }

    public static String readFile(final String fileName, String encoding) throws PrivilegedActionException, IOException {
        int ci;
        FileInputStream fin = (FileInputStream)AccessController.doPrivileged(new PrivilegedExceptionAction(){

            public Object run() throws FileNotFoundException {
                return new FileInputStream(fileName);
            }
        });
        InputStreamReader isr = new InputStreamReader((InputStream)new BufferedInputStream(fin, 32768), encoding);
        StringBuilder sb = new StringBuilder();
        while ((ci = isr.read()) >= 0) {
            if (ci <= 127) {
                sb.append((char)ci);
                continue;
            }
            sb.append("\\u");
            String hex = Integer.toHexString(ci);
            switch (hex.length()) {
                case 2: {
                    sb.append("00");
                    break;
                }
                case 3: {
                    sb.append("0");
                }
            }
            sb.append(hex);
        }
        return sb.toString();
    }
}

