/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.util;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;

public class T_Authorize {
    public static void verifyAccessRW(int k) throws Exception {
        T_Authorize.verifyAccess(k, false);
    }

    public static void verifyAccessRO(int k) throws Exception {
        T_Authorize.verifyAccess(k, true);
    }

    private static void verifyAccess(int k, boolean shouldBeReadOnly) throws Exception {
        int[] args = new int[2];
        int[] qArgs = new int[2];
        Connection c = DriverManager.getConnection("jdbc:default:connection");
        if (c.isReadOnly() != shouldBeReadOnly) {
            throw new Exception("Connection read-only mode does not match " + shouldBeReadOnly);
        }
        String sText = "create table t2 (a int)";
        T_Authorize.verifyExecute(c, sText, 0, args, shouldBeReadOnly, 0);
        if (!shouldBeReadOnly) {
            sText = "drop table t2";
            T_Authorize.verifyExecute(c, sText, 0, args, shouldBeReadOnly, 0);
        }
        args[0] = k;
        sText = "insert into AUTH_TEST.t1 values ?";
        T_Authorize.verifyExecute(c, sText, 1, args, shouldBeReadOnly, 1);
        String qText = "select a from AUTH_TEST.t1 where a = ?";
        qArgs[0] = k;
        T_Authorize.verifyResult(c, qText, 1, qArgs, !shouldBeReadOnly, Integer.toString(k));
        args[0] = -k;
        args[1] = k;
        sText = "update AUTH_TEST.t1 set a=? where a=?";
        T_Authorize.verifyExecute(c, sText, 2, args, shouldBeReadOnly, 1);
        qArgs[0] = -k;
        T_Authorize.verifyResult(c, qText, 1, qArgs, !shouldBeReadOnly, Integer.toString(-k));
        sText = "delete from AUTH_TEST.t1 where a=?";
        T_Authorize.verifyExecute(c, sText, 1, args, shouldBeReadOnly, 1);
        T_Authorize.verifyResult(c, qText, 1, qArgs, false, null);
        sText = "call sqlj.install_jar(AUTH_TEST.resourcefile('org.apache.derbyTesting.functionTests.testData.v1','j1v1.jar', 'extinout/j1v1.jar'), 'APP.J1', 0)";
        T_Authorize.verifyExecute(c, sText, 0, args, shouldBeReadOnly, 0);
        qText = "select filename from sys.sysfiles where filename = 'J1'";
        T_Authorize.verifyResult(c, qText, 0, qArgs, !shouldBeReadOnly, "J1");
        sText = shouldBeReadOnly ? "call sqlj.replace_jar(AUTH_TEST.resourcefile('org.apache.derbyTesting.functionTests.testData.v2','j1v2.jar', 'extinout/j1v2.jar'), 'APP.IMMUTABLE')" : "call sqlj.replace_jar(AUTH_TEST.resourcefile('org.apache.derbyTesting.functionTests.testData.v2','j1v2.jar', 'extinout/j1v2.jar'), 'APP.J1')";
        T_Authorize.verifyExecute(c, sText, 0, args, shouldBeReadOnly, 0);
        T_Authorize.verifyResult(c, qText, 0, qArgs, !shouldBeReadOnly, "J1");
        sText = shouldBeReadOnly ? "call sqlj.remove_jar('APP.IMMUTABLE', 0)" : "call sqlj.remove_jar('APP.J1', 0)";
        T_Authorize.verifyExecute(c, sText, 0, args, shouldBeReadOnly, 0);
        T_Authorize.verifyResult(c, qText, 0, qArgs, false, null);
        c.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void verifyExecute(Connection c, String sText, int paramCount, int[] args, boolean shouldBeReadOnly, int expectRowCount) throws Exception {
        try (PreparedStatement ps = null;){
            ps = c.prepareStatement(sText);
            for (int ix = 0; ix < paramCount; ++ix) {
                ps.setInt(ix + 1, args[ix]);
            }
            int rc = ps.executeUpdate();
            if (shouldBeReadOnly) {
                throw new Exception("operation incorrectly allowed for read only connection " + sText);
            }
            if (rc != expectRowCount) {
                StringBuilder argSb = new StringBuilder();
                for (int ix = 0; ix < paramCount; ++ix) {
                    if (ix != 0) {
                        argSb.append(",");
                    }
                    argSb.append(args[ix]);
                }
                throw new Exception("Incorrect row count " + rc + " for " + sText + " with args " + argSb);
            }
        }
    }

    private static void verifyResult(Connection c, String qText, int paramCount, int[] args, boolean expectResult, String expect) throws Exception {
        PreparedStatement ps = c.prepareStatement(qText);
        for (int ix = 0; ix < paramCount; ++ix) {
            ps.setInt(ix + 1, args[ix]);
        }
        ResultSet rs = ps.executeQuery();
        boolean isRow = rs.next();
        if (expectResult) {
            String colVal;
            if (!isRow) {
                throw new Exception("incorrect row count");
            }
            ResultSetMetaData rmd = rs.getMetaData();
            if (rmd.getColumnCount() != 1) {
                new Exception("bad column count");
            }
            if (!expect.equals(colVal = rs.getString(1))) {
                throw new Exception("bad return column " + colVal);
            }
            isRow = rs.next();
            if (isRow) {
                throw new Exception("incorrect row count");
            }
        } else if (isRow) {
            throw new Exception("incorrect row count");
        }
    }
}

