/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.SortedMap;
import java.util.TreeMap;
import junit.framework.Assert;

public class SecurityCheck {
    private static final String[] EMBEDDED_PUBLIC_API = new String[]{"com.pivotal.gemfirexd.jdbc.EmbeddedDriver", "com.pivotal.gemfirexd.internal.jdbc.EmbeddedDataSource", "com.pivotal.gemfirexd.internal.jdbc.EmbeddedSimpleDataSource", "com.pivotal.gemfirexd.internal.jdbc.EmbeddedConnectionPoolDataSource", "com.pivotal.gemfirexd.internal.jdbc.EmbeddedXADataSource", "com.pivotal.gemfirexd.internal.authentication.UserAuthenticator"};
    private static final SortedMap allInspectedClasses = new TreeMap();

    private static boolean isPublicApi(Class c) {
        for (int i = 0; i < EMBEDDED_PUBLIC_API.length; ++i) {
            if (!EMBEDDED_PUBLIC_API[i].equals(c.getName())) continue;
            return true;
        }
        return false;
    }

    public static void checkEmbeddedPublicApi() throws ClassNotFoundException {
        System.out.println("SecurityCheck: embedded public api classes");
        allInspectedClasses.clear();
        for (int i = 0; i < EMBEDDED_PUBLIC_API.length; ++i) {
            SecurityCheck.inspectClass(EMBEDDED_PUBLIC_API[i]);
        }
        SecurityCheck.report(true);
    }

    public static void report() {
        SecurityCheck.report(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void report(boolean reportClear) {
        SortedMap sortedMap = allInspectedClasses;
        synchronized (sortedMap) {
            for (Object key : allInspectedClasses.keySet()) {
                Object value = allInspectedClasses.get(key);
                if (value == null) {
                    if (!reportClear) continue;
                    System.out.println("CLEAR: " + key);
                    continue;
                }
                System.out.print(value);
            }
        }
    }

    public static void inspectClass(String className) throws ClassNotFoundException {
        SecurityCheck.inspectClass(Class.forName(className), null);
    }

    public static void assertSourceSecurity(Object o, String declared) {
        Assert.assertNotNull((Object)o);
        Assert.assertTrue((boolean)SecurityCheck.inspectClass(o.getClass(), declared));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean inspectClass(Class c, String declared) {
        if (!c.getName().startsWith("com.pivotal.gemfirexd.internal.")) {
            return false;
        }
        if (c.getName().startsWith("com.pivotal.gemfirexd.internal.client.")) {
            return false;
        }
        SortedMap sortedMap = allInspectedClasses;
        synchronized (sortedMap) {
            boolean hasPublicConstructor;
            if (allInspectedClasses.containsKey(c.getName())) {
                return true;
            }
            allInspectedClasses.put(c.getName(), null);
            StringBuilder sb = new StringBuilder();
            sb.append("Class ");
            sb.append(c.getName());
            sb.append('\n');
            if (declared != null) {
                allInspectedClasses.put(declared, "Checked class declared as: " + declared + "\n");
            }
            boolean isPublicApi = SecurityCheck.isPublicApi(c);
            boolean hasIssues = false;
            boolean isSealed = c.getPackage().isSealed();
            boolean isFinal = Modifier.isFinal(c.getModifiers());
            boolean isPublic = Modifier.isPublic(c.getModifiers());
            boolean isAbstract = Modifier.isAbstract(c.getModifiers());
            Constructor<?>[] constructors = c.getConstructors();
            boolean bl = hasPublicConstructor = constructors.length != 0;
            if (hasPublicConstructor && !isPublic) {
                hasIssues = true;
                sb.append("..public constructors in non-public class\n");
                if (!isFinal && !isSealed) {
                    sb.append("..public constructors in non-final class and non-sealed package\n");
                }
            }
            if (hasPublicConstructor && isPublic) {
                if (!isPublicApi) {
                    // empty if block
                }
                if (!isFinal) {
                    // empty if block
                }
            }
            for (int i = 0; i < constructors.length; ++i) {
                if (!hasIssues) continue;
                sb.append("..public constructor: ");
                sb.append(constructors[i].toString());
                sb.append('\n');
            }
            Field[] fields = c.getFields();
            for (int i = 0; i < fields.length; ++i) {
                Field f = fields[i];
                boolean isStatic = Modifier.isStatic(f.getModifiers());
                Class<?> fieldType = f.getType();
                SecurityCheck.inspectClass(fieldType, null);
                if (Modifier.isFinal(f.getModifiers())) continue;
                hasIssues = true;
                sb.append("..public non-final field: ");
                sb.append(f.toString());
                sb.append('\n');
            }
            Method[] methods = c.getMethods();
            for (int i = 0; i < methods.length; ++i) {
                Method m = methods[i];
                Class<?> methodType = m.getReturnType();
                if (SecurityCheck.inspectClass(methodType, null) && !SecurityCheck.isPublicApi(methodType)) continue;
            }
            if (hasIssues) {
                allInspectedClasses.put(c.getName(), sb.toString());
            }
        }
        return true;
    }
}

