/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.util;

import com.pivotal.gemfirexd.internal.tools.ij;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.sql.Connection;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.apache.derbyTesting.functionTests.util.CanonTestCase;
import org.apache.derbyTesting.junit.Derby;

public abstract class ScriptTestCase
extends CanonTestCase {
    private final String inputEncoding;

    public ScriptTestCase(String script) {
        super(script);
        this.inputEncoding = "US-ASCII";
    }

    protected String getArea() {
        String name = ((Object)((Object)this)).getClass().getName();
        int lastDot = name.lastIndexOf(46);
        name = name.substring(0, lastDot);
        lastDot = name.lastIndexOf(46);
        return name.substring(lastDot + 1);
    }

    public static Test getIJConfig(Test test) {
        if (!Derby.hasTools()) {
            return new TestSuite("empty: no tools support");
        }
        return test;
    }

    public void runTest() throws Throwable {
        String resource = "org/apache/derbyTesting/functionTests/tests/" + this.getArea() + "/" + this.getName() + ".sql";
        String canon = "org/apache/derbyTesting/functionTests/master/" + this.getName() + ".out";
        URL sql = ScriptTestCase.getTestResource(resource);
        ScriptTestCase.assertNotNull((String)("SQL script missing: " + resource), (Object)sql);
        InputStream sqlIn = ScriptTestCase.openTestResource(sql);
        Connection conn = this.getConnection();
        ij.runScript((Connection)conn, (InputStream)sqlIn, (String)this.inputEncoding, (OutputStream)this.getOutputStream(), (String)"US-ASCII");
        if (!conn.isClosed() && !conn.getAutoCommit()) {
            conn.commit();
        }
        sqlIn.close();
        this.compareCanon(canon);
    }
}

