/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;

public class PrivilegedFileOpsForTests {
    public static long length(final File file) throws SecurityException {
        if (file == null) {
            throw new IllegalArgumentException("file cannot be <null>");
        }
        try {
            return (Long)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws SecurityException {
                    return new Long(file.length());
                }
            });
        }
        catch (PrivilegedActionException pae) {
            throw (SecurityException)pae.getException();
        }
    }

    public static FileInputStream getFileInputStream(final File file) throws SecurityException, FileNotFoundException {
        if (file == null) {
            throw new IllegalArgumentException("file cannot be <null>");
        }
        try {
            return (FileInputStream)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws SecurityException, FileNotFoundException {
                    return new FileInputStream(file);
                }
            });
        }
        catch (PrivilegedActionException pae) {
            throw (SecurityException)pae.getException();
        }
    }

    public static boolean exists(final File file) throws SecurityException {
        if (file == null) {
            throw new IllegalArgumentException("file cannot be <null>");
        }
        try {
            return (Boolean)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws SecurityException {
                    return new Boolean(file.exists());
                }
            });
        }
        catch (PrivilegedActionException pae) {
            throw (SecurityException)pae.getException();
        }
    }

    public static boolean mkdirs(final File file) {
        if (file == null) {
            throw new IllegalArgumentException("file cannot be <null>");
        }
        try {
            return (Boolean)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws SecurityException {
                    return new Boolean(file.mkdirs());
                }
            });
        }
        catch (PrivilegedActionException pae) {
            throw (SecurityException)pae.getException();
        }
    }
}

