/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.util;

import com.pivotal.gemfirexd.internal.tools.JDBCDisplayUtil;
import java.io.PrintStream;
import java.sql.SQLException;

public class JDBCTestDisplayUtil
extends JDBCDisplayUtil {
    public static void ShowCommonSQLException(PrintStream out, Throwable e) {
        if (e == null) {
            return;
        }
        if (e instanceof SQLException) {
            SQLException se = (SQLException)e;
            if (JDBCTestDisplayUtil.isDataConversionException(se)) {
                out.println("Data Conversion SQLException");
            } else if (JDBCTestDisplayUtil.isResultSetClosedException(se)) {
                out.println("Result Set Closed Exception");
            } else if (JDBCTestDisplayUtil.isNullSQLStringException(se)) {
                out.println("Null SQL String Exception");
            } else if (JDBCTestDisplayUtil.isInvalidParameterException(se)) {
                out.println("Invalid Parameter SQL Exception");
            } else if (JDBCTestDisplayUtil.isValidOnScrollCursorsException(se)) {
                out.println("Method Only Valid On Scroll Cursors SQL Exception");
            } else if (JDBCTestDisplayUtil.isInvalidMethodReturnException(se)) {
                out.println("Invalid Method Returning a ResultSet or Row Count SQL Exception");
            } else if (JDBCTestDisplayUtil.isTableDoesNotExistException(se)) {
                out.println("Table Does Not Exist SQL Exception");
            } else if (JDBCTestDisplayUtil.isReturnsInvalidResultSetException(se)) {
                out.println("Invalid Method Returning ResultSet SQL Exception");
            } else {
                JDBCTestDisplayUtil.ShowSQLException((PrintStream)out, (SQLException)se);
            }
        } else {
            JDBCTestDisplayUtil.ShowException((PrintStream)out, (Throwable)e);
        }
    }

    private static boolean isDataConversionException(SQLException se) {
        return se.getMessage() != null && se.getMessage().indexOf("Invalid data conversion") >= 0 || se.getSQLState() != null && (se.getSQLState().equals("22018") || se.getSQLState().equals("22005") || se.getSQLState().equals("22007"));
    }

    private static boolean isResultSetClosedException(SQLException se) {
        return se.getMessage() != null && se.getMessage().indexOf("Invalid operation: result set closed") >= 0 || se.getSQLState() != null && se.getSQLState().equals("XCL16");
    }

    private static boolean isNullSQLStringException(SQLException se) {
        return se.getMessage() != null && se.getMessage().indexOf("Null SQL string passed.") >= 0 || se.getSQLState() != null && se.getSQLState().equals("XJ067");
    }

    private static boolean isInvalidParameterException(SQLException se) {
        return se.getMessage() != null && se.getMessage().indexOf("Invalid parameter value") >= 0 || se.getMessage().indexOf("Invalid fetch size") >= 0 || se.getMessage().indexOf("Invalid fetch direction") >= 0 || se.getSQLState() != null && se.getSQLState().equals("XJ066");
    }

    private static boolean isValidOnScrollCursorsException(SQLException se) {
        return se.getMessage() != null && se.getMessage().indexOf("' method is only allowed on scroll cursors.") >= 0 || se.getSQLState() != null && se.getSQLState().equals("XJ061");
    }

    private static boolean isInvalidMethodReturnException(SQLException se) {
        return se.getMessage() != null && se.getMessage().indexOf("executeQuery method cannot be used for update.") >= 0 || se.getMessage().indexOf("executeUpdate method cannot be used for query.") >= 0 || se.getSQLState() != null && (se.getSQLState().equals("X0Y78") || se.getSQLState().equals("X0Y79"));
    }

    private static boolean isTableDoesNotExistException(SQLException se) {
        return se.getSQLState() != null && se.getSQLState().equals("42X05");
    }

    private static boolean isReturnsInvalidResultSetException(SQLException se) {
        return se.getMessage() != null && se.getMessage().indexOf("cannot be called with a statement that returns a ResultSet.") >= 0 || se.getSQLState() != null && se.getSQLState().equals("X0Y79");
    }
}

