/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.util;

import com.pivotal.gemfirexd.internal.tools.ij;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.OutputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import junit.framework.TestCase;
import org.apache.derbyTesting.functionTests.util.ScriptTestCase;

public class IjTestCase
extends ScriptTestCase {
    String scriptName = this.getName() + ".sql";
    String outfileName = "extinout/" + this.getName() + ".out";
    File outfile = new File(this.outfileName);

    public IjTestCase(String name) {
        super(name);
    }

    public void setUp() throws Exception {
        super.setUp();
        IjTestCase.setSystemProperty("ij.outfile", this.outfileName);
        IjTestCase.setSystemProperty("ij.defaultResourcePackage", "/org/apache/derbyTesting/functionTests/tests/" + this.getArea() + "/");
    }

    @Override
    public void tearDown() throws Exception {
        super.tearDown();
        IjTestCase.removeSystemProperty("ij.outfile");
        IjTestCase.removeSystemProperty("ij.defaultResourcePackage");
    }

    @Override
    public void runTest() throws Throwable {
        int b;
        String[] args = new String[]{"-fr", this.scriptName};
        ij.main((String[])args);
        String canon = "org/apache/derbyTesting/functionTests/master/" + this.getName() + ".out";
        final File out = this.outfile;
        FileInputStream fis = (FileInputStream)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                FileInputStream fis = null;
                try {
                    fis = new FileInputStream(out);
                }
                catch (FileNotFoundException e) {
                    TestCase.fail((String)"Could not open ij output file.");
                }
                return fis;
            }
        });
        OutputStream os = this.getOutputStream();
        while ((b = fis.read()) != -1) {
            os.write(b);
        }
        fis.close();
        Boolean deleted = (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                boolean d = IjTestCase.this.outfile.delete();
                return new Boolean(d);
            }
        });
        if (!deleted.booleanValue()) {
            IjTestCase.println("Could not delete outfile for " + this.scriptName);
        }
        this.compareCanon(canon);
    }
}

