/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.util;

import java.util.Arrays;

public class Formatters {
    static final char[] hexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public static String format(String in) {
        if (in == null) {
            return null;
        }
        StringBuilder out = new StringBuilder(in.length());
        char[] hexValue = new char[4];
        for (int i = 0; i < in.length(); ++i) {
            int inChar = in.charAt(i);
            if (inChar < 128) {
                out.append((char)inChar);
                continue;
            }
            out.append("\\u");
            int number = inChar;
            int digit = number % 16;
            hexValue[3] = hexDigits[digit];
            digit = (number /= 16) % 16;
            hexValue[2] = hexDigits[digit];
            digit = (number /= 16) % 16;
            hexValue[1] = hexDigits[digit];
            digit = (number /= 16) % 16;
            hexValue[0] = hexDigits[digit];
            out.append(hexValue);
        }
        return out.toString();
    }

    public static String repeatChar(String c, int repeatCount) {
        char ch = c.charAt(0);
        char[] chArray = new char[repeatCount];
        for (int i = 0; i < repeatCount; ++i) {
            chArray[i] = ch;
        }
        return new String(chArray);
    }

    public static String padString(String oldValue, int size) {
        String newValue = oldValue;
        if (newValue != null) {
            char[] newCharArr = new char[size];
            oldValue.getChars(0, oldValue.length(), newCharArr, 0);
            Arrays.fill(newCharArr, oldValue.length(), newCharArr.length - 1, ' ');
            newValue = new String(newCharArr);
        }
        return newValue;
    }
}

