/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.util;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;

abstract class CanonTestCase
extends BaseJDBCTestCase {
    final String outputEncoding = "US-ASCII";
    private ByteArrayOutputStream rawBytes;

    CanonTestCase(String name) {
        super(name);
    }

    OutputStream getOutputStream() {
        this.rawBytes = new ByteArrayOutputStream(20480);
        return this.rawBytes;
    }

    void compareCanon(String canon) throws Throwable {
        this.rawBytes.flush();
        this.rawBytes.close();
        byte[] testRawBytes = this.rawBytes.toByteArray();
        try {
            String testLine;
            BufferedReader testOutput = new BufferedReader(new InputStreamReader((InputStream)new ByteArrayInputStream(testRawBytes), "US-ASCII"));
            int lineNumber = 1;
            while ((testLine = testOutput.readLine()) != null) {
                if (testLine.startsWith("ERROR XJ001")) {
                    CanonTestCase.assertEquals((String)("Found exception at line " + lineNumber + " with text " + testLine), (String)"String", (String)"DifferentString");
                }
                ++lineNumber;
            }
            testOutput.close();
        }
        catch (Throwable t) {
            this.dumpForFail(testRawBytes);
            throw t;
        }
    }

    private void dumpForFail(byte[] rawOutput) throws IOException, PrivilegedActionException {
        File folder = this.getFailureFolder();
        final File outFile = new File(folder, this.getName() + ".out");
        OutputStream outStream = (OutputStream)AccessController.doPrivileged(new PrivilegedExceptionAction(){

            public Object run() throws IOException {
                return new FileOutputStream(outFile);
            }
        });
        outStream.write(rawOutput);
        outStream.flush();
        outStream.close();
    }

    @Override
    protected void tearDown() throws Exception {
        this.rawBytes = null;
        super.tearDown();
    }
}

