/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.upgradeTests;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.sql.SQLException;
import javax.sql.DataSource;
import junit.framework.Test;
import org.apache.derbyTesting.functionTests.tests.upgradeTests.UpgradeChange;
import org.apache.derbyTesting.functionTests.tests.upgradeTests.UpgradeRun;
import org.apache.derbyTesting.junit.BaseTestSetup;
import org.apache.derbyTesting.junit.JDBCDataSource;

final class PhaseChanger
extends BaseTestSetup {
    private final int phase;
    private final int[] version;
    private ClassLoader loader;
    private ClassLoader previousLoader;

    public PhaseChanger(Test test, int phase, ClassLoader loader, int[] version) {
        super(test);
        this.phase = phase;
        this.loader = loader;
        this.version = version;
    }

    protected void setUp() throws SQLException {
        UpgradeChange.phase.set(new Integer(this.phase));
        UpgradeChange.oldVersion.set(this.version);
        if (this.loader != null) {
            this.previousLoader = Thread.currentThread().getContextClassLoader();
            this.setThreadLoader(this.loader);
        }
        DataSource ds = JDBCDataSource.getDataSource();
        switch (this.phase) {
            case 4: {
                return;
            }
            case 0: {
                JDBCDataSource.setBeanProperty(ds, "createDatabase", "create");
                break;
            }
            case 3: {
                JDBCDataSource.setBeanProperty(ds, "connectionAttributes", "upgrade=true");
                break;
            }
        }
        ds.getConnection().close();
    }

    protected void tearDown() throws InterruptedException {
        if (this.phase != 4) {
            DataSource ds = JDBCDataSource.getDataSource();
            JDBCDataSource.shutdownDatabase(ds);
            for (int i = 0; i < UpgradeRun.ADDITIONAL_DBS.length; ++i) {
                boolean shutdown2;
                block5: {
                    ds = JDBCDataSource.getDataSourceLogical(UpgradeRun.ADDITIONAL_DBS[i].logicalName);
                    if (!UpgradeRun.ADDITIONAL_DBS[i].shutDown) continue;
                    shutdown2 = true;
                    try {
                        ds.getConnection().close();
                    }
                    catch (SQLException e) {
                        String sqlState = e.getSQLState();
                        if (!"XJ004".equals(sqlState) && !"XJ040".equals(sqlState)) break block5;
                        shutdown2 = false;
                    }
                }
                if (!shutdown2) continue;
                JDBCDataSource.shutdownDatabase(ds);
            }
        }
        if (this.loader != null) {
            this.setThreadLoader(this.previousLoader);
        }
        this.loader = null;
        this.previousLoader = null;
        UpgradeChange.phase.set(null);
        UpgradeChange.oldVersion.set(null);
    }

    private void setThreadLoader(final ClassLoader which) {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                Thread.currentThread().setContextClassLoader(which);
                return null;
            }
        });
    }

    private ClassLoader getThreadLoader() {
        return (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return Thread.currentThread().getContextClassLoader();
            }
        });
    }
}

