/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.upgradeTests;

import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.apache.derbyTesting.functionTests.tests.jdbcapi.BlobStoredProcedureTest;
import org.apache.derbyTesting.functionTests.tests.jdbcapi.ClobStoredProcedureTest;
import org.apache.derbyTesting.functionTests.tests.upgradeTests.UpgradeChange;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.SupportFilesSetup;

public class Changes10_3
extends UpgradeChange {
    private static final String UNKNOWN_PROCEDURE = "42Y03";

    public static Test suite(int phase) {
        TestSuite suite = new TestSuite("Upgrade changes for 10.3");
        suite.addTestSuite(Changes10_3.class);
        if (phase == 3 && JDBC.vmSupportsJDBC3()) {
            suite.addTestSuite(BlobStoredProcedureTest.class);
            suite.addTestSuite(ClobStoredProcedureTest.class);
        }
        return new SupportFilesSetup((Test)suite);
    }

    public Changes10_3(String name) {
        super(name);
    }

    public void testCompilationSchema() throws SQLException {
        switch (this.getPhase()) {
            case 0: 
            case 2: {
                if (this.oldAtLeast(10, 3)) break;
                return;
            }
        }
        DatabaseMetaData dmd = this.getConnection().getMetaData();
        ResultSet rs = dmd.getColumns(null, "SYS", "SYSSTATEMENTS", "COMPILATIONSCHEMAID");
        rs.next();
        Changes10_3.assertEquals((String)"SYS.SYSSTATEMENTS.COMPILATIONSCHEMAID IS_NULLABLE", (String)"YES", (String)rs.getString("IS_NULLABLE"));
        rs.close();
        rs = dmd.getColumns(null, "SYS", "SYSVIEWS", "COMPILATIONSCHEMAID");
        rs.next();
        Changes10_3.assertEquals((String)"SYS.SYSVIEWS.COMPILATIONSCHEMAID IS_NULLABLE", (String)"YES", (String)rs.getString("IS_NULLABLE"));
    }

    public void testNegValueSupportedLogRecord() throws SQLException {
        switch (this.getPhase()) {
            case 0: {
                Statement s = this.createStatement();
                s.execute("create table case606(keycol int, indcol1 int,indcol2 int, data1 char(24), data2 char(24), data3 char(24),data4 char(24), data5 char(24), data6 char(24),data7 char(24), data8 char(24), data9 char(24),data10 char(24), inddec1 decimal(8), indcol3 int,indcol4 int, data11 varchar(50))");
                s.close();
                break;
            }
            case 1: {
                if (!this.oldAtLeast(10, 1)) {
                    return;
                }
                this.checkDataToCase606(0, 2000);
                break;
            }
            case 2: {
                if (!this.oldAtLeast(10, 1)) {
                    return;
                }
                this.checkDataToCase606(0, 1000);
                break;
            }
            case 3: {
                if (!this.oldAtLeast(10, 1)) {
                    return;
                }
                this.checkDataToCase606(0, 94000);
            }
        }
    }

    private void checkDataToCase606(int start_value, int end_value) throws SQLException {
        int i;
        this.getConnection().setAutoCommit(false);
        Statement s = this.createStatement();
        PreparedStatement insert_stmt = this.prepareStatement("insert into case606 values(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
        char[] data_dt = new char[24];
        char[] data_dt2 = new char[50];
        for (i = 0; i < data_dt.length; ++i) {
            data_dt[i] = 97;
        }
        for (i = 0; i < data_dt2.length; ++i) {
            data_dt2[i] = 122;
        }
        String data1_str = new String(data_dt);
        String data2_str = new String(data_dt2);
        for (int i2 = start_value; i2 < end_value; ++i2) {
            insert_stmt.setInt(1, i2);
            insert_stmt.setInt(2, i2 * 10);
            insert_stmt.setInt(3, i2 * 100);
            insert_stmt.setString(4, data1_str);
            insert_stmt.setString(5, data1_str);
            insert_stmt.setString(6, data1_str);
            insert_stmt.setString(7, data1_str);
            insert_stmt.setString(8, data1_str);
            insert_stmt.setString(9, data1_str);
            insert_stmt.setString(10, data1_str);
            insert_stmt.setString(11, data1_str);
            insert_stmt.setString(12, data1_str);
            insert_stmt.setString(13, data1_str);
            insert_stmt.setInt(14, i2 * 20);
            insert_stmt.setInt(15, i2 * 200);
            insert_stmt.setInt(16, i2 * 50);
            insert_stmt.setString(17, data2_str);
            insert_stmt.execute();
        }
        insert_stmt.close();
        this.commit();
        s.execute("delete from case606 where case606.keycol > 10000");
        this.commit();
        String schema = this.getTestConfiguration().getUserName();
        s.execute("call SYSCS_UTIL.INPLACE_COMPRESS_TABLE('" + schema + "', 'CASE606',1,1,1)");
        s.close();
        this.commit();
    }

    public void testImportExportLobsProcedures() throws SQLException {
        switch (this.getPhase()) {
            case 0: {
                Statement s = this.createStatement();
                s.execute("create table iet1(id int , content clob , pic blob)");
                s.executeUpdate("insert into iet1 values (1, 'SQL Tips', cast(X'4231a2' as blob))");
                s.close();
                this.commit();
                break;
            }
            case 1: {
                Statement s = this.createStatement();
                Changes10_3.assertStatementError(UNKNOWN_PROCEDURE, s, "call SYSCS_UTIL.EXPORT_TABLE_LOBS_TO_EXTFILE(null , 'IET1' , 'iet1.del' , null, null, null, 'iet1_lobs.dat')");
                s.close();
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                String fileName = SupportFilesSetup.getReadWrite("iet1.del").getPath();
                String lobsFileName = SupportFilesSetup.getReadWrite("iet1_lobs.dat").getPath();
                Statement s = this.createStatement();
                SupportFilesSetup.deleteFile(fileName);
                SupportFilesSetup.deleteFile(lobsFileName);
                s.execute("call SYSCS_UTIL.EXPORT_TABLE_LOBS_TO_EXTFILE(null , 'IET1' , '" + fileName + "' , null, null, null, '" + lobsFileName + "')");
                s.execute("call SYSCS_UTIL.IMPORT_TABLE_LOBS_FROM_EXTFILE(null, 'IET1' , '" + fileName + "', null, null, null, 0)");
                SupportFilesSetup.deleteFile(fileName);
                SupportFilesSetup.deleteFile(lobsFileName);
                s.execute("call SYSCS_UTIL.EXPORT_QUERY_LOBS_TO_EXTFILE('select * from IET1', '" + fileName + "' , null, null, null, '" + lobsFileName + "')");
                s.execute("call SYSCS_UTIL.IMPORT_DATA_LOBS_FROM_EXTFILE(null, 'IET1','ID, CONTENT, PIC', '1,2,3','" + fileName + "', null, null, null, 1)");
                ResultSet rs = s.executeQuery("select * from iet1");
                JDBC.assertFullResultSet(rs, new String[][]{{"1", "SQL Tips", "4231a2"}, {"1", "SQL Tips", "4231a2"}});
                s.close();
                break;
            }
        }
    }

    public void testPolicyReloadingProcedure() throws SQLException {
        int currentPhase = this.getPhase();
        switch (currentPhase) {
            case 0: 
            case 1: 
            case 2: {
                this.assertPolicyReloaderDoesNotExist();
                break;
            }
            case 3: {
                this.assertPolicyReloaderExists();
                break;
            }
            default: {
                throw new SQLException("Unknown upgrade phase: " + currentPhase);
            }
        }
    }

    private void assertPolicyReloaderExists() throws SQLException {
        this.tryReloading(true, null);
    }

    private void assertPolicyReloaderDoesNotExist() throws SQLException {
        this.tryReloading(false, UNKNOWN_PROCEDURE);
    }

    private void tryReloading(boolean shouldSucceed, String expectedSQLState) throws SQLException {
        boolean didSucceed = false;
        try {
            Statement s = this.createStatement();
            s.execute("call SYSCS_UTIL.RELOAD_SECURITY_POLICY()");
            didSucceed = true;
        }
        catch (SQLException se) {
            Changes10_3.assertSQLState(expectedSQLState, se);
        }
        Changes10_3.assertEquals((String)"Reloading results.", (boolean)shouldSucceed, (boolean)didSucceed);
    }

    private void checkNewHeap(String tableName, String value) throws SQLException {
        Statement s = this.createStatement();
        ResultSet rs = s.executeQuery("select * from " + tableName);
        JDBC.assertFullResultSet(rs, new String[][]{{value}});
        s.close();
        rs.close();
    }

    public void testNewHeap() throws SQLException {
        switch (this.getPhase()) {
            case 0: {
                Statement s = this.createStatement();
                s.execute("create table testNewHeap1(keycol char(20))");
                s.close();
                PreparedStatement insert_stmt = this.prepareStatement("insert into testNewHeap1 values(?)");
                insert_stmt.setString(1, "create");
                insert_stmt.execute();
                insert_stmt.close();
                break;
            }
            case 1: {
                Statement s = this.createStatement();
                s.execute("create table testNewHeap2(keycol char(20))");
                s.close();
                PreparedStatement insert_stmt = this.prepareStatement("insert into testNewHeap2 values(?)");
                insert_stmt.setString(1, "soft");
                insert_stmt.execute();
                insert_stmt.close();
                break;
            }
            case 3: {
                Statement s = this.createStatement();
                s.execute("create table testNewHeap3(keycol char(20))");
                s.close();
                PreparedStatement insert_stmt = this.prepareStatement("insert into testNewHeap3 values(?)");
                insert_stmt.setString(1, "hard");
                insert_stmt.execute();
                insert_stmt.close();
                break;
            }
        }
        switch (this.getPhase()) {
            case 0: {
                this.checkNewHeap("testNewHeap1", "create");
                break;
            }
            case 1: {
                this.checkNewHeap("testNewHeap1", "create");
                this.checkNewHeap("testNewHeap2", "soft");
                break;
            }
            case 2: {
                this.checkNewHeap("testNewHeap1", "create");
                this.checkNewHeap("testNewHeap2", "soft");
                break;
            }
            case 3: {
                this.checkNewHeap("testNewHeap1", "create");
                this.checkNewHeap("testNewHeap2", "soft");
                this.checkNewHeap("testNewHeap3", "hard");
            }
        }
    }
}

