/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.upgradeTests;

import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.apache.derbyTesting.functionTests.tests.upgradeTests.UpgradeChange;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.TestConfiguration;

public class BasicSetup
extends UpgradeChange {
    public static Test suite() {
        TestSuite suite = new TestSuite("Upgrade basic setup");
        suite.addTestSuite(BasicSetup.class);
        return suite;
    }

    public BasicSetup(String name) {
        super(name);
    }

    public void testOldVersion() throws SQLException {
        switch (this.getPhase()) {
            case 0: 
            case 2: {
                DatabaseMetaData dmd = this.getConnection().getMetaData();
                BasicSetup.assertEquals((String)"Old major (driver): ", (int)this.getOldMajor(), (int)dmd.getDriverMajorVersion());
                BasicSetup.assertEquals((String)"Old minor (driver): ", (int)this.getOldMinor(), (int)dmd.getDriverMinorVersion());
                BasicSetup.assertEquals((String)"Old major (database): ", (int)this.getOldMajor(), (int)dmd.getDatabaseMajorVersion());
                BasicSetup.assertEquals((String)"Old minor (database): ", (int)this.getOldMinor(), (int)dmd.getDatabaseMinorVersion());
            }
        }
    }

    public void testDML() throws SQLException {
        int i;
        int phase = this.getPhase();
        Statement s = this.createStatement();
        switch (phase) {
            case 0: {
                s.executeUpdate("CREATE TABLE PHASE(id INT NOT NULL, ok INT)");
                s.executeUpdate("CREATE TABLE TABLE1(id INT NOT NULL PRIMARY KEY, name varchar(200))");
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                break;
            }
        }
        s.close();
        PreparedStatement ps = this.prepareStatement("INSERT INTO PHASE(id) VALUES (?)");
        ps.setInt(1, phase);
        ps.executeUpdate();
        ps.close();
        ps = this.prepareStatement("INSERT INTO TABLE1 VALUES (?, ?)");
        for (i = 1; i < 20; ++i) {
            ps.setInt(1, i + phase * 100);
            ps.setString(2, "p" + phase + "i" + i);
            ps.executeUpdate();
        }
        ps.close();
        ps = this.prepareStatement("UPDATE TABLE1 set name = name || 'U'  where id = ?");
        for (i = 1; i < 20; i += 3) {
            ps.setInt(1, i + phase * 100);
            ps.executeUpdate();
        }
        ps.close();
        ps = this.prepareStatement("DELETE FROM TABLE1 where id = ?");
        for (i = 1; i < 20; i += 4) {
            ps.setInt(1, i + phase * 100);
            ps.executeUpdate();
        }
        ps.close();
        this.commit();
    }

    public void testCreateTable() throws SQLException {
        Statement stmt = this.createStatement();
        try {
            stmt.executeUpdate("DROP table t");
        }
        catch (SQLException se) {
            BasicSetup.assertSQLState("42Y55", se);
        }
        stmt.executeUpdate("CREATE TABLE T (I INT)");
        TestConfiguration.getCurrent().shutdownDatabase();
        stmt = this.createStatement();
        ResultSet rs = stmt.executeQuery("SELECT * from t");
        JDBC.assertEmpty(rs);
        rs.close();
    }

    public void testIndex() throws SQLException {
        Statement stmt = this.createStatement();
        try {
            stmt.executeUpdate("DROP table ti");
        }
        catch (SQLException se) {
            BasicSetup.assertSQLState("42Y55", se);
        }
        stmt.executeUpdate("CREATE TABLE TI (I INT primary key not null)");
        stmt.executeUpdate("INSERT INTO  TI values(1)");
        stmt.executeUpdate("INSERT INTO  TI values(2)");
        stmt.executeUpdate("INSERT INTO  TI values(3)");
        TestConfiguration.getCurrent().shutdownDatabase();
        stmt = this.createStatement();
        ResultSet rs = stmt.executeQuery("SELECT * from TI ORDER BY I");
        JDBC.assertFullResultSet(rs, new String[][]{{"1"}, {"2"}, {"3"}});
        rs.close();
    }

    public void noConnectionAfterHardUpgrade() {
        switch (this.getPhase()) {
            case 4: {
                try {
                    this.getConnection();
                    break;
                }
                catch (SQLException e) {
                    SQLException sqle = this.getLastSQLException(e);
                    String sqlState = sqle.getSQLState();
                    if (sqlState.equals("XSLAP") || sqlState.equals("XSLAN")) break;
                    BasicSetup.fail((String)"expected an error indicating no connection");
                }
            }
        }
    }
}

