/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.tools;

import com.pivotal.gemfirexd.internal.iapi.tools.run;
import java.io.IOException;
import java.net.URL;
import java.security.CodeSource;
import java.util.Vector;
import org.apache.derbyTesting.functionTests.harness.BackgroundStreamSaver;
import org.apache.derbyTesting.functionTests.harness.jvm;

public class derbyrunjartest {
    public static void main(String[] args) throws Exception {
        CodeSource cs = null;
        try {
            cs = run.class.getProtectionDomain().getCodeSource();
        }
        catch (SecurityException se) {
            System.out.println("Security exception: " + se.getMessage());
        }
        URL result = cs.getLocation();
        jvm jvm2 = null;
        String derbyrunloc = null;
        if (result.toString().endsWith(".jar")) {
            derbyrunloc = result.toString().substring(5);
            if (System.getProperty("os.name").startsWith("Windows")) {
                derbyrunloc = derbyrunloc.substring(1);
            }
            jvm2 = jvm.getJvm("currentjvm");
        }
        String[][] testCommands = new String[][]{{"ij", "--help"}, {"sysinfo", "-cp", "help"}, {"dblook"}, {"server"}};
        for (int i = 0; i < testCommands.length; ++i) {
            derbyrunjartest.runtool(jvm2, derbyrunloc, testCommands[i]);
        }
    }

    private static void runtool(jvm jvm2, String loc, String[] args) throws IOException {
        block4: {
            System.out.println(derbyrunjartest.concatenate(args) + ':');
            if (jvm2 == null) {
                run.main((String[])args);
                return;
            }
            Vector cmd = jvm2.getCommandLine();
            cmd.addElement("-jar");
            cmd.addElement(loc);
            for (int i = 0; i < args.length; ++i) {
                cmd.addElement(args[i]);
            }
            String command = derbyrunjartest.concatenate(cmd.toArray(new String[0]));
            Process pr = null;
            try {
                pr = Runtime.getRuntime().exec(command);
                BackgroundStreamSaver saver = new BackgroundStreamSaver(pr.getInputStream(), System.out);
                saver.finish();
                pr.waitFor();
                pr.destroy();
            }
            catch (Throwable t) {
                System.out.println("Process exception: " + t.getMessage());
                if (pr == null) break block4;
                pr.destroy();
                pr = null;
            }
        }
    }

    private static String concatenate(String[] args) {
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < args.length; ++i) {
            buf.append(args[i]);
            if (i + 1 >= args.length) continue;
            buf.append(' ');
        }
        return buf.toString();
    }
}

