/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.tools;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.SupportFilesSetup;
import org.apache.derbyTesting.junit.TestConfiguration;

public class ImportExportTest
extends BaseJDBCTestCase {
    public ImportExportTest(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite("ImportExportTest");
        if (JDBC.vmSupportsJSR169()) {
            return new TestSuite();
        }
        suite.addTest(ImportExportTest.baseSuite("ImportExportTest:embedded"));
        suite.addTest(TestConfiguration.clientServerDecorator(ImportExportTest.baseSuite("ImportExportTest:client")));
        return suite;
    }

    public static Test baseSuite(String name) {
        TestSuite suite = new TestSuite(ImportExportTest.class, name);
        SupportFilesSetup test = new SupportFilesSetup((Test)suite, new String[]{"functionTests/testData/ImportExport/EndOfFile.txt"});
        return new CleanDatabaseTestSetup((Test)test){

            @Override
            protected void decorateSQL(Statement s) throws SQLException {
                s.execute("create type Price external name 'org.apache.derbyTesting.functionTests.tests.lang.Price' language java");
                s.execute("create type hashmap external name 'java.util.HashMap' language java");
                s.execute("create function makePrice( ) returns price language java parameter style java no sql external name 'org.apache.derbyTesting.functionTests.tests.lang.Price.makePrice'");
                s.execute("create function makeHashMap( ) returns hashmap language java parameter style java no sql external name 'org.apache.derbyTesting.functionTests.tests.lang.UDTTest.makeHashMap'");
                s.execute("CREATE TABLE T1 (COLUMN1 VARCHAR(5) , COLUMN2 VARCHAR(8) , COLUMN3 SMALLINT , COLUMN4 CHAR(11) , COLUMN5 DATE , COLUMN6 DECIMAL(5,1) , COLUMN7 DOUBLE PRECISION , COLUMN8 INT , COLUMN9 BIGINT , COLUMN10 NUMERIC , COLUMN11 REAL , COLUMN12 SMALLINT , COLUMN13 TIME , COLUMN14 TIMESTAMP , COLUMN15 SMALLINT , COLUMN16 VARCHAR(1), COLUMN17 PRICE)");
                s.execute("CREATE TABLE T2 (COLUMN1 VARCHAR(5) , COLUMN2 VARCHAR(8) , COLUMN3 SMALLINT, COLUMN4 CHAR(11) , COLUMN5 DATE , COLUMN6 DECIMAL(5,1) , COLUMN7 DOUBLE PRECISION , COLUMN8 INT , COLUMN9 BIGINT , COLUMN10 NUMERIC , COLUMN11 REAL , COLUMN12 SMALLINT , COLUMN13 TIME , COLUMN14 TIMESTAMP , COLUMN15 SMALLINT , COLUMN16 VARCHAR(1), COLUMN17 PRICE)");
                s.execute("create table T4 (   Account int,    Fname   char(30),Lname   char(30), Company varchar(35), Address varchar(40), City    varchar(20),State   char(5), Zip     char(10), Payment decimal(8,2), Balance decimal(8,2))");
                s.execute("create table t5( a int, b price )");
                s.execute("create table t6( a int, b hashmap )");
            }
        };
    }

    public void testImportFromNonExistantFile() {
        try {
            Connection c = this.getConnection();
            this.doImport(c, "Z", "T1", null, null, null, 0);
        }
        catch (SQLException e) {
            ImportExportTest.assertSQLState("XIE04", e);
        }
    }

    public void testNullDataFile() {
        try {
            Connection c = this.getConnection();
            this.doImport(c, null, "T1", null, null, null, 0);
        }
        catch (SQLException e) {
            ImportExportTest.assertSQLState("XIE05", e);
        }
    }

    public void testEmptyTable() throws SQLException {
        Connection c = this.getConnection();
        this.doImportAndExport(c, "T1", null, null, null);
    }

    public void testEmptyTableWithDelimitedFormat() throws SQLException {
        Connection c = this.getConnection();
        this.doImportAndExport(c, "T1", null, null, "8859_1");
    }

    public void testEmptyTableWithFieldCharDelimiters() throws SQLException {
        Connection c = this.getConnection();
        this.doImportAndExport(c, "T1", "\t", "|", "8859_1");
    }

    public void testWithDefaultOptions() throws Exception {
        Connection c = this.getConnection();
        this.resetTables();
        this.doImportAndExport(c, "T1", null, null, null);
    }

    public void testWithCodeset() throws Exception {
        Connection c = this.getConnection();
        this.resetTables();
        this.doImportAndExport(c, "T1", null, null, "8859_1");
    }

    public void testDelimiterAndCodeset() throws Exception {
        Connection c = this.getConnection();
        this.resetTables();
        this.doImportAndExport(c, "T1", "\t", "|", "8859_1");
    }

    public void testSpecialDelimitersAndCodeset() throws Exception {
        Connection c = this.getConnection();
        this.resetTables();
        this.doImportAndExport(c, "T1", "%", "&", "Cp1252");
    }

    public void testSpecialDelimitersAndUTF16() throws Exception {
        Connection c = this.getConnection();
        this.resetTables();
        this.doImportAndExport(c, "T1", "%", "&", "UTF-16");
    }

    public void testInvalidEncoding() throws Exception {
        Connection c = this.getConnection();
        this.resetTables();
        try {
            this.doImportAndExport(c, "T1", "^", "#", "INAVALID ENCODING");
        }
        catch (SQLException e) {
            ImportExportTest.assertSQLState("XIE0I", e);
        }
    }

    public void testEarlyEndOfFile() throws Exception {
        Connection c = this.getConnection();
        try {
            this.doImportFromFile(c, "extin/EndOfFile.txt", "T4", null, null, null, 0);
        }
        catch (SQLException e) {
            ImportExportTest.assertSQLState("XIE0R", e);
        }
    }

    public void testCastingProblem() throws Exception {
        this.resetTables();
        String fileName = SupportFilesSetup.getReadWrite("castCheck.dat").getPath();
        this.doExportToFile(fileName, null, "T6", null, null, null);
        try {
            this.doImportFromFile(this.getConnection(), fileName, "T5", null, null, null, 0);
            ImportExportTest.fail();
        }
        catch (SQLException e) {
            ImportExportTest.assertSQLState("XIE0R", e);
        }
    }

    private void doImport(Connection c, String fromTable, String toTable, String colDel, String charDel, String codeset, int replace) throws SQLException {
        String impsql = "call SYSCS_UTIL.IMPORT_TABLE (? , ? , ? , ?, ? , ?, ?)";
        PreparedStatement ps = c.prepareStatement(impsql);
        ps.setString(1, "APP");
        ps.setString(2, toTable);
        ps.setString(3, fromTable == null ? fromTable : "extinout/" + fromTable + ".dat");
        ps.setString(4, colDel);
        ps.setString(5, charDel);
        ps.setString(6, codeset);
        ps.setInt(7, replace);
        ps.execute();
        ps.close();
    }

    private void doImportFromFile(Connection c, String fileName, String toTable, String colDel, String charDel, String codeset, int replace) throws Exception {
        String impsql = "call SYSCS_UTIL.IMPORT_TABLE (? , ? , ? , ?, ? , ?, ?)";
        PreparedStatement ps = c.prepareStatement(impsql);
        ps.setString(1, "APP");
        ps.setString(2, toTable);
        ps.setString(3, fileName);
        ps.setString(4, colDel);
        ps.setString(5, charDel);
        ps.setString(6, codeset);
        ps.setInt(7, replace);
        ps.execute();
        ps.close();
    }

    private void doImportAndExport(Connection c, String fromTable, String colDel, String charDel, String codeset) throws SQLException {
        this.doExport(c, fromTable, colDel, charDel, codeset);
        this.doImportAndVerify(c, fromTable, colDel, charDel, codeset, 0);
    }

    private void doExport(Connection c, String fromTable, String colDel, String charDel, String codeset) throws SQLException {
        SupportFilesSetup.deleteFile("extinout/" + fromTable + ".dat");
        String expsql = "call SYSCS_UTIL.EXPORT_TABLE (? , ? , ? , ?, ? , ?)";
        PreparedStatement ps = c.prepareStatement(expsql);
        ps.setString(1, "APP");
        ps.setString(2, fromTable);
        ps.setString(3, fromTable == null ? fromTable : "extinout/" + fromTable + ".dat");
        ps.setString(4, colDel);
        ps.setString(5, charDel);
        ps.setString(6, codeset);
        ps.execute();
        ps.close();
    }

    private void doExportToFile(String fileName, String fromSchema, String fromTable, String colDel, String charDel, String codeset) throws SQLException {
        if (fileName != null) {
            SupportFilesSetup.deleteFile(fileName);
        }
        String expsql = "call SYSCS_UTIL.EXPORT_TABLE (? , ? , ? , ?, ? , ?)";
        PreparedStatement ps = this.prepareStatement(expsql);
        ps.setString(1, fromSchema);
        ps.setString(2, fromTable);
        ps.setString(3, fileName);
        ps.setString(4, colDel);
        ps.setString(5, charDel);
        ps.setString(6, codeset);
        ps.execute();
        ps.close();
    }

    private void doImportAndVerify(Connection c, String fromTable, String colDel, String charDel, String codeset, int replace) throws SQLException {
        this.doImport(c, fromTable, "T2", colDel, charDel, codeset, replace);
        Statement stmt = c.createStatement();
        ResultSet rs1 = stmt.executeQuery("SELECT * FROM " + fromTable);
        Statement stmt2 = c.createStatement();
        ResultSet rs2 = stmt2.executeQuery("SELECT * FROM t2");
        ImportExportTest.assertTrue((!rs1.isClosed() ? 1 : 0) != 0);
        ImportExportTest.assertTrue((!rs2.isClosed() ? 1 : 0) != 0);
        JDBC.assertSameContents(rs1, rs2);
    }

    private void resetTables() throws Exception {
        this.runSQLCommands("delete from t1");
        this.runSQLCommands("delete from t2");
        this.runSQLCommands("delete from t5");
        this.runSQLCommands("delete from t6");
        this.runSQLCommands("INSERT INTO T1 VALUES (null,'aa',1,'a',DATE('1998-06-30'),1,1,1,1,1,1,1,TIME('12:00:00'),TIMESTAMP('1998-06-30 12:00:00.0'),1,'a', makePrice() )");
        this.runSQLCommands("INSERT INTO T1 VALUES (null,'bb',1,'b',DATE('1998-06-30'),2,2,2,2,2,2,2,TIME('12:00:00'),TIMESTAMP('1998-06-30 12:00:00.0'),2,'b', makePrice() )");
        this.runSQLCommands("INSERT INTO T1 VALUES (null,'cc',1,'c',DATE('1998-06-30'),3,3,3,3,3,3,3,TIME('12:00:00'),TIMESTAMP('1998-06-30 12:00:00.0'),3,'c', makePrice())");
        this.runSQLCommands("INSERT INTO T1 VALUES (null,'dd',1,'d',DATE('1998-06-30'),4,4,4,4,4,4,4,TIME('12:00:00'),TIMESTAMP('1998-06-30 12:00:00.0'),4,'d', makePrice())");
        this.runSQLCommands("insert into t6 values( 1, makeHashMap() )");
    }
}

