/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.tools;

import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.apache.derbyTesting.functionTests.tests.tools.ImportExportBaseTest;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.SupportFilesSetup;
import org.apache.derbyTesting.junit.TestConfiguration;

public class ImportExportBinaryDataTest
extends ImportExportBaseTest {
    String fileName = SupportFilesSetup.getReadWrite("bin_tab.del").getPath();

    public ImportExportBinaryDataTest(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(ImportExportBinaryDataTest.class);
        suite.addTest(TestConfiguration.clientServerSuite(ImportExportBinaryDataTest.class));
        Object test = suite;
        test = new SupportFilesSetup((Test)test);
        return new CleanDatabaseTestSetup((Test)test){

            @Override
            protected void decorateSQL(Statement s) throws SQLException {
                s.execute("CREATE TABLE BIN_TAB (id int,C_BD CHAR(4) FOR BIT DATA,C_VBD VARCHAR(10) FOR BIT DATA, C_LVBD LONG VARCHAR FOR BIT DATA)");
                ImportExportBinaryDataTest.loadData(s);
                s.execute("CREATE TABLE BIN_TAB_IMP(id int,C_BD CHAR(4) FOR BIT DATA,C_VBD VARCHAR(10) FOR BIT DATA, C_LVBD LONG VARCHAR FOR BIT DATA)");
                s.execute("CREATE TABLE hex_tab(id int,C1 varchar(20),C2 varchar(20),C3 varchar(20))");
                s.execute("create table derby_2925_tab(a varchar( 50 ),b varchar( 50 ))");
            }
        };
    }

    protected void setUp() throws SQLException {
        Statement s = this.createStatement();
        s.executeUpdate("DELETE FROM BIN_TAB_IMP");
        s.close();
    }

    @Override
    protected void tearDown() throws Exception {
        SupportFilesSetup.deleteFile(this.fileName);
        super.tearDown();
    }

    public void testImportTableExportTable() throws SQLException, IOException {
        this.doExportTable("APP", "BIN_TAB", this.fileName, null, null, null);
        this.doImportTable("APP", "BIN_TAB_IMP", this.fileName, null, null, null, 0);
        this.verifyData(" * ");
    }

    public void testImportDataExportQuery() throws SQLException, IOException {
        this.doExportQuery("select * from BIN_TAB", this.fileName, null, null, null);
        this.doImportData(null, "BIN_TAB_IMP", null, null, this.fileName, null, null, null, 0);
        this.verifyData(" * ");
        this.doImportData(null, "BIN_TAB_IMP", "C_LVBD, C_VBD, C_BD, ID", "4, 3, 2, 1", this.fileName, null, null, null, 1);
        this.verifyData("C_LVBD, C_VBD, C_BD, ID");
        SupportFilesSetup.deleteFile(this.fileName);
        this.doExportQuery("select * from BIN_TAB", this.fileName, ";", "%", null);
        this.doImportData(null, "BIN_TAB_IMP", null, null, this.fileName, ";", "%", null, 1);
    }

    public void testImportDataExportQueryWithFewColumns() throws SQLException, IOException {
        this.doExportQuery("select id, c_bd, c_vbd, c_lvbd from BIN_TAB", this.fileName, null, null, null);
        this.doImportData(null, "BIN_TAB_IMP", "ID,C_LVBD", "1 , 4", this.fileName, null, null, null, 0);
        this.verifyData("ID,C_LVBD");
        this.doImportData(null, "BIN_TAB_IMP", "ID, C_LVBD, C_BD", "1, 4, 2", this.fileName, null, null, null, 1);
        this.verifyData("ID, C_LVBD, C_BD");
        this.doImportData(null, "BIN_TAB_IMP", "ID, C_VBD, C_BD", "1, 3, 2", this.fileName, null, null, null, 1);
        this.verifyData("ID, C_VBD, C_BD");
        SupportFilesSetup.deleteFile(this.fileName);
        this.doExportQuery("select id, c_bd, c_vbd, c_lvbd from BIN_TAB", this.fileName, "$", "!", null);
        this.doImportData(null, "BIN_TAB_IMP", "ID,C_LVBD", "1 , 4", this.fileName, "$", "!", null, 0);
    }

    public void testImportExportInvalideDelimiters() throws SQLException, IOException {
        try {
            this.doExportTable("APP", "BIN_TAB", this.fileName, null, "9", null);
        }
        catch (SQLException e) {
            ImportExportBinaryDataTest.assertSQLState("XIE0J", e);
        }
        SupportFilesSetup.deleteFile(this.fileName);
        try {
            this.doExportQuery("select * from BIN_TAB", this.fileName, "|", "f", null);
        }
        catch (SQLException e) {
            ImportExportBinaryDataTest.assertSQLState("XIE0J", e);
        }
        SupportFilesSetup.deleteFile(this.fileName);
        try {
            this.doExportTable("APP", "BIN_TAB", this.fileName, "B", null, null);
        }
        catch (SQLException e) {
            ImportExportBinaryDataTest.assertSQLState("XIE0J", e);
        }
        SupportFilesSetup.deleteFile(this.fileName);
        this.doExportTable("APP", "BIN_TAB", this.fileName, null, null, null);
        try {
            this.doImportTable("APP", "BIN_TAB_IMP", this.fileName, "2", null, null, 0);
        }
        catch (SQLException e) {
            ImportExportBinaryDataTest.assertSQLState("XIE0J", e);
        }
        try {
            this.doImportData(null, "BIN_TAB_IMP", null, null, this.fileName, null, "c", null, 1);
        }
        catch (SQLException e) {
            ImportExportBinaryDataTest.assertSQLState("XIE0J", e);
        }
    }

    public void testImportWitgInvalidHexStrings() throws SQLException {
        Statement s = this.createStatement();
        s.executeUpdate("insert into hex_tab values(1, 'A121', '3122A1F20B', 'B1C201DA')");
        s.executeUpdate("insert into hex_tab values(2, 'A121', '3122A1F20B', 'B1C201A')");
        s.executeUpdate("insert into hex_tab values(3, '', '3122A1F20Z', 'B1C201DA')");
        s.executeUpdate("insert into hex_tab values(3, 'A1\"21', '3122A1F20Z', 'B1C201DA')");
        s.close();
        this.doExportTable("APP", "HEX_TAB", this.fileName, null, null, null);
        try {
            this.doImportTable("APP", "BIN_TAB_IMP", this.fileName, null, null, null, 0);
            ImportExportBinaryDataTest.fail((String)"import did not fail on data with invalid hex string");
        }
        catch (SQLException e) {
            ImportExportBinaryDataTest.assertSQLState("XIE0N", e);
        }
        try {
            this.doImportData(null, "BIN_TAB_IMP", "ID, C_VBD", "1,3", this.fileName, null, null, null, 1);
            ImportExportBinaryDataTest.fail((String)"import did not fail on data with invalid hex strings");
        }
        catch (SQLException e) {
            ImportExportBinaryDataTest.assertSQLState("XIE0N", e);
        }
        try {
            this.doImportData(null, "BIN_TAB_IMP", "ID, C_VBD", "1,2", this.fileName, null, null, null, 1);
            ImportExportBinaryDataTest.fail((String)"import did not fail on data with invalid hex strings");
        }
        catch (SQLException e) {
            ImportExportBinaryDataTest.assertSQLState("XIE0N", e);
        }
    }

    public void testDerby2925ExportTable() throws SQLException {
        this.doExportTable("APP", "DERBY_2925_TAB", this.fileName, null, null, null);
        try {
            this.doExportTable("APP", "DERBY_2925_TAB", this.fileName, null, null, null);
            ImportExportBinaryDataTest.fail((String)"export should have failed on existing data file.");
        }
        catch (SQLException e) {
            ImportExportBinaryDataTest.assertSQLState("XIE0S", e);
        }
    }

    public void testDerby2925ExportQuery() throws SQLException {
        this.doExportQuery("select * from DERBY_2925_TAB", this.fileName, null, null, null);
        try {
            this.doExportQuery("select * from DERBY_2925_TAB", this.fileName, null, null, null);
            ImportExportBinaryDataTest.fail((String)"exportQuery should have failed on existing data file.");
        }
        catch (SQLException e) {
            ImportExportBinaryDataTest.assertSQLState("XIE0S", e);
        }
    }

    private void verifyData(String cols) throws SQLException, IOException {
        Statement s1 = this.createStatement();
        ResultSet rsExport = s1.executeQuery("SELECT " + cols + " FROM BIN_TAB order by id");
        Statement s2 = this.createStatement();
        ResultSet rsImport = s2.executeQuery("SELECT " + cols + " FROM BIN_TAB_IMP order by id");
        JDBC.assertSameContents(rsExport, rsImport);
        s1.close();
        s2.close();
    }

    private static void loadData(Statement s) throws SQLException {
        s.executeUpdate("insert into bin_tab values (1, X'31', X'3241510B',  X'3743640ADE12337610')");
        s.executeUpdate("insert into bin_tab values (2, X'33', X'3341610B',  X'3843640ADE12337610')");
        s.executeUpdate("insert into bin_tab values (4, X'41', X'42',  X'')");
        s.executeUpdate("insert into bin_tab values (5, X'41', X'', X'42')");
        s.executeUpdate("insert into bin_tab values (6, X'', X'42',  X'3233445578990122558820')");
        s.executeUpdate("insert into bin_tab values (7, null, X'3341610B',  X'3843640ADE12337610')");
        s.executeUpdate("insert into bin_tab values (8,  X'3341610B', null,  X'3843640ADE12337610')");
        s.executeUpdate("insert into bin_tab values (9,  X'3341610B',  X'3843640ADE' , null)");
        s.executeUpdate("insert into bin_tab values (10, X'', null,  X'3843640ADE12')");
        s.executeUpdate("insert into bin_tab values (11, X'66', null,  X'')");
        s.executeUpdate("insert into bin_tab values (12, X'2C313B09', X'224122',  X'222C23B90A')");
        s.executeUpdate("insert into bin_tab values (13, X'212C3B24', X'2422412221',   X'212421222C23B90A2124')");
    }
}

