/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.store;

import com.pivotal.gemfirexd.internal.tools.ij;
import java.io.ByteArrayInputStream;
import java.io.CharArrayReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.derbyTesting.functionTests.util.Formatters;
import org.apache.derbyTesting.functionTests.util.TestUtil;

public class streamingColumn {
    static String[] fileName;
    static long[] fileLength;
    private static final int LONGVARCHAR = 1;
    private static final int CLOB = 2;
    private static final int VARCHAR = 3;

    public static void main(String[] args) {
        System.out.println("Test streamingColumn starting");
        try {
            ij.getPropertyArg((String[])args);
            Connection conn = ij.startJBMS();
            streamingColumn.streamTest1(conn);
            streamingColumn.streamTest2(conn, 1500L);
            streamingColumn.streamTest2(conn, 5000L);
            streamingColumn.streamTest2(conn, 10000L);
            streamingColumn.streamTest3(conn, 0L);
            streamingColumn.streamTest3(conn, 1500L);
            streamingColumn.streamTest3(conn, 5000L);
            streamingColumn.streamTest3(conn, 10000L);
            streamingColumn.streamTest4(conn);
            streamingColumn.streamTest5(conn, 0L);
            streamingColumn.streamTest5(conn, 1500L);
            streamingColumn.streamTest5(conn, 5000L);
            streamingColumn.streamTest6(conn, 5000L);
            streamingColumn.streamTest7(conn);
            streamingColumn.streamTest8(conn, 10, 2500);
            streamingColumn.streamTest9(conn, 10, 2500);
            streamingColumn.streamTest8(conn, 2500, 10);
            streamingColumn.streamTest9(conn, 2500, 10);
            streamingColumn.streamTest10(conn);
            streamingColumn.streamTest11(conn);
            streamingColumn.streamTest12(conn);
            streamingColumn.streamTest13(conn);
            streamingColumn.streamTest14(conn);
            streamingColumn.derby500Test(conn);
            streamingColumn.derby500_verifyVarcharStreams(conn);
            conn.setAutoCommit(true);
            conn.close();
        }
        catch (SQLException e) {
            streamingColumn.dumpSQLExceptions(e);
        }
        catch (Throwable e) {
            System.out.println("FAIL -- unexpected exception:" + e.toString());
        }
        System.out.println("Test streamingColumn finished");
    }

    private static void streamTest1(Connection conn) {
        try {
            String resultString;
            InputStream fin;
            Statement stmt = conn.createStatement();
            stmt.execute("create table testLongVarChar (a int, b long varchar)");
            stmt.execute("insert into testLongVarChar values(1, '')");
            stmt.execute("insert into testLongVarChar values(2, 'test data: a string column inserted as an object')");
            for (int i = 0; i < fileName.length; ++i) {
                File file = new File(fileName[i]);
                streamingColumn.fileLength[i] = file.length();
                FileInputStream fileIn = new FileInputStream(file);
                System.out.println("===> testing " + fileName[i] + " length = " + fileLength[i]);
                PreparedStatement ps = conn.prepareStatement("insert into testLongVarChar values(?, ?)");
                ps.setInt(1, 100 + i);
                ps.setAsciiStream(2, (InputStream)fileIn, (int)fileLength[i]);
                try {
                    ps.executeUpdate();
                    System.out.println("No truncation and hence no error");
                }
                catch (SQLException e) {
                    if (fileLength[i] > 32700L && e.getSQLState().equals("22001")) {
                        System.out.println("expected exception for data > 32700 in length");
                    }
                    streamingColumn.dumpSQLExceptions(e);
                }
                ((InputStream)fileIn).close();
            }
            ResultSet rs = stmt.executeQuery("select a, b from testLongVarChar");
            ResultSetMetaData met = rs.getMetaData();
            byte[] buff = new byte[128];
            while (rs.next()) {
                int size;
                int a = rs.getInt("a");
                fin = rs.getAsciiStream(2);
                int columnSize = 0;
                while ((size = fin.read(buff)) != -1) {
                    columnSize += size;
                }
                streamingColumn.verifyLength(a, columnSize, fileLength);
            }
            rs = stmt.executeQuery("select a, b from testLongVarChar order by a");
            met = rs.getMetaData();
            while (rs.next()) {
                int size;
                int a = rs.getInt("a");
                fin = rs.getAsciiStream(2);
                int columnSize = 0;
                while ((size = fin.read(buff)) != -1) {
                    columnSize += size;
                }
                streamingColumn.verifyLength(a, columnSize, fileLength);
            }
            rs = stmt.executeQuery("select a, b from testLongVarChar");
            while (rs.next()) {
                int a = rs.getInt("a");
                resultString = rs.getString(2);
                streamingColumn.verifyLength(a, resultString.length(), fileLength);
            }
            rs = stmt.executeQuery("select a, b from testLongVarChar order by a");
            while (rs.next()) {
                int a = rs.getInt("a");
                resultString = rs.getString(2);
                streamingColumn.verifyLength(a, resultString.length(), fileLength);
            }
            rs = stmt.executeQuery("select a, b from testLongVarChar where b like 'test data: a string column inserted as an object'");
            while (rs.next()) {
                int a = rs.getInt("a");
                resultString = rs.getString(2);
                streamingColumn.verifyLength(a, resultString.length(), fileLength);
            }
            stmt.executeUpdate("call SYSCS_UTIL.SET_DATABASE_PROPERTY('gemfirexd.storage.pageSize', '1024')");
            stmt.executeUpdate("create table foo (a int not null, b long varchar, primary key (a))");
            stmt.executeUpdate("call SYSCS_UTIL.SET_DATABASE_PROPERTY('gemfirexd.storage.pageSize', NULL)");
            streamingColumn.insertLongString(conn, 10, "ssssssssss", false);
            streamingColumn.insertLongString(conn, 0, "", false);
            streamingColumn.insertLongString(conn, 1, "1", false);
            streamingColumn.insertLongString(conn, -1, null, false);
            streamingColumn.insertLongString(conn, 20, "XXXXXXXXXXXXXXXXXXXX", false);
            rs = stmt.executeQuery("select a, b from foo");
            System.out.println("expect to get null string back");
            while (rs.next()) {
                int a = rs.getInt("a");
                resultString = rs.getString(2);
                if (resultString == null) {
                    System.out.println("a = " + a + " got null string back");
                    continue;
                }
                if (resultString.length() == a) continue;
                System.out.println("FAIL - failed to get string back, expect " + a + " got " + resultString.length());
            }
            streamingColumn.updateLongString(conn, 1, 3000);
            streamingColumn.updateLongString(conn, 0, 800);
            streamingColumn.updateLongString(conn, 3000, 0);
            streamingColumn.updateLongString(conn, 0, 51);
            streamingColumn.updateLongString(conn, 20, 0);
            rs = stmt.executeQuery("select a, b from foo");
            while (rs.next()) {
                int a = rs.getInt("a");
                resultString = rs.getString(2);
                if (resultString == null) {
                    System.out.println("a = " + a + " got null string back");
                    continue;
                }
                if (resultString.length() == a) continue;
                System.out.println("FAIL - failed to get string back, expect " + a + " got " + resultString.length() + " " + resultString);
            }
            stmt.executeUpdate("drop table foo");
            rs.close();
            stmt.close();
        }
        catch (SQLException e) {
            streamingColumn.dumpSQLExceptions(e);
        }
        catch (Throwable e) {
            System.out.println("FAIL -- unexpected exception:" + e.toString());
        }
    }

    static void streamTest2(Connection conn, long length) throws Exception {
        Statement sourceStmt = conn.createStatement();
        sourceStmt.executeUpdate("create table foo (a int not null, b long varchar, primary key (a))");
        streamingColumn.insertLongString(conn, 1, streamingColumn.pad("Broadway", length), false);
        streamingColumn.insertLongString(conn, 2, streamingColumn.pad("Franklin", length), false);
        streamingColumn.insertLongString(conn, 3, streamingColumn.pad("Webster", length), false);
        sourceStmt.executeUpdate("insert into foo select a+100, b from foo");
        streamingColumn.verifyExistence(conn, 1, "Broadway", length);
        streamingColumn.verifyExistence(conn, 2, "Franklin", length);
        streamingColumn.verifyExistence(conn, 3, "Webster", length);
        streamingColumn.verifyExistence(conn, 101, "Broadway", length);
        streamingColumn.verifyExistence(conn, 102, "Franklin", length);
        streamingColumn.verifyExistence(conn, 103, "Webster", length);
        sourceStmt.executeUpdate("drop table foo");
    }

    static void streamTest3(Connection conn, long length) throws Exception {
        Statement sourceStmt = conn.createStatement();
        sourceStmt.executeUpdate("create table foo (a int not null constraint pk primary key, b long varchar)");
        streamingColumn.insertLongString(conn, 1, streamingColumn.pad("Broadway", length), false);
        streamingColumn.insertLongString(conn, 2, streamingColumn.pad("Franklin", length), false);
        streamingColumn.insertLongString(conn, 3, streamingColumn.pad("Webster", length), false);
        PreparedStatement ps = conn.prepareStatement("update foo set a=a+1000, b=? where a<99 and a in (select a from foo)");
        File file = new File("extin/short.data");
        FileInputStream fileIn = new FileInputStream(file);
        ps.setAsciiStream(1, (InputStream)fileIn, (int)file.length());
        ps.executeUpdate();
        ((InputStream)fileIn).close();
        ps = conn.prepareStatement("update foo set a=a+1000, b=? where a<99 and a in (select a from foo)");
        file = new File("extin/shortbanner");
        fileIn = new FileInputStream(file);
        ps.setAsciiStream(1, (InputStream)fileIn, (int)file.length());
        ps.executeUpdate();
        ((InputStream)fileIn).close();
        sourceStmt.executeUpdate("drop table foo");
    }

    private static void streamTest4(Connection conn) {
        try {
            String string;
            int size;
            InputStream fin;
            Statement stmt = conn.createStatement();
            stmt.execute("create table testLongVarBinary (a int, b BLOB(1G))");
            stmt.execute("insert into testLongVarBinary values(1, CAST (" + TestUtil.stringToHexLiteral("") + "AS BLOB(1G)))");
            stmt.execute("insert into testLongVarBinary values(2,CAST (" + TestUtil.stringToHexLiteral("test data: a string column inserted as an object") + "AS BLOB(1G)))");
            for (int i = 0; i < fileName.length; ++i) {
                File file = new File(fileName[i]);
                streamingColumn.fileLength[i] = file.length();
                FileInputStream fileIn = new FileInputStream(file);
                System.out.println("===> testing " + fileName[i] + " length = " + fileLength[i]);
                PreparedStatement ps = conn.prepareStatement("insert into testLongVarBinary values(?, ?)");
                ps.setInt(1, 100 + i);
                ps.setBinaryStream(2, (InputStream)fileIn, (int)fileLength[i]);
                ps.executeUpdate();
                ((InputStream)fileIn).close();
            }
            ResultSet rs = stmt.executeQuery("select a, b from testLongVarBinary");
            ResultSetMetaData met = rs.getMetaData();
            byte[] buff = new byte[128];
            while (rs.next()) {
                int a = rs.getInt("a");
                fin = rs.getBinaryStream(2);
                int columnSize = 0;
                while ((size = fin.read(buff, 0, 100)) != -1) {
                    columnSize += size;
                }
            }
            rs = stmt.executeQuery("select a, b from testLongVarBinary order by a");
            met = rs.getMetaData();
            while (rs.next()) {
                int a = rs.getInt("a");
                fin = rs.getBinaryStream(2);
                int columnSize = 0;
                while ((size = fin.read(buff)) != -1) {
                    columnSize += size;
                }
            }
            rs = stmt.executeQuery("select a, b from testLongVarBinary");
            while (rs.next()) {
                int a = rs.getInt("a");
                string = rs.getString(2);
            }
            rs = stmt.executeQuery("select a, b from testLongVarBinary order by a");
            while (rs.next()) {
                int a = rs.getInt("a");
                string = rs.getString(2);
            }
            rs.close();
            stmt.close();
        }
        catch (SQLException e) {
            streamingColumn.dumpSQLExceptions(e);
        }
        catch (Throwable e) {
            System.out.println("FAIL -- unexpected exception:" + e.toString());
        }
    }

    static void streamTest5(Connection conn, long length) throws Exception {
        Statement sourceStmt = conn.createStatement();
        String binaryType = length > 32700L ? "BLOB(1G)" : "long varchar for bit data";
        sourceStmt.executeUpdate("create table foo (a int not null constraint pk primary key, b " + binaryType + " )");
        streamingColumn.insertLongString(conn, 1, streamingColumn.pad("Broadway", length), true);
        streamingColumn.insertLongString(conn, 2, streamingColumn.pad("Franklin", length), true);
        streamingColumn.insertLongString(conn, 3, streamingColumn.pad("Webster", length), true);
        streamingColumn.insertLongString(conn, 4, streamingColumn.pad("Broadway", length), true);
        streamingColumn.insertLongString(conn, 5, streamingColumn.pad("Franklin", length), true);
        streamingColumn.insertLongString(conn, 6, streamingColumn.pad("Webster", length), true);
        PreparedStatement ps = conn.prepareStatement("update foo set a=a+1000, b=? where a<99 and a in (select a from foo)");
        File file = new File("extin/short.data");
        FileInputStream fileIn = new FileInputStream(file);
        ps.setBinaryStream(1, (InputStream)fileIn, (int)file.length());
        ps.executeUpdate();
        ((InputStream)fileIn).close();
        ps = conn.prepareStatement("update foo set a=a+1000, b=? where a<99 and a in (select a from foo)");
        file = new File("extin/shortbanner");
        fileIn = new FileInputStream(file);
        ps.setBinaryStream(1, (InputStream)fileIn, (int)file.length());
        ps.executeUpdate();
        ps.close();
        ((InputStream)fileIn).close();
        sourceStmt.executeUpdate("drop table foo");
    }

    static void streamTest6(Connection conn, long length) throws Exception {
        Statement sourceStmt = conn.createStatement();
        sourceStmt.executeUpdate("create table foo (a int not null constraint pk primary key, b long varchar)");
        streamingColumn.insertLongString(conn, 1, streamingColumn.pad("Broadway", length), false);
        streamingColumn.insertLongString(conn, 2, streamingColumn.pad("Franklin", length), false);
        streamingColumn.insertLongString(conn, 3, streamingColumn.pad("Webster", length), false);
        PreparedStatement ps = conn.prepareStatement("update foo set a=a+1000, b=? where a<99 and a in (select a from foo)");
        streamingColumn.streamInLongCol(ps, streamingColumn.pad("Grand", length));
        ps.close();
        sourceStmt.close();
    }

    static void streamTest7(Connection conn) throws Exception {
        conn.setAutoCommit(false);
        System.out.println("streamTest7");
        Statement s = conn.createStatement();
        s.executeUpdate("call SYSCS_UTIL.SET_DATABASE_PROPERTY('gemfirexd.storage.pageSize', '1024')");
        s.execute("create table testlvc (a int, b char(100), lvc long varchar, d char(100))");
        s.executeUpdate("call SYSCS_UTIL.SET_DATABASE_PROPERTY('gemfirexd.storage.pageSize', NULL)");
        s.close();
        conn.commit();
        PreparedStatement ps1 = conn.prepareStatement("insert into testlvc values (?, 'filler for column b on null column', null, 'filler for column d')");
        PreparedStatement ps2 = conn.prepareStatement("insert into testlvc values (?, 'filler for column b on empty string column', ?, 'filler2 for column d')");
        for (int i = 0; i < 100; ++i) {
            ps1.setInt(1, i);
            ps1.executeUpdate();
            ByteArrayInputStream emptyString = new ByteArrayInputStream(new byte[0]);
            ps2.setInt(1, i);
            ps2.setAsciiStream(2, (InputStream)emptyString, 0);
            ps2.executeUpdate();
        }
        ps1.close();
        ps2.close();
        conn.commit();
        PreparedStatement ps = conn.prepareStatement("update testlvc set lvc = ? where a = ?");
        String longString = "this is a relatively long string, hopefully the row will be split or otherwise become long ???  I don't think it will become long but maybe if it rolls back it will become strange";
        for (int i = 0; i < 100; ++i) {
            ByteArrayInputStream string1 = new ByteArrayInputStream(longString.getBytes("US-ASCII"));
            ps.setAsciiStream(1, (InputStream)string1, longString.length());
            ps.setInt(2, i);
            ps.executeUpdate();
            if (i % 2 == 0) {
                conn.rollback();
            } else {
                conn.commit();
            }
            ByteArrayInputStream emptyString = new ByteArrayInputStream(new byte[0]);
            ps.setAsciiStream(1, (InputStream)emptyString, 0);
            ps.executeUpdate();
            if (i % 3 == 0) {
                conn.rollback();
                continue;
            }
            conn.commit();
        }
        ps.close();
    }

    static void streamTest8(Connection conn, int stream1_len, int stream2_len) {
        System.out.println("Starting streamTest8(conn, " + stream1_len + ", " + stream2_len + ")");
        String creatgfxd = new String("create table t8(a int, b long varchar, c long varchar)");
        String insertsql = new String("insert into t8 values (?, ?, ?) ");
        int numStrings = 10;
        byte[][] stream1_byte_array = new byte[numStrings][];
        byte[][] stream2_byte_array = new byte[numStrings][];
        for (int i = 0; i < numStrings; ++i) {
            int j;
            stream1_byte_array[i] = new byte[stream1_len];
            for (j = 0; j < stream1_len; ++j) {
                stream1_byte_array[i][j] = (byte)(97 + i);
            }
            stream2_byte_array[i] = new byte[stream2_len];
            for (j = 0; j < stream2_len; ++j) {
                stream2_byte_array[i][j] = (byte)(65 + i);
            }
        }
        try {
            conn.setAutoCommit(false);
            Statement stmt = conn.createStatement();
            stmt.execute(creatgfxd);
            conn.commit();
            PreparedStatement insert_ps = conn.prepareStatement(insertsql);
            for (int i = 0; i < numStrings; ++i) {
                insert_ps.setInt(1, i);
                insert_ps.setAsciiStream(2, (InputStream)new ByteArrayInputStream(stream1_byte_array[i]), stream1_len);
                insert_ps.setAsciiStream(3, (InputStream)new ByteArrayInputStream(stream2_byte_array[i]), stream2_len);
                insert_ps.executeUpdate();
                String checkSQL = "insert into t8 select * from t8 where a = -6363";
                stmt.execute(checkSQL);
            }
            insert_ps.close();
            conn.commit();
            ResultSet rs = stmt.executeQuery("select a, b, c from t8");
            while (rs.next()) {
                String resultString;
                int a = rs.getInt("a");
                String canon = new String(stream1_byte_array[a], "US-ASCII");
                if (canon.compareTo(resultString = rs.getString(2)) != 0) {
                    System.out.println("FAIL -- bad result string:canon: " + canon + "resultString: " + resultString);
                }
                if ((canon = new String(stream2_byte_array[a], "US-ASCII")).compareTo(resultString = rs.getString(3)) == 0) continue;
                System.out.println("FAIL -- bad result string:canon: " + canon + "resultString: " + resultString);
            }
            rs.close();
            stmt.execute("insert into t8 select * from t8");
            stmt.executeUpdate("drop table t8");
            stmt.close();
            conn.commit();
        }
        catch (SQLException e) {
            streamingColumn.dumpSQLExceptions(e);
        }
        catch (Throwable e) {
            System.out.println("FAIL -- unexpected exception:" + e.toString());
        }
        System.out.println("Finishing streamTest8(conn, " + stream1_len + ", " + stream2_len + ")");
    }

    static void streamTest9(Connection conn, int stream1_len, int stream2_len) {
        System.out.println("Starting streamTest9(conn, " + stream1_len + ", " + stream2_len + ")");
        String creatgfxd = new String("create table t9(a int, b long varchar for bit data, c long varchar for bit data)");
        String insertsql = new String("insert into t9 values (?, ?, ?) ");
        int numStrings = 10;
        byte[][] stream1_byte_array = new byte[numStrings][];
        byte[][] stream2_byte_array = new byte[numStrings][];
        for (int i = 0; i < numStrings; ++i) {
            int j;
            stream1_byte_array[i] = new byte[stream1_len];
            for (j = 0; j < stream1_len; ++j) {
                stream1_byte_array[i][j] = (byte)(97 + i);
            }
            stream2_byte_array[i] = new byte[stream2_len];
            for (j = 0; j < stream2_len; ++j) {
                stream2_byte_array[i][j] = (byte)(65 + i);
            }
        }
        try {
            conn.setAutoCommit(false);
            Statement stmt = conn.createStatement();
            stmt.execute(creatgfxd);
            conn.commit();
            PreparedStatement insert_ps = conn.prepareStatement(insertsql);
            for (int i = 0; i < numStrings; ++i) {
                insert_ps.setInt(1, i);
                insert_ps.setBinaryStream(2, (InputStream)new ByteArrayInputStream(stream1_byte_array[i]), stream1_len);
                insert_ps.setBinaryStream(3, (InputStream)new ByteArrayInputStream(stream2_byte_array[i]), stream2_len);
                insert_ps.executeUpdate();
                String checkSQL = "insert into t9 select * from t9 where a = -6363";
                stmt.execute(checkSQL);
            }
            insert_ps.close();
            conn.commit();
            ResultSet rs = stmt.executeQuery("select a, b, c from t9");
            while (rs.next()) {
                byte[] resultString;
                int a = rs.getInt("a");
                byte[] canon = stream1_byte_array[a];
                if (!streamingColumn.byteArrayEquals(canon, 0, canon.length, resultString = rs.getBytes(2), 0, resultString.length)) {
                    System.out.println("FAIL -- bad result byte array 1:canon: " + canon + "resultString: " + resultString);
                }
                if (streamingColumn.byteArrayEquals(canon = stream2_byte_array[a], 0, canon.length, resultString = rs.getBytes(3), 0, resultString.length)) continue;
                System.out.println("FAIL -- bad result byte array 2:canon: " + canon + "resultString: " + resultString);
            }
            rs.close();
            stmt.execute("insert into t9 select * from t9");
            stmt.executeUpdate("drop table t9");
            stmt.close();
            conn.commit();
        }
        catch (SQLException e) {
            streamingColumn.dumpSQLExceptions(e);
        }
        catch (Throwable e) {
            System.out.println("FAIL -- unexpected exception:" + e.toString());
        }
        System.out.println("Finishing streamTest9(conn, " + stream1_len + ", " + stream2_len + ")");
    }

    private static void streamTest10(Connection conn) {
        System.out.println("Testing 10 starts from here");
        try {
            Statement stmt = conn.createStatement();
            stmt.executeUpdate("call SYSCS_UTIL.SET_DATABASE_PROPERTY('gemfirexd.storage.pageSize', '1024')");
            stmt.execute("create table tab10 (a int, b int, c long   varchar)");
            stmt.executeUpdate("call SYSCS_UTIL.SET_DATABASE_PROPERTY('gemfirexd.storage.pageSize', NULL)");
            stmt.executeUpdate("call SYSCS_UTIL.SET_DATABASE_PROPERTY('gemfirexd.storage.pageSize', '4096')");
            stmt.execute("create index i_a on tab10 (a)");
            stmt.execute("create index i_ab on tab10 (a, b)");
            stmt.executeUpdate("call SYSCS_UTIL.SET_DATABASE_PROPERTY('gemfirexd.storage.pageSize', NULL)");
            stmt.execute("insert into tab10 values(1, 1, '')");
            stmt.execute("insert into tab10 values(2, 2, 'test data: a string column inserted as an object')");
            for (int i = 0; i < fileName.length; ++i) {
                File file = new File(fileName[i]);
                streamingColumn.fileLength[i] = file.length();
                FileInputStream fileIn = new FileInputStream(file);
                System.out.println("===> testing " + fileName[i] + " length = " + fileLength[i]);
                PreparedStatement ps = conn.prepareStatement("insert into tab10 values(?, ?, ?)");
                ps.setInt(1, 100 + i);
                ps.setInt(2, 100 + i);
                ps.setAsciiStream(3, (InputStream)fileIn, (int)fileLength[i]);
                try {
                    ps.executeUpdate();
                    System.out.println("No truncation and hence no error");
                }
                catch (SQLException e) {
                    if (fileLength[i] > 32700L && e.getSQLState().equals("22001")) {
                        System.out.println("expected exception for data > 32700 in length");
                    }
                    streamingColumn.dumpSQLExceptions(e);
                }
                ((InputStream)fileIn).close();
            }
            CallableStatement cs = conn.prepareCall("CALL SYSCS_UTIL.COMPRESS_TABLE(?, ?, ?)");
            cs.setString(1, "APP");
            cs.setString(2, "TESTLONGVARCHAR");
            cs.setInt(3, 0);
            cs.execute();
            stmt.execute("CREATE FUNCTION ConsistencyChecker() RETURNS VARCHAR(128) EXTERNAL NAME 'org.apache.derbyTesting.functionTests.util.T_ConsistencyChecker.runConsistencyChecker' LANGUAGE JAVA PARAMETER STYLE JAVA");
            stmt.execute("VALUES ConsistencyChecker()");
            stmt.close();
        }
        catch (SQLException e) {
            streamingColumn.dumpSQLExceptions(e);
        }
        catch (Throwable e) {
            System.out.println("FAIL -- unexpected exception:" + e.toString());
        }
        System.out.println("Testing 10 ends in here");
    }

    private static void streamTest11(Connection conn) {
        System.out.println("Test 11 - Can't pass negative length as the stream length for various setXXXStream methods");
        try {
            Statement stmt = conn.createStatement();
            stmt.execute("create table testLongVarCharInvalidStreamLength (a int, b long varchar, c long varchar for bit data)");
            File file = new File("extin/short.data");
            FileInputStream fileIn = new FileInputStream(file);
            PreparedStatement ps = conn.prepareStatement("insert into testLongVarCharInvalidStreamLength values(?, ?, ?)");
            ps.setInt(1, 100);
            try {
                System.out.println("===> testing using setAsciiStream with -2 as length");
                ps.setAsciiStream(2, (InputStream)fileIn, -2);
                System.out.println("FAIL -- should have gotten exception for -2 param value to setAsciiStream");
            }
            catch (SQLException e) {
                if ("XJ025".equals(e.getSQLState())) {
                    System.out.println("PASS -- expected exception:" + e.toString());
                }
                streamingColumn.dumpSQLExceptions(e);
            }
            InputStreamReader filer = new InputStreamReader((InputStream)fileIn, "US-ASCII");
            try {
                System.out.println("===> testing using setCharacterStream with -1 as length");
                ps.setCharacterStream(2, (Reader)filer, -1);
                System.out.println("FAIL -- should have gotten exception for -1 param value to setCharacterStream");
            }
            catch (SQLException e) {
                if ("XJ025".equals(e.getSQLState())) {
                    System.out.println("PASS -- expected exception:" + e.toString());
                }
                streamingColumn.dumpSQLExceptions(e);
            }
            try {
                System.out.println("===> testing using setBinaryStream with -1 as length");
                ps.setBinaryStream(3, (InputStream)fileIn, -1);
                System.out.println("FAIL -- should have gotten exception for -1 param value to setBinaryStream");
            }
            catch (SQLException e) {
                if ("XJ025".equals(e.getSQLState())) {
                    System.out.println("PASS -- expected exception:" + e.toString());
                }
                streamingColumn.dumpSQLExceptions(e);
            }
            ((InputStream)fileIn).close();
        }
        catch (SQLException e) {
            streamingColumn.dumpSQLExceptions(e);
        }
        catch (Throwable e) {
            System.out.println("FAIL -- unexpected exception:" + e.toString());
        }
        System.out.println("Test 11 - negative stream length tests end in here");
    }

    private static void streamTest12(Connection conn) {
        String fileName1 = "extin/char32675trailingblanks.data";
        String fileName2 = "extin/char32675.data";
        System.out.println("Test 12 - varchar truncation tests start from here");
        try {
            Statement stmt = conn.createStatement();
            stmt.executeUpdate("call SYSCS_UTIL.SET_DATABASE_PROPERTY('gemfirexd.storage.pageSize', '4096')");
            stmt.execute("create table testVarChar (a int, b varchar(32672))");
            stmt.execute("create table testConcatenation (a varchar(16350), b varchar(16350), c varchar(16336), d varchar(16336))");
            stmt.executeUpdate("call SYSCS_UTIL.SET_DATABASE_PROPERTY('gemfirexd.storage.pageSize', NULL)");
            String largeStringA16350 = new String(Formatters.repeatChar("a", 16350));
            String largeStringA16336 = new String(Formatters.repeatChar("a", 16336));
            PreparedStatement ps = conn.prepareStatement("insert into testConcatenation values (?, ?, ?, ?)");
            ps.setString(1, largeStringA16350);
            ps.setString(2, largeStringA16350);
            ps.setString(3, largeStringA16336);
            ps.setString(4, largeStringA16336);
            ps.executeUpdate();
            ps = conn.prepareStatement("insert into testVarChar values(?, ?)");
            streamingColumn.insertDataUsingAsciiStream(ps, 1, fileName1, 32672);
            streamingColumn.insertDataUsingCharacterStream(ps, 2, fileName1, 32672);
            streamingColumn.insertDataUsingStringOrObject(ps, 3, 32672, true, true);
            streamingColumn.insertDataUsingStringOrObject(ps, 4, 32672, true, false);
            System.out.println("===> testing trailing blanks using concatenation");
            streamingColumn.insertDataUsingConcat(stmt, 5, 32672, true, 3);
            streamingColumn.insertDataUsingAsciiStream(ps, 6, fileName2, 32672);
            streamingColumn.insertDataUsingCharacterStream(ps, 7, fileName2, 32672);
            streamingColumn.insertDataUsingStringOrObject(ps, 8, 32672, false, true);
            streamingColumn.insertDataUsingStringOrObject(ps, 9, 32672, false, false);
            System.out.println("===> testing trailing non-blank characters using concatenation");
            streamingColumn.insertDataUsingConcat(stmt, 10, 32672, false, 3);
            ResultSet rs = stmt.executeQuery("select a, b from testVarChar");
            streamingColumn.streamTestDataVerification(rs, 32672);
        }
        catch (SQLException e) {
            streamingColumn.dumpSQLExceptions(e);
        }
        catch (Throwable e) {
            System.out.println("FAIL -- unexpected exception:" + e.toString());
        }
        System.out.println("Test 12 - varchar truncation tests end in here");
    }

    private static void streamTest13(Connection conn) {
        String fileName1 = "extin/char32703trailingblanks.data";
        String fileName2 = "extin/char32703.data";
        System.out.println("Test 13 - long varchar truncation tests start from here");
        try {
            Statement stmt = conn.createStatement();
            stmt.execute("create table testLongVarChars (a int, b long varchar)");
            PreparedStatement ps = conn.prepareStatement("insert into testLongVarChars values(?, ?)");
            streamingColumn.insertDataUsingAsciiStream(ps, 1, fileName1, 32700);
            streamingColumn.insertDataUsingCharacterStream(ps, 2, fileName1, 32700);
            streamingColumn.insertDataUsingStringOrObject(ps, 3, 32700, true, true);
            streamingColumn.insertDataUsingStringOrObject(ps, 4, 32700, true, false);
            streamingColumn.insertDataUsingAsciiStream(ps, 6, fileName2, 32700);
            streamingColumn.insertDataUsingCharacterStream(ps, 7, fileName2, 32700);
            streamingColumn.insertDataUsingStringOrObject(ps, 7, 32700, false, true);
            streamingColumn.insertDataUsingStringOrObject(ps, 9, 32700, false, false);
            ResultSet rs = stmt.executeQuery("select a, b from testLongVarChars");
            streamingColumn.streamTestDataVerification(rs, 32700);
        }
        catch (SQLException e) {
            streamingColumn.dumpSQLExceptions(e);
        }
        catch (Throwable e) {
            System.out.println("FAIL -- unexpected exception:" + e.toString());
        }
        System.out.println("Test 13 - long varchar truncation tests end in here");
    }

    private static void streamTest14(Connection conn) {
        String fileName1 = "extin/char32675trailingblanks.data";
        String fileName2 = "extin/char32675.data";
        System.out.println("Test 14 - clob truncation tests start from here");
        try {
            Statement stmt = conn.createStatement();
            stmt.executeUpdate("call SYSCS_UTIL.SET_DATABASE_PROPERTY('gemfirexd.storage.pageSize', '4096')");
            stmt.execute("drop table testConcatenation");
            stmt.execute("create table testClob (a int, b clob(32672))");
            stmt.execute("create table testConcatenation (a clob(16350), b clob(16350), c clob(16336), d clob(16336))");
            stmt.executeUpdate("call SYSCS_UTIL.SET_DATABASE_PROPERTY('gemfirexd.storage.pageSize', NULL)");
            String largeStringA16350 = new String(Formatters.repeatChar("a", 16350));
            String largeStringA16336 = new String(Formatters.repeatChar("a", 16336));
            PreparedStatement ps = conn.prepareStatement("insert into testConcatenation values (?, ?, ?, ?)");
            ps.setString(1, largeStringA16350);
            ps.setString(2, largeStringA16350);
            ps.setString(3, largeStringA16336);
            ps.setString(4, largeStringA16336);
            ps.executeUpdate();
            ps = conn.prepareStatement("insert into testClob values(?, ?)");
            streamingColumn.insertDataUsingAsciiStream(ps, 1, fileName1, 32672);
            streamingColumn.insertDataUsingCharacterStream(ps, 2, fileName1, 32672);
            streamingColumn.insertDataUsingStringOrObject(ps, 3, 32672, true, true);
            streamingColumn.insertDataUsingStringOrObject(ps, 4, 32672, true, false);
            System.out.println("===> testing trailing blanks using concatenation");
            streamingColumn.insertDataUsingConcat(stmt, 5, 32672, true, 2);
            streamingColumn.insertDataUsingAsciiStream(ps, 6, fileName2, 32672);
            streamingColumn.insertDataUsingCharacterStream(ps, 7, fileName2, 32672);
            streamingColumn.insertDataUsingStringOrObject(ps, 8, 32672, false, true);
            streamingColumn.insertDataUsingStringOrObject(ps, 9, 32672, false, false);
            System.out.println("===> testing trailing non-blank characters using concatenation");
            streamingColumn.insertDataUsingConcat(stmt, 10, 32672, false, 2);
            ResultSet rs = stmt.executeQuery("select a, b from testVarChar");
            streamingColumn.streamTestDataVerification(rs, 32672);
        }
        catch (SQLException e) {
            streamingColumn.dumpSQLExceptions(e);
        }
        catch (Throwable e) {
            System.out.println("FAIL -- unexpected exception:" + e.toString());
        }
        System.out.println("Test 14 - clob truncation tests end in here");
    }

    private static void derby500Test(Connection conn) {
        System.out.println("======================================");
        System.out.println("START  DERBY-500 TEST ");
        try {
            Statement stmt = conn.createStatement();
            conn.setAutoCommit(false);
            stmt.execute("CREATE TABLE t1 (id INTEGER NOT NULL,mname VARCHAR( 254 ) NOT NULL,mvalue INT NOT NULL,bytedata BLOB NOT NULL,chardata CLOB NOT NULL,PRIMARY KEY ( id ))");
            PreparedStatement ps = conn.prepareStatement("insert into t1 values (?,?,?,?,?)");
            int rowCount = 0;
            int len = 10000;
            byte[] buf = new byte[len];
            char[] cbuf = new char[len];
            int orig = 99;
            for (int i = 0; i < len; ++i) {
                buf[i] = (byte)orig;
                cbuf[i] = orig;
            }
            int randomOffset = 9998;
            buf[randomOffset] = 101;
            cbuf[randomOffset] = 101;
            System.out.println("Inserting rows ");
            for (int i = 0; i < 10; ++i) {
                ps.setInt(1, i);
                ps.setString(2, "mname" + i);
                ps.setInt(3, 0);
                ps.setBinaryStream(4, (InputStream)new ByteArrayInputStream(buf), len);
                ps.setAsciiStream(5, (InputStream)new ByteArrayInputStream(buf), len);
                rowCount += ps.executeUpdate();
            }
            conn.commit();
            System.out.println("Rows inserted =" + rowCount);
            PreparedStatement pss = conn.prepareStatement(" select chardata,bytedata from t1 where id = ?");
            streamingColumn.verifyDerby500Test(pss, buf, cbuf, 0, 10, true);
            PreparedStatement psu = conn.prepareStatement("update t1 set bytedata = ? , chardata = ? where mvalue = ?  ");
            buf[randomOffset + 1] = 117;
            cbuf[randomOffset + 1] = 117;
            rowCount = 0;
            System.out.println("Update qualifies many rows + streams");
            try {
                psu.setBinaryStream(1, (InputStream)new ByteArrayInputStream(buf), len);
                psu.setCharacterStream(2, (Reader)new CharArrayReader(cbuf), len);
                psu.setInt(3, 0);
                System.out.println("DERBY500 #1 Rows updated  =" + (rowCount += psu.executeUpdate()));
            }
            catch (SQLException sqle) {
                System.out.println("EXPECTED EXCEPTION - streams cannot be re-used");
                streamingColumn.expectedException(sqle);
                conn.rollback();
            }
            buf[randomOffset + 1] = (byte)orig;
            cbuf[randomOffset + 1] = orig;
            streamingColumn.verifyDerby500Test(pss, buf, cbuf, 0, 10, true);
            PreparedStatement psu2 = conn.prepareStatement("update t1 set bytedata = ? , chardata = ? where id = ?  ");
            buf[randomOffset + 1] = 117;
            cbuf[randomOffset + 1] = 117;
            rowCount = 0;
            try {
                psu2.setBinaryStream(1, (InputStream)new ByteArrayInputStream(buf), len);
                psu2.setAsciiStream(2, (InputStream)new ByteArrayInputStream(buf), len);
                psu2.setInt(3, 0);
                System.out.println("DERBY500 #2 Rows updated  =" + (rowCount += psu2.executeUpdate()));
            }
            catch (SQLException sqle) {
                System.out.println("UNEXPECTED EXCEPTION - update should have actually gone through");
                streamingColumn.dumpSQLExceptions(sqle);
            }
            conn.commit();
            streamingColumn.verifyDerby500Test(pss, buf, cbuf, 0, 1, true);
            PreparedStatement psd = conn.prepareStatement("delete from t1 where mvalue = ?");
            rowCount = 0;
            try {
                psd.setInt(1, 0);
                rowCount += psd.executeUpdate();
                System.out.println("DERBY500 #3 Rows deleted =" + (rowCount += psd.executeUpdate()));
            }
            catch (SQLException sqle) {
                System.out.println("UNEXPECTED EXCEPTION - delete should have actually gone through");
                streamingColumn.dumpSQLExceptions(sqle);
            }
            conn.commit();
            streamingColumn.verifyDerby500Test(pss, buf, cbuf, 0, 10, true);
            PreparedStatement psd2 = conn.prepareStatement("delete from t1 where id = ?");
            rowCount = 0;
            try {
                psd2.setInt(1, 0);
                System.out.println("DERBY500 #4 Rows deleted  =" + (rowCount += psd2.executeUpdate()));
            }
            catch (SQLException sqle) {
                System.out.println("UNEXPECTED EXCEPTION - delete should have actually gone through");
                streamingColumn.dumpSQLExceptions(sqle);
            }
            conn.commit();
            streamingColumn.verifyDerby500Test(pss, buf, cbuf, 1, 2, true);
            try {
                ps.setInt(1, 11);
                System.out.println("Rows inserted = " + (rowCount += ps.executeUpdate()));
            }
            catch (SQLException sqle) {
                System.out.println("EXPECTED EXCEPTION - streams cannot be re-used");
                streamingColumn.expectedException(sqle);
                conn.rollback();
            }
            stmt.execute("drop table t1");
            conn.commit();
            stmt.close();
            pss.close();
            psu2.close();
            psu.close();
            psd.close();
            psd2.close();
            System.out.println("END  DERBY-500 TEST ");
            System.out.println("======================================");
        }
        catch (SQLException sqle) {
            streamingColumn.dumpSQLExceptions(sqle);
        }
        catch (Exception e) {
            System.out.println("DERBY-500 TEST FAILED!");
            e.printStackTrace();
        }
    }

    private static void derby500_verifyVarcharStreams(Connection conn) {
        System.out.println("======================================");
        System.out.println("START  DERBY-500 TEST for varchar ");
        try {
            Statement stmt = conn.createStatement();
            stmt.execute("CREATE TABLE t1 (id INTEGER NOT NULL,mname VARCHAR( 254 ) NOT NULL,mvalue INT NOT NULL,vc varchar(32500),lvc long varchar NOT NULL,PRIMARY KEY ( id ))");
            PreparedStatement ps = conn.prepareStatement("insert into t1 values (?,?,?,?,?)");
            int rowCount = 0;
            int len = 10000;
            byte[] buf = new byte[len];
            char[] cbuf = new char[len];
            int orig = 99;
            for (int i = 0; i < len; ++i) {
                buf[i] = (byte)orig;
                cbuf[i] = orig;
            }
            int randomOffset = 9998;
            buf[randomOffset] = 101;
            cbuf[randomOffset] = 101;
            for (int i = 0; i < 10; ++i) {
                ps.setInt(1, i);
                ps.setString(2, "mname" + i);
                ps.setInt(3, 0);
                ps.setCharacterStream(4, (Reader)new CharArrayReader(cbuf), len);
                ps.setAsciiStream(5, (InputStream)new ByteArrayInputStream(buf), len);
                rowCount += ps.executeUpdate();
            }
            conn.commit();
            System.out.println("Rows inserted =" + rowCount);
            try {
                ps.setInt(1, 11);
                rowCount += ps.executeUpdate();
            }
            catch (SQLException sqle) {
                System.out.println("UNEXPECTED EXCEPTION - streams cannot be re-used but in case of varchar, stream is materialized the first time around. So multiple executions using streams should  work fine. ");
                streamingColumn.dumpSQLExceptions(sqle);
            }
            PreparedStatement pss = conn.prepareStatement(" select lvc,vc from t1 where id = ?");
            streamingColumn.verifyDerby500Test(pss, buf, cbuf, 0, 10, false);
            PreparedStatement psu = conn.prepareStatement("update t1 set vc = ? , lvc = ? where mvalue = ?  ");
            buf[randomOffset + 1] = 117;
            cbuf[randomOffset + 1] = 117;
            rowCount = 0;
            try {
                psu.setAsciiStream(1, (InputStream)new ByteArrayInputStream(buf), len);
                psu.setCharacterStream(2, (Reader)new CharArrayReader(cbuf), len);
                psu.setInt(3, 0);
                rowCount += psu.executeUpdate();
            }
            catch (SQLException sqle) {
                System.out.println("EXPECTED EXCEPTION - streams cannot be re-used");
                streamingColumn.expectedException(sqle);
            }
            System.out.println("DERBY500 for varchar #1 Rows updated  =" + rowCount);
            streamingColumn.verifyDerby500Test(pss, buf, cbuf, 0, 10, false);
            PreparedStatement psu2 = conn.prepareStatement("update t1 set vc = ? , lvc = ? where id = ?  ");
            buf[randomOffset + 1] = 104;
            cbuf[randomOffset + 1] = 104;
            rowCount = 0;
            try {
                psu2.setAsciiStream(1, (InputStream)new ByteArrayInputStream(buf), len);
                psu2.setAsciiStream(2, (InputStream)new ByteArrayInputStream(buf), len);
                psu2.setInt(3, 0);
                rowCount += psu2.executeUpdate();
            }
            catch (SQLException sqle) {
                System.out.println("UNEXPECTED EXCEPTION - update should have actually gone through");
                streamingColumn.dumpSQLExceptions(sqle);
            }
            conn.commit();
            System.out.println("DERBY500 for varchar #2 Rows updated  =" + rowCount);
            streamingColumn.verifyDerby500Test(pss, buf, cbuf, 0, 1, false);
            PreparedStatement psd = conn.prepareStatement("delete from t1 where mvalue = ?");
            rowCount = 0;
            try {
                psd.setInt(1, 0);
                rowCount += psd.executeUpdate();
                rowCount += psd.executeUpdate();
            }
            catch (SQLException sqle) {
                System.out.println("UNEXPECTED EXCEPTION - delete should have actually gone through");
                streamingColumn.dumpSQLExceptions(sqle);
            }
            System.out.println("DERBY500 for varchar #3 Rows deleted =" + rowCount);
            streamingColumn.verifyDerby500Test(pss, buf, cbuf, 0, 10, false);
            PreparedStatement psd2 = conn.prepareStatement("delete from t1 where id = ?");
            rowCount = 0;
            try {
                psd2.setInt(1, 0);
                rowCount += psd2.executeUpdate();
            }
            catch (SQLException sqle) {
                System.out.println("UNEXPECTED EXCEPTION - delete should have actually gone through");
                streamingColumn.dumpSQLExceptions(sqle);
            }
            conn.commit();
            System.out.println("DERBY500 for varchar #4 Rows deleted  =" + rowCount);
            streamingColumn.verifyDerby500Test(pss, buf, cbuf, 1, 2, false);
            stmt.execute("drop table t1");
            conn.commit();
            stmt.close();
            pss.close();
            psu2.close();
            psu.close();
            psd.close();
            psd2.close();
            System.out.println("END  DERBY-500 TEST  for varchar");
            System.out.println("======================================");
        }
        catch (SQLException sqle) {
            streamingColumn.dumpSQLExceptions(sqle);
        }
        catch (Exception e) {
            System.out.println("DERBY-500 TEST for varchar FAILED!");
            e.printStackTrace();
        }
    }

    private static void verifyDerby500Test(PreparedStatement ps, byte[] buf, char[] cbuf, int startId, int endId, boolean binaryType) throws Exception {
        Object retrieveData = null;
        int rowCount = 0;
        ResultSet rs = null;
        for (int i = startId; i < endId; ++i) {
            ps.setInt(1, i);
            rs = ps.executeQuery();
            if (!rs.next()) continue;
            streamingColumn.compareCharArray(rs.getCharacterStream(1), cbuf, cbuf.length);
            if (binaryType) {
                streamingColumn.byteArrayEquals(rs.getBytes(2), 0, buf.length, buf, 0, buf.length);
            } else {
                streamingColumn.compareCharArray(rs.getCharacterStream(2), cbuf, cbuf.length);
            }
            ++rowCount;
        }
        System.out.println("Rows selected =" + rowCount);
        rs.close();
    }

    private static void compareCharArray(Reader stream, char[] compare, int length) throws Exception {
        int c1 = 0;
        int i = 0;
        do {
            if ((c1 = stream.read()) == compare[i++]) continue;
            System.out.println("FAIL -- MISMATCH in data stored versus data retrieved at " + (i - 1));
            break;
        } while (c1 != -1 && --length > 0);
    }

    private static void expectedException(SQLException sqle) {
        while (sqle != null) {
            String sqlState = sqle.getSQLState();
            if (sqlState == null) {
                sqlState = "<NULL>";
            }
            System.out.println("EXPECTED SQL Exception: (" + sqlState + ") " + sqle.getMessage());
            sqle = sqle.getNextException();
        }
    }

    private static void streamTestDataVerification(ResultSet rs, int maxValueAllowed) throws Exception {
        ResultSetMetaData met = rs.getMetaData();
        byte[] buff = new byte[128];
        while (rs.next()) {
            int size;
            int a = rs.getInt("a");
            InputStream fin = rs.getAsciiStream(2);
            int columnSize = 0;
            while ((size = fin.read(buff)) != -1) {
                columnSize += size;
            }
            if (a >= 1 && a <= 5 && columnSize == maxValueAllowed) {
                System.out.println("===> verified length " + maxValueAllowed);
                continue;
            }
            System.out.println("test failed, columnSize should be " + maxValueAllowed + " but it is" + columnSize);
        }
    }

    private static void insertDataUsingConcat(Statement stmt, int intValue, int maxValueAllowed, boolean blankPadding, int tblType) throws Exception {
        String sql;
        switch (tblType) {
            case 1: {
                sql = "insert into testLongVarChars select " + intValue + ", a||b||";
                break;
            }
            case 2: {
                sql = "insert into testClob select " + intValue + ", c||d||";
                break;
            }
            default: {
                sql = "insert into testVarChar select " + intValue + ", c||d||";
            }
        }
        sql = blankPadding ? sql.concat("'   ' from testConcatenation") : sql.concat("'123' from testConcatenation");
        try {
            stmt.execute(sql);
            System.out.println("No truncation and hence no error.");
        }
        catch (SQLException e) {
            if (e.getSQLState().equals("22001")) {
                System.out.println("expected exception for data > " + maxValueAllowed + " in length");
            }
            streamingColumn.dumpSQLExceptions(e);
        }
    }

    private static void insertDataUsingStringOrObject(PreparedStatement ps, int intValue, int maxValueAllowed, boolean blankPadding, boolean testUsingString) throws Exception {
        StringBuilder sb = new StringBuilder(maxValueAllowed);
        for (int i = 0; i < maxValueAllowed; ++i) {
            sb.append('q');
        }
        String largeString = new String(sb);
        if (blankPadding) {
            largeString = largeString.concat("   ");
            System.out.print("===> testing trailing blanks(using ");
        } else {
            largeString = largeString.concat("123");
            System.out.print("===> testing trailing non-blanks(using ");
        }
        ps.setInt(1, intValue);
        if (testUsingString) {
            System.out.println("setString) length = " + largeString.length());
            ps.setString(2, largeString);
        } else {
            System.out.println("setObject) length = " + largeString.length());
            ps.setObject(2, largeString);
        }
        try {
            ps.executeUpdate();
            System.out.println("No truncation and hence no error");
        }
        catch (SQLException e) {
            if (largeString.length() > maxValueAllowed && e.getSQLState().equals("22001")) {
                System.out.println("expected exception for data > " + maxValueAllowed + " in length");
            }
            streamingColumn.dumpSQLExceptions(e);
        }
    }

    private static void insertDataUsingCharacterStream(PreparedStatement ps, int intValue, String fileName, int maxValueAllowed) throws Exception {
        File file = new File(fileName);
        FileInputStream fileIn = new FileInputStream(file);
        InputStreamReader filer = new InputStreamReader((InputStream)fileIn, "US-ASCII");
        System.out.println("===> testing(using setCharacterStream) " + fileName + " length = " + file.length());
        ps.setInt(1, intValue);
        ps.setCharacterStream(2, (Reader)filer, (int)file.length());
        try {
            ps.executeUpdate();
            System.out.println("No truncation and hence no error");
        }
        catch (SQLException e) {
            if (file.length() > (long)maxValueAllowed && e.getSQLState().equals("22001")) {
                System.out.println("expected exception for data > " + maxValueAllowed + " in length");
            }
            TestUtil.dumpSQLExceptions(e, true);
        }
        ((Reader)filer).close();
    }

    private static void insertDataUsingAsciiStream(PreparedStatement ps, int intValue, String fileName, int maxValueAllowed) throws Exception {
        File file = new File(fileName);
        FileInputStream fileIn = new FileInputStream(file);
        System.out.println("===> testing(using setAsciiStream) " + fileName + " length = " + file.length());
        ps.setInt(1, intValue);
        ps.setAsciiStream(2, (InputStream)fileIn, (int)file.length());
        try {
            ps.executeUpdate();
            System.out.println("No truncation and hence no error");
        }
        catch (SQLException e) {
            if (file.length() > (long)maxValueAllowed && e.getSQLState().equals("22001")) {
                System.out.println("expected exception for data > " + maxValueAllowed + " in length");
            }
            TestUtil.dumpSQLExceptions(e, true);
        }
        ((InputStream)fileIn).close();
    }

    static void verifyLength(int a, int columnSize, long[] fileLength) {
        for (int i = 0; i < fileLength.length; ++i) {
            if (a != 100 + i && a != 10000 + i) continue;
            if ((long)columnSize != fileLength[i]) {
                System.out.println("test failed, columnSize should be " + fileLength[i] + ", but it is " + columnSize + ", i = " + i);
                continue;
            }
            System.out.println("===> verified length " + fileLength[i]);
        }
    }

    static void verifyExistence(Connection conn, int key, String base, long length) throws Exception {
        if (!streamingColumn.pad(base, length).equals(streamingColumn.getLongString(conn, key))) {
            throw new Exception("failed to find value " + base + "... at key " + key);
        }
    }

    static String getLongString(Connection conn, int key) throws Exception {
        Statement s = conn.createStatement();
        ResultSet rs = s.executeQuery("select b from foo where a = " + key);
        if (!rs.next()) {
            throw new Exception("there weren't any rows for key = " + key);
        }
        String answer = rs.getString(1);
        if (rs.next()) {
            throw new Exception("there were multiple rows for key = " + key);
        }
        rs.close();
        s.close();
        return answer;
    }

    static String pad(String base, long length) {
        StringBuilder b = new StringBuilder(base);
        long i = 1L;
        while ((long)b.length() < length) {
            b.append(" " + i);
            ++i;
        }
        return b.toString();
    }

    static int insertLongString(Connection conn, int key, String data, boolean binaryColumn) throws Exception {
        PreparedStatement ps = conn.prepareStatement("insert into foo values(" + key + ", ?)");
        return streamingColumn.streamInStringCol(ps, data, binaryColumn);
    }

    static int updateLongString(Connection conn, int oldkey, int newkey) throws Exception {
        PreparedStatement ps = conn.prepareStatement("update foo set a = ?, b = ? where a = " + oldkey);
        String updateString = streamingColumn.pad("", newkey);
        ByteArrayInputStream bais = new ByteArrayInputStream(updateString.getBytes("US-ASCII"));
        ps.setInt(1, newkey);
        ps.setAsciiStream(2, (InputStream)bais, updateString.length());
        int nRows = ps.executeUpdate();
        ps.close();
        return nRows;
    }

    static int streamInStringCol(PreparedStatement ps, String data, boolean binaryColumn) throws Exception {
        int nRows = 0;
        if (data == null) {
            ps.setAsciiStream(1, (InputStream)null, 0);
            nRows = ps.executeUpdate();
        } else {
            ByteArrayInputStream bais = new ByteArrayInputStream(data.getBytes("US-ASCII"));
            if (binaryColumn) {
                ps.setBinaryStream(1, (InputStream)bais, data.length());
            } else {
                ps.setAsciiStream(1, (InputStream)bais, data.length());
            }
            nRows = ps.executeUpdate();
            bais.close();
        }
        return nRows;
    }

    public static int streamInLongCol(PreparedStatement ps, Object data) throws Exception {
        String s = (String)data;
        ByteArrayInputStream bais = new ByteArrayInputStream(s.getBytes("US-ASCII"));
        ps.setAsciiStream(1, (InputStream)bais, s.length());
        int nRows = ps.executeUpdate();
        bais.close();
        return nRows;
    }

    private static boolean byteArrayEquals(byte[] a, int aOffset, int aLength, byte[] b, int bOffset, int bLength) {
        if (aLength != bLength) {
            return false;
        }
        for (int i = 0; i < aLength; ++i) {
            if (a[i + aOffset] == b[i + bOffset]) continue;
            return false;
        }
        return true;
    }

    private static void dumpSQLExceptions(SQLException se) {
        System.out.println("FAIL -- unexpected exception: " + se.toString());
        se.printStackTrace();
        while (se != null) {
            System.out.println("SQLSTATE(" + se.getSQLState() + "):" + se.getMessage());
            se = se.getNextException();
        }
    }

    static {
        int numFiles = 4;
        fileName = new String[numFiles];
        fileLength = new long[numFiles];
        streamingColumn.fileName[0] = "extin/short.data";
        streamingColumn.fileName[1] = "extin/shortbanner";
        streamingColumn.fileName[2] = "extin/derby.banner";
        streamingColumn.fileName[3] = "extin/empty.data";
    }
}

