/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.store;

import com.pivotal.gemfirexd.internal.tools.ij;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.derbyTesting.functionTests.util.TestUtil;

public class backupRestore1 {
    private static final byte[] blob1;
    private static final byte[] blob2;
    private static final byte[] blob3;
    private static final byte[] blob4;
    private static final byte[] clob1;
    private static final byte[] clob2;
    private static final byte[] clob3;
    private static final byte[] clob4;

    public static void main(String[] args) {
        Connection conn;
        Statement stmt;
        Connection conn2;
        System.out.println("Test backupRestore starting");
        try {
            ij.getPropertyArg((String[])args);
            conn2 = ij.startJBMS();
            stmt = conn2.createStatement();
            stmt.execute("CREATE FUNCTION ConsistencyChecker() RETURNS VARCHAR(128) EXTERNAL NAME 'org.apache.derbyTesting.functionTests.util.T_ConsistencyChecker.runConsistencyChecker' LANGUAGE JAVA PARAMETER STYLE JAVA");
            stmt.executeUpdate("create table t( id integer not null primary key, cBlob blob(64K),cClob clob(64K), clvarchar long varchar, clvarbinary long varchar for bit data)");
            conn2.setAutoCommit(false);
            PreparedStatement insStmt = conn2.prepareStatement("insert into t( id, cBlob, cClob, clvarchar, clvarbinary) values( ?, ?, ?, ?, ?)");
            insStmt.setInt(1, 1);
            insStmt.setBinaryStream(2, (InputStream)new ByteArrayInputStream(blob1), blob1.length);
            insStmt.setAsciiStream(3, (InputStream)new ByteArrayInputStream(clob1), clob1.length);
            insStmt.setAsciiStream(4, (InputStream)new ByteArrayInputStream(clob2), clob2.length);
            insStmt.setBinaryStream(5, (InputStream)new ByteArrayInputStream(blob2), blob2.length);
            insStmt.executeUpdate();
            insStmt.setInt(1, 2);
            insStmt.setBinaryStream(2, (InputStream)new ByteArrayInputStream(blob3), blob3.length);
            insStmt.setAsciiStream(3, (InputStream)new ByteArrayInputStream(clob3), clob3.length);
            insStmt.setAsciiStream(4, (InputStream)new ByteArrayInputStream(clob4), clob4.length);
            insStmt.setBinaryStream(5, (InputStream)new ByteArrayInputStream(blob4), blob4.length);
            insStmt.executeUpdate();
            conn2.commit();
            CallableStatement backupStmt = conn2.prepareCall("CALL SYSCS_UTIL.BACKUP_DATABASE_AND_ENABLE_LOG_ARCHIVE_MODE(?, ?)");
            backupStmt.setString(1, "extinout/mybackup");
            backupStmt.setInt(2, 1);
            backupStmt.execute();
            backupStmt.close();
            insStmt.setInt(1, 3);
            insStmt.setBinaryStream(2, (InputStream)new ByteArrayInputStream(blob3), blob3.length);
            insStmt.setAsciiStream(3, (InputStream)new ByteArrayInputStream(clob3), clob3.length);
            insStmt.setAsciiStream(4, (InputStream)new ByteArrayInputStream(clob4), clob4.length);
            insStmt.setBinaryStream(5, (InputStream)new ByteArrayInputStream(blob4), blob4.length);
            insStmt.executeUpdate();
            conn2.commit();
            insStmt.close();
            conn2.close();
        }
        catch (SQLException e) {
            backupRestore1.dumpSQLExceptions(e);
        }
        catch (Throwable e) {
            System.out.println("FAIL -- unexpected exception:" + e.toString());
        }
        try {
            TestUtil.getConnection("wombat", "shutdown=true");
        }
        catch (SQLException se) {
            if (se.getSQLState() != null && se.getSQLState().equals("08006")) {
                System.out.println("database shutdown properly");
            } else {
                backupRestore1.dumpSQLExceptions(se);
            }
        }
        catch (Throwable e) {
            System.out.println("FAIL -- unexpected exception:" + e.toString());
        }
        System.out.println("testing rollforward recovery");
        try {
            conn2 = TestUtil.getConnection("wombat", "rollForwardRecoveryFrom=extinout/mybackup/wombat");
            stmt = conn2.createStatement();
            stmt.execute("VALUES (ConsistencyChecker())");
            ResultSet rs = stmt.executeQuery("select count(*) from t");
            while (rs.next()) {
                int count = rs.getInt(1);
                System.out.println(count);
            }
            conn2.commit();
            conn2.close();
            TestUtil.getConnection("wombat", "shutdown=true");
        }
        catch (SQLException se) {
            if (se.getSQLState() != null && se.getSQLState().equals("08006")) {
                System.out.println("database shutdown properly");
            } else {
                backupRestore1.dumpSQLExceptions(se);
            }
        }
        catch (Throwable e) {
            System.out.println("FAIL -- unexpected exception:" + e.toString());
        }
        RandomAccessFile rfs = null;
        boolean alreadyShutdown = false;
        try {
            conn = TestUtil.getConnection("wombat", null);
            rfs = new RandomAccessFile("extinout/mybackup/wombat/service.properties", "r");
            CallableStatement backupStmt = conn.prepareCall("CALL SYSCS_UTIL.BACKUP_DATABASE(?)");
            backupStmt.setString(1, "extinout/mybackup");
            backupStmt.execute();
            backupStmt.close();
            conn.close();
            TestUtil.getConnection("wombat", "shutdown=true");
        }
        catch (SQLException se) {
            if (se.getSQLState() != null && se.getSQLState().equals("XSRS4")) {
                alreadyShutdown = false;
            } else if (se.getSQLState() != null && se.getSQLState().equals("08006")) {
                System.out.println("database shutdown properly");
                alreadyShutdown = true;
            } else {
                backupRestore1.dumpSQLExceptions(se);
            }
        }
        catch (Throwable e) {
            System.out.println("FAIL -- unexpected exception:" + e.toString());
        }
        if (!alreadyShutdown) {
            try {
                TestUtil.getConnection("wombat", "shutdown=true");
            }
            catch (SQLException se) {
                if (se.getSQLState() != null && se.getSQLState().equals("08006")) {
                    System.out.println("database shutdown properly");
                } else {
                    backupRestore1.dumpSQLExceptions(se);
                }
            }
            catch (Throwable e) {
                System.out.println("FAIL -- unexpected exception:" + e.toString());
            }
        }
        try {
            if (rfs != null) {
                rfs.close();
            }
            conn = TestUtil.getConnection("wombat", "restoreFrom=extinout/mybackup/wombat");
            Statement stmt2 = conn.createStatement();
            stmt2.execute("VALUES (ConsistencyChecker())");
            conn.close();
            TestUtil.getConnection("wombat", "shutdown=true");
        }
        catch (SQLException se) {
            if (se.getSQLState() != null && se.getSQLState().equals("08006")) {
                System.out.println("database shutdown properly");
            } else {
                backupRestore1.dumpSQLExceptions(se);
            }
        }
        catch (Throwable e) {
            System.out.println("FAIL -- unexpected exception:" + e.toString());
        }
        try {
            conn = TestUtil.getConnection("wombat", null);
            CallableStatement backupStmt = conn.prepareCall("CALL SYSCS_UTIL.BACKUP_DATABASE(?)");
            backupStmt.setString(1, "extinout/mybackup");
            backupStmt.execute();
            backupStmt.close();
            Statement stmt3 = conn.createStatement();
            stmt3.execute("VALUES (ConsistencyChecker())");
            conn.close();
            TestUtil.getConnection("wombat", "shutdown=true");
        }
        catch (SQLException se) {
            if (se.getSQLState() != null && se.getSQLState().equals("08006")) {
                System.out.println("database shutdown properly");
            } else {
                backupRestore1.dumpSQLExceptions(se);
            }
        }
        catch (Throwable e) {
            System.out.println("FAIL -- unexpected exception:" + e.toString());
        }
        System.out.println("Test backupRestore1 finished");
    }

    private static void dumpSQLExceptions(SQLException se) {
        System.out.println("FAIL -- unexpected exception: " + se.toString());
        SQLException lastSe = se;
        while (se != null) {
            System.out.print("SQLSTATE(" + se.getSQLState() + "):");
            lastSe = se;
            se = se.getNextException();
        }
        System.out.println("");
        lastSe.printStackTrace(System.out);
    }

    static {
        int i;
        blob1 = new byte[]{1, 2, 3, 4, 5, 6, 7, 8};
        blob2 = new byte[16385];
        blob3 = new byte[32768];
        blob4 = new byte[32700];
        clob1 = new byte[]{97, 98, 99, 100, 101, 102, 103, 104};
        clob2 = new byte[16385];
        clob3 = new byte[32768];
        clob4 = new byte[4096];
        for (i = 0; i < clob2.length; ++i) {
            backupRestore1.clob2[i] = 97;
        }
        for (i = 0; i < clob3.length; ++i) {
            backupRestore1.clob3[i] = 98;
        }
        for (i = 0; i < clob4.length; ++i) {
            backupRestore1.clob4[i] = 99;
        }
    }
}

