/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.store;

import com.pivotal.gemfirexd.internal.iapi.error.PublicAPI;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.sql.conn.ConnectionUtil;
import com.pivotal.gemfirexd.internal.iapi.sql.conn.LanguageConnectionContext;
import com.pivotal.gemfirexd.internal.iapi.store.access.DiskHashtable;
import com.pivotal.gemfirexd.internal.iapi.store.access.KeyHasher;
import com.pivotal.gemfirexd.internal.iapi.store.access.TransactionController;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.SQLInteger;
import com.pivotal.gemfirexd.internal.iapi.types.SQLLongint;
import com.pivotal.gemfirexd.internal.iapi.types.SQLVarchar;
import com.pivotal.gemfirexd.internal.tools.ij;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.BitSet;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Vector;
import org.apache.derbyTesting.functionTests.util.TestUtil;

public class TestDiskHashtable {
    private TransactionController tc;
    private int failed = 0;
    private static final DataValueDescriptor[] singleKeyTemplate = new DataValueDescriptor[]{new SQLInteger(), new SQLVarchar()};
    private static final int[] singleKeyCols = new int[]{0};
    private static final DataValueDescriptor[][] singleKeyRows = new DataValueDescriptor[][]{{new SQLInteger(1), new SQLVarchar("abcd")}, {new SQLInteger(2), new SQLVarchar("abcd")}, {new SQLInteger(3), new SQLVarchar("e")}, {new SQLInteger(1), new SQLVarchar("zz")}};
    private static final DataValueDescriptor[] multiKeyTemplate = new DataValueDescriptor[]{new SQLLongint(), new SQLVarchar(), new SQLInteger()};
    private static final int[] multiKeyCols = new int[]{1, 0};
    private static final DataValueDescriptor[][] multiKeyRows = new DataValueDescriptor[][]{{new SQLLongint(1L), new SQLVarchar("aa"), multiKeyTemplate[2].getNewNull()}, {new SQLLongint(2L), new SQLVarchar("aa"), new SQLInteger(1)}, {new SQLLongint(2L), new SQLVarchar("aa"), new SQLInteger(2)}, {new SQLLongint(2L), new SQLVarchar("b"), new SQLInteger(1)}};
    private static final int LOTS_OF_ROWS_COUNT = 50000;

    public static void main(String[] args) {
        int failed = 1;
        TestDiskHashtable.REPORT("Test DiskHashtable starting");
        try {
            ij.getPropertyArg((String[])args);
            Connection conn = ij.startJBMS();
            Statement stmt = conn.createStatement();
            stmt.execute("CREATE FUNCTION testDiskHashtable() returns INTEGER EXTERNAL NAME 'org.apache.derbyTesting.functionTests.tests.store.TestDiskHashtable.runTests' LANGUAGE JAVA PARAMETER STYLE JAVA");
            ResultSet rs = stmt.executeQuery("values( testDiskHashtable())");
            if (rs.next()) {
                failed = rs.getInt(1);
            }
            stmt.close();
            conn.close();
        }
        catch (SQLException e) {
            TestUtil.dumpSQLExceptions(e);
            failed = 1;
        }
        catch (Throwable t) {
            TestDiskHashtable.REPORT("FAIL -- unexpected exception:" + t.toString());
            failed = 1;
        }
        TestDiskHashtable.REPORT(failed == 0 ? "OK" : "FAILED");
        System.exit(failed == 0 ? 0 : 1);
    }

    private void REPORT_FAILURE(String msg) {
        this.failed = 1;
        TestDiskHashtable.REPORT(msg);
    }

    private static void REPORT(String msg) {
        System.out.println(msg);
    }

    public static int runTests() throws SQLException {
        TestDiskHashtable tester = new TestDiskHashtable();
        return tester.doIt();
    }

    private TestDiskHashtable() throws SQLException {
        LanguageConnectionContext lcc = ConnectionUtil.getCurrentLCC();
        if (lcc == null) {
            throw new SQLException("Cannot get the LCC");
        }
        this.tc = lcc.getTransactionExecute();
    }

    private int doIt() throws SQLException {
        try {
            TestDiskHashtable.REPORT("Starting single key, keep duplicates test");
            this.testOneVariant(this.tc, false, singleKeyTemplate, singleKeyCols, singleKeyRows);
            TestDiskHashtable.REPORT("Starting single key, remove duplicates test");
            this.testOneVariant(this.tc, true, singleKeyTemplate, singleKeyCols, singleKeyRows);
            TestDiskHashtable.REPORT("Starting multiple key, keep duplicates test");
            this.testOneVariant(this.tc, false, multiKeyTemplate, multiKeyCols, multiKeyRows);
            TestDiskHashtable.REPORT("Starting multiple key, remove duplicates test");
            this.testOneVariant(this.tc, true, multiKeyTemplate, multiKeyCols, multiKeyRows);
            this.tc.commit();
        }
        catch (StandardException se) {
            throw PublicAPI.wrapStandardException((StandardException)se);
        }
        return this.failed;
    }

    private void testOneVariant(TransactionController tc, boolean removeDups, DataValueDescriptor[] template, int[] keyCols, DataValueDescriptor[][] rows) throws StandardException {
        Object key;
        int i;
        DiskHashtable dht = new DiskHashtable(tc, template, (int[])null, keyCols, removeDups, false);
        boolean[] isDuplicate = new boolean[rows.length];
        boolean[] found = new boolean[rows.length];
        HashMap<Object, Vector<DataValueDescriptor[]>> simpleHash = new HashMap<Object, Vector<DataValueDescriptor[]>>(rows.length);
        this.testElements(removeDups, dht, keyCols, 0, rows, simpleHash, isDuplicate, found);
        for (i = 0; i < rows.length; ++i) {
            key = KeyHasher.buildHashKey((Object[])rows[i], (int[])keyCols);
            Vector<DataValueDescriptor[]> al = (Vector<DataValueDescriptor[]>)simpleHash.get(key);
            boolean bl = isDuplicate[i] = al != null;
            if (al == null) {
                al = new Vector<DataValueDescriptor[]>(4);
                simpleHash.put(key, al);
            }
            if (!removeDups || !isDuplicate[i]) {
                al.add(rows[i]);
            }
            if (dht.put(key, rows[i]) != (removeDups ? !isDuplicate[i] : true)) {
                this.REPORT_FAILURE("  put returned wrong value on row " + i);
            }
            for (int j = 0; j <= i; ++j) {
                key = KeyHasher.buildHashKey((Object[])rows[j], (int[])keyCols);
                if (this.rowsEqual(dht.get(key), simpleHash.get(key))) continue;
                this.REPORT_FAILURE("  get returned wrong value on key " + j);
            }
            this.testElements(removeDups, dht, keyCols, i + 1, rows, simpleHash, isDuplicate, found);
        }
        for (i = 0; i < rows.length; ++i) {
            key = KeyHasher.buildHashKey((Object[])rows[i], (int[])keyCols);
            if (!this.rowsEqual(dht.remove(key), simpleHash.get(key))) {
                this.REPORT_FAILURE("  remove returned wrong value on key " + i);
            }
            simpleHash.remove(key);
            if (dht.get(key) == null) continue;
            this.REPORT_FAILURE("  remove did not delete key " + i);
        }
        this.testElements(removeDups, dht, keyCols, 0, rows, simpleHash, isDuplicate, found);
        this.testLargeTable(dht, keyCols, rows[0]);
        dht.close();
    }

    private void testLargeTable(DiskHashtable dht, int[] keyCols, DataValueDescriptor[] aRow) throws StandardException {
        Object key;
        int key1Idx;
        int key0Idx;
        int key1Count = keyCols.length > 1 ? (int)Math.round(Math.sqrt(50000.0)) : 1;
        int key0Count = (50000 + key1Count - 1) / key1Count;
        Object[] row = new DataValueDescriptor[aRow.length];
        for (int i = 0; i < row.length; ++i) {
            row[i] = aRow[i].getClone();
        }
        block1: for (key0Idx = 0; key0Idx < key0Count; ++key0Idx) {
            row[keyCols[0]].setValue(key0Idx);
            for (key1Idx = 0; key1Idx < key1Count; ++key1Idx) {
                if (keyCols.length > 1) {
                    row[keyCols[1]].setValue(key1Idx);
                }
                if (dht.put(key = KeyHasher.buildHashKey((Object[])row, (int[])keyCols), row)) continue;
                this.REPORT_FAILURE("  put returned wrong value for key(" + key0Idx + "," + key1Idx + ")");
                key0Idx = key0Count;
                continue block1;
            }
        }
        block3: for (key0Idx = 0; key0Idx < key0Count; ++key0Idx) {
            row[keyCols[0]].setValue(key0Idx);
            for (key1Idx = 0; key1Idx < key1Count; ++key1Idx) {
                if (keyCols.length > 1) {
                    row[keyCols[1]].setValue(key1Idx);
                }
                if (this.rowsEqual(dht.get(key = KeyHasher.buildHashKey((Object[])row, (int[])keyCols)), row)) continue;
                this.REPORT_FAILURE("  large table get returned wrong value for key(" + key0Idx + "," + key1Idx + ")");
                key0Idx = key0Count;
                continue block3;
            }
        }
        BitSet found = new BitSet(key0Count * key1Count);
        Enumeration elements = dht.elements();
        while (elements.hasMoreElements()) {
            Object el = elements.nextElement();
            if (!(el instanceof DataValueDescriptor[])) {
                this.REPORT_FAILURE("  large table enumeration returned wrong element type");
                break;
            }
            DataValueDescriptor[] fetchedRow = (DataValueDescriptor[])el;
            int i = fetchedRow[keyCols[0]].getInt() * key1Count;
            if (keyCols.length > 1) {
                i += fetchedRow[keyCols[1]].getInt();
            }
            if (i >= key0Count * key1Count) {
                this.REPORT_FAILURE("  large table enumeration returned invalid element");
                break;
            }
            if (found.get(i)) {
                this.REPORT_FAILURE("  large table enumeration returned same element twice");
                break;
            }
            found.set(i);
        }
        for (int i = key0Count * key1Count - 1; i >= 0; --i) {
            if (found.get(i)) continue;
            this.REPORT_FAILURE("  large table enumeration missed at least one element");
            break;
        }
    }

    private void testElements(boolean removeDups, DiskHashtable dht, int[] keyCols, int rowCount, DataValueDescriptor[][] rows, HashMap simpleHash, boolean[] isDuplicate, boolean[] found) throws StandardException {
        for (int i = 0; i < rowCount; ++i) {
            found[i] = false;
        }
        Enumeration e = dht.elements();
        while (e.hasMoreElements()) {
            Object el = e.nextElement();
            if (el == null) {
                this.REPORT_FAILURE("  table enumeration returned a null element");
                return;
            }
            if (el instanceof DataValueDescriptor[]) {
                this.checkElement((DataValueDescriptor[])el, rowCount, rows, found);
                continue;
            }
            if (el instanceof Vector) {
                Vector v = (Vector)el;
                for (int i = 0; i < v.size(); ++i) {
                    this.checkElement((DataValueDescriptor[])v.get(i), rowCount, rows, found);
                }
                continue;
            }
            if (el != null) continue;
            this.REPORT_FAILURE("  table enumeration returned an incorrect element type");
            return;
        }
        for (int i = 0; i < rowCount; ++i) {
            if (removeDups && isDuplicate[i]) {
                if (!found[i]) continue;
                this.REPORT_FAILURE("  table enumeration did not remove duplicates");
                return;
            }
            if (found[i]) continue;
            this.REPORT_FAILURE("  table enumeration missed at least one element");
            return;
        }
    }

    private void checkElement(DataValueDescriptor[] fetchedRow, int rowCount, DataValueDescriptor[][] rows, boolean[] found) throws StandardException {
        for (int i = 0; i < rowCount; ++i) {
            if (!this.rowsEqual(fetchedRow, rows[i])) continue;
            if (found[i]) {
                this.REPORT_FAILURE("  table enumeration returned the same element twice");
                return;
            }
            found[i] = true;
            return;
        }
        this.REPORT_FAILURE("  table enumeration returned an incorrect element");
    }

    private boolean rowsEqual(Object r1, Object r2) throws StandardException {
        if (r1 == null) {
            return r2 == null;
        }
        if (r1 instanceof DataValueDescriptor[]) {
            DataValueDescriptor[] row2;
            DataValueDescriptor[] row1 = (DataValueDescriptor[])r1;
            if (r2 instanceof Vector) {
                Vector v2 = (Vector)r2;
                if (v2.size() != 1) {
                    return false;
                }
                row2 = (DataValueDescriptor[])v2.elementAt(0);
            } else if (r2 instanceof DataValueDescriptor[]) {
                row2 = (DataValueDescriptor[])r2;
            } else {
                return false;
            }
            if (row1.length != row2.length) {
                return false;
            }
            for (int i = 0; i < row1.length; ++i) {
                if (row1[i].compare(2, row2[i], true, true)) continue;
                return false;
            }
            return true;
        }
        if (r1 instanceof Vector) {
            if (!(r2 instanceof Vector)) {
                return false;
            }
            Vector v1 = (Vector)r1;
            Vector v2 = (Vector)r2;
            if (v1.size() != v2.size()) {
                return false;
            }
            for (int i = v1.size() - 1; i >= 0; --i) {
                if (this.rowsEqual(v1.elementAt(i), v2.elementAt(i))) continue;
                return false;
            }
            return true;
        }
        return r1.equals(r2);
    }
}

