/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.store;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import junit.framework.Assert;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;

public class StoreBaseTest
extends BaseJDBCTestCase {
    protected static final int SPACE_INFO_IS_INDEX = 0;
    protected static final int SPACE_INFO_NUM_ALLOC = 1;
    protected static final int SPACE_INFO_NUM_FREE = 2;
    protected static final int SPACE_INFO_NUM_UNFILLED = 3;
    protected static final int SPACE_INFO_PAGE_SIZE = 4;
    protected static final int SPACE_INFO_ESTIMSPACESAVING = 5;
    protected static final int SPACE_INFO_NUMCOLS = 6;

    public StoreBaseTest(String name) {
        super(name);
    }

    protected int[] getSpaceInfo(String schemaName, String tableName, boolean commit_xact) throws SQLException {
        String stmt_str = "select conglomeratename, isindex, numallocatedpages, numfreepages, numunfilledpages, pagesize, estimspacesaving from new com.pivotal.gemfirexd.internal.diag.SpaceTable('" + tableName + "') t where isindex = 0";
        PreparedStatement space_stmt = this.prepareStatement(stmt_str);
        ResultSet rs = space_stmt.executeQuery();
        boolean rows_found = rs.next();
        Assert.assertTrue((String)("No rows returned from space table query on table: " + schemaName + "." + tableName), (boolean)rows_found);
        int[] ret_info = new int[6];
        String conglomerate_name = rs.getString(1);
        for (int i = 0; i < 6; ++i) {
            ret_info[i] = rs.getInt(i + 2);
        }
        rows_found = rs.next();
        Assert.assertFalse((String)("More than one row returned from space query on table: " + schemaName + "." + tableName), (boolean)rows_found);
        StoreBaseTest.println("Space information for " + schemaName + "." + tableName + ":");
        StoreBaseTest.println("isindex = " + ret_info[0]);
        StoreBaseTest.println("num_alloc = " + ret_info[1]);
        StoreBaseTest.println("num_free = " + ret_info[2]);
        StoreBaseTest.println("num_unfilled = " + ret_info[3]);
        StoreBaseTest.println("page_size = " + ret_info[4]);
        StoreBaseTest.println("estimspacesaving = " + ret_info[5]);
        rs.close();
        if (commit_xact) {
            this.commit();
        }
        return ret_info;
    }
}

