/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.store;

import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.tools.JDBCDisplayUtil;
import java.io.PrintStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.derbyTesting.functionTests.util.TestUtil;

public class ReEncryptCrashRecovery {
    private static final String TEST_REENCRYPT_PWD_DATABASE = "wombat_pwd_ren";
    private static final String TEST_ENCRYPT_PWD_DATABASE = "wombat_pwd_en";
    private static final String TEST_REENCRYPT_KEY_DATABASE = "wombat_key_ren";
    private static final String TEST_ENCRYPT_KEY_DATABASE = "wombat_key_en";
    private static final int USING_KEY = 1;
    private static final int USING_PASSWORD = 2;
    private static final int NONE = 1;
    private static final int OLD = 2;
    private static final int NEW = 3;
    private static final String TEST_TABLE_NAME = "emp";
    private static final String OLD_PASSWORD = "xyz1234abc";
    private static final String NEW_PASSWORD = "new1234xyz";
    private static final String OLD_KEY = "6162636465666768";
    private static final String NEW_KEY = "5666768616263646";
    private String currentTestDatabase;
    private int encryptionType;
    private boolean verbose = false;
    public static final String TEST_REENCRYPT_CRASH_BEFORE_COMMT = "TEST_REENCRYPT_CRASH_BEFORE_COMMT";
    public static final String TEST_REENCRYPT_CRASH_AFTER_COMMT = "TEST_REENCRYPT_CRASH_AFTER_COMMT";
    public static final String TEST_REENCRYPT_CRASH_AFTER_SWITCH_TO_NEWKEY = "TEST_REENCRYPT_CRASH_AFTER_SWITCH_TO_NEWKEY";
    public static final String TEST_REENCRYPT_CRASH_AFTER_CHECKPOINT = "TEST_REENCRYPT_CRASH_AFTER_CHECKPOINT";
    public static final String TEST_REENCRYPT_CRASH_AFTER_RECOVERY_UNDO_LOGFILE_DELETE = "TEST_REENCRYPT_CRASH_AFTER_RECOVERY_UNDO_LOGFILE_DELETE";
    public static final String TEST_REENCRYPT_CRASH_AFTER_RECOVERY_UNDO_REVERTING_KEY = "TEST_REENCRYPT_CRASH_AFTER_RECOVERY_UNDO_REVERTING_KEY";
    public static final String TEST_REENCRYPT_CRASH_BEFORE_RECOVERY_FINAL_CLEANUP = "TEST_REENCRYPT_CRASH_BEFORE_RECOVERY_FINAL_CLEANUP";

    ReEncryptCrashRecovery() {
    }

    private void runTest() throws Exception {
        this.logMessage("Begin  ReEncryptCrashRecovery Test");
        if (this.verbose) {
            this.logMessage("Start testing re-encryption with Password");
        }
        this.currentTestDatabase = TEST_REENCRYPT_PWD_DATABASE;
        this.encryptionType = 2;
        this.runCrashRecoveryTestCases(true);
        if (this.verbose) {
            this.logMessage("Start Testing encryption with Password");
        }
        this.currentTestDatabase = TEST_ENCRYPT_PWD_DATABASE;
        this.encryptionType = 2;
        this.runCrashRecoveryTestCases(false);
        if (this.verbose) {
            this.logMessage("Start Testing Encryption with external Key");
        }
        this.currentTestDatabase = TEST_ENCRYPT_KEY_DATABASE;
        this.encryptionType = 1;
        this.runCrashRecoveryTestCases(false);
        if (this.verbose) {
            this.logMessage("Start Testing re-encryption with external Key");
        }
        this.currentTestDatabase = TEST_REENCRYPT_KEY_DATABASE;
        this.encryptionType = 1;
        this.runCrashRecoveryTestCases(true);
        this.logMessage("End ReEncryptCrashRecovery Test");
    }

    private void runCrashRecoveryTestCases(boolean reEncrypt) throws SQLException {
        Connection conn = reEncrypt ? this.createEncryptedDatabase() : this.createDatabase();
        this.createTable(conn, TEST_TABLE_NAME);
        this.insert(conn, TEST_TABLE_NAME, 100);
        conn.commit();
        conn.close();
        this.shutdown();
        int passwordKey = reEncrypt ? 2 : 1;
        this.crash(reEncrypt, TEST_REENCRYPT_CRASH_BEFORE_COMMT);
        this.crash(reEncrypt, TEST_REENCRYPT_CRASH_AFTER_COMMT);
        this.crashInRecovery(passwordKey, TEST_REENCRYPT_CRASH_AFTER_RECOVERY_UNDO_LOGFILE_DELETE);
        this.crashInRecovery(passwordKey, TEST_REENCRYPT_CRASH_AFTER_RECOVERY_UNDO_REVERTING_KEY);
        this.crashInRecovery(passwordKey, TEST_REENCRYPT_CRASH_BEFORE_RECOVERY_FINAL_CLEANUP);
        this.crash(reEncrypt, TEST_REENCRYPT_CRASH_AFTER_COMMT);
        this.crashInRecovery(passwordKey, TEST_REENCRYPT_CRASH_AFTER_RECOVERY_UNDO_LOGFILE_DELETE);
        this.crash(reEncrypt, TEST_REENCRYPT_CRASH_AFTER_COMMT);
        this.crash(reEncrypt, TEST_REENCRYPT_CRASH_AFTER_SWITCH_TO_NEWKEY);
        this.crashInRecovery(passwordKey, TEST_REENCRYPT_CRASH_AFTER_RECOVERY_UNDO_LOGFILE_DELETE);
        this.crashInRecovery(passwordKey, TEST_REENCRYPT_CRASH_AFTER_RECOVERY_UNDO_REVERTING_KEY);
        this.crashInRecovery(passwordKey, TEST_REENCRYPT_CRASH_BEFORE_RECOVERY_FINAL_CLEANUP);
        this.crash(reEncrypt, TEST_REENCRYPT_CRASH_AFTER_SWITCH_TO_NEWKEY);
        this.crashInRecovery(passwordKey, TEST_REENCRYPT_CRASH_AFTER_RECOVERY_UNDO_REVERTING_KEY);
        this.crash(reEncrypt, TEST_REENCRYPT_CRASH_AFTER_SWITCH_TO_NEWKEY);
        this.crashInRecovery(passwordKey, TEST_REENCRYPT_CRASH_BEFORE_RECOVERY_FINAL_CLEANUP);
        passwordKey = reEncrypt ? 3 : 2;
        this.crash(reEncrypt, TEST_REENCRYPT_CRASH_AFTER_CHECKPOINT);
        this.crashInRecovery(passwordKey, TEST_REENCRYPT_CRASH_BEFORE_RECOVERY_FINAL_CLEANUP);
        this.recover(passwordKey);
        this.shutdown();
    }

    private void crash(boolean reEncrypt, String debugFlag) {
        if (this.verbose) {
            this.logMessage("Testing : " + debugFlag);
        }
        this.setDebugFlag(debugFlag);
        SQLException sqle = null;
        try {
            if (reEncrypt) {
                Connection conn = this.reEncryptDatabase();
            } else {
                Connection conn = this.encryptDatabase();
            }
        }
        catch (SQLException se) {
            sqle = se;
        }
        this.verifyException(sqle, debugFlag);
        this.clearDebugFlag(debugFlag);
    }

    private void crashInRecovery(int passwordKey, String debugFlag) throws SQLException {
        if (this.verbose) {
            this.logMessage("Testing : " + debugFlag);
        }
        this.setDebugFlag(debugFlag);
        SQLException sqle = null;
        try {
            Connection connection = this.bootDatabase(passwordKey);
        }
        catch (SQLException se) {
            sqle = se;
        }
        this.verifyException(sqle, debugFlag);
        this.clearDebugFlag(debugFlag);
    }

    private void recover(int passwordKey) throws SQLException {
        Connection conn = this.bootDatabase(passwordKey);
        this.runConsistencyChecker(conn, TEST_TABLE_NAME);
        this.insert(conn, TEST_TABLE_NAME, 100);
        conn.commit();
        conn.close();
    }

    void setDebugFlag(String debugFlag) {
        SanityManager.DEBUG_SET((String)debugFlag);
    }

    void clearDebugFlag(String debugFlag) {
        SanityManager.DEBUG_CLEAR((String)debugFlag);
    }

    private void verifyException(SQLException sqle, String debugFlag) {
        boolean expectedExcepion = false;
        if (sqle != null) {
            String message;
            SQLException ne;
            if (sqle.getSQLState() != null && sqle.getSQLState().equals("XJ040") && (ne = sqle.getNextException()) != null && (message = ne.getMessage()).indexOf(debugFlag) != -1) {
                expectedExcepion = true;
            }
            if (!expectedExcepion) {
                this.dumpSQLException(sqle);
            }
        } else {
            this.logMessage("Did not crash at " + debugFlag);
        }
    }

    void createTable(Connection conn, String tableName) throws SQLException {
        Statement s = conn.createStatement();
        s.executeUpdate("CREATE TABLE " + tableName + "(id INT," + "name CHAR(200))");
        s.executeUpdate("create index " + tableName + "_id_idx on " + tableName + "(id)");
        s.close();
    }

    void runConsistencyChecker(Connection conn, String tableName) throws SQLException {
        Statement stmt = conn.createStatement();
        stmt.execute("values SYSCS_UTIL.CHECK_TABLE('APP',  'EMP')");
        this.select(conn, tableName);
    }

    void insert(Connection conn, String tableName, int rowCount) throws SQLException {
        int startId;
        PreparedStatement ps = conn.prepareStatement("INSERT INTO " + tableName + " VALUES(?,?)");
        for (int i = startId = this.findMax(conn, tableName); i < rowCount; ++i) {
            ps.setInt(1, i);
            ps.setString(2, "skywalker" + i);
            ps.executeUpdate();
        }
        ps.close();
        conn.commit();
    }

    private int findMax(Connection conn, String tableName) throws SQLException {
        Statement s = conn.createStatement();
        ResultSet rs = s.executeQuery("SELECT max(ID) from " + tableName);
        rs.next();
        int max = rs.getInt(1);
        rs.close();
        s.close();
        return max;
    }

    void select(Connection conn, String tableName) throws SQLException {
        Statement s = conn.createStatement();
        ResultSet rs = s.executeQuery("SELECT ID, name from " + tableName + " order by id");
        int count = 0;
        int id = 0;
        while (rs.next()) {
            int tid = rs.getInt(1);
            String name = rs.getString(2);
            if (name.equals("skywalker" + id) && tid != id) {
                this.logMessage("DATA IN THE TABLE IS NOT AS EXPECTED");
                this.logMessage("Got :ID=" + tid + " Name=:" + name);
                this.logMessage("Expected: ID=" + id + "Name=" + "skywalker" + id);
            }
            ++id;
            ++count;
        }
        rs.close();
        s.close();
        conn.commit();
    }

    private Connection createEncryptedDatabase() throws SQLException {
        String connAttrs = "";
        if (this.encryptionType == 2) {
            connAttrs = "create=true;dataEncryption=true;bootPassword=xyz1234abc";
        }
        if (this.encryptionType == 1) {
            connAttrs = "create=true;dataEncryption=true;encryptionKey=6162636465666768";
        }
        return TestUtil.getConnection(this.currentTestDatabase, connAttrs);
    }

    private Connection createDatabase() throws SQLException {
        return TestUtil.getConnection(this.currentTestDatabase, "create=true");
    }

    private Connection reEncryptDatabase() throws SQLException {
        String connAttrs = "";
        if (this.encryptionType == 2) {
            connAttrs = "bootPassword=xyz1234abc;newBootPassword=new1234xyz";
        }
        if (this.encryptionType == 1) {
            connAttrs = "encryptionKey=6162636465666768;newEncryptionKey=5666768616263646";
        }
        if (this.verbose) {
            this.logMessage("re-encrypting " + this.currentTestDatabase + " with " + connAttrs);
        }
        return TestUtil.getConnection(this.currentTestDatabase, connAttrs);
    }

    private Connection encryptDatabase() throws SQLException {
        String connAttrs = "";
        if (this.encryptionType == 2) {
            connAttrs = "dataEncryption=true;bootPassword=xyz1234abc";
        }
        if (this.encryptionType == 1) {
            connAttrs = "dataEncryption=true;encryptionKey=6162636465666768";
        }
        if (this.verbose) {
            this.logMessage("encrypting " + this.currentTestDatabase + " with " + connAttrs);
        }
        return TestUtil.getConnection(this.currentTestDatabase, connAttrs);
    }

    Connection bootDatabase(int passwordKey) throws SQLException {
        String connAttrs = "";
        if (this.encryptionType == 2) {
            if (passwordKey == 3) {
                connAttrs = "bootPassword=new1234xyz";
            } else if (passwordKey == 2) {
                connAttrs = "bootPassword=xyz1234abc";
            }
        }
        if (this.encryptionType == 1) {
            if (passwordKey == 3) {
                connAttrs = "encryptionKey=5666768616263646";
            } else if (passwordKey == 2) {
                connAttrs = "encryptionKey=6162636465666768";
            }
        }
        if (this.verbose) {
            this.logMessage("booting " + this.currentTestDatabase + " with " + connAttrs);
        }
        return TestUtil.getConnection(this.currentTestDatabase, connAttrs);
    }

    void shutdown() {
        block3: {
            if (this.verbose) {
                this.logMessage("Shutdown " + this.currentTestDatabase);
            }
            try {
                TestUtil.getConnection(this.currentTestDatabase, "shutdown=true");
            }
            catch (SQLException se) {
                if (se.getSQLState() != null && se.getSQLState().equals("08006")) break block3;
                this.dumpSQLException(se);
            }
        }
    }

    private void dumpSQLException(SQLException sqle) {
        JDBCDisplayUtil.ShowSQLException((PrintStream)System.out, (SQLException)sqle);
        sqle.printStackTrace(System.out);
    }

    void logMessage(String str) {
        System.out.println(str);
    }

    public static void main(String[] argv) throws Throwable {
        ReEncryptCrashRecovery test = new ReEncryptCrashRecovery();
        try {
            test.runTest();
        }
        catch (SQLException sqle) {
            JDBCDisplayUtil.ShowSQLException((PrintStream)System.out, (SQLException)sqle);
            sqle.printStackTrace(System.out);
        }
    }
}

