/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.store;

import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.Properties;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.JDBCClient;
import org.apache.derbyTesting.junit.SystemPropertyTestSetup;
import org.apache.derbyTesting.junit.TestConfiguration;

public class BootAllTest
extends BaseJDBCTestCase {
    public static Test suite() {
        TestSuite suite = new TestSuite("BootAllTest");
        if (JDBC.vmSupportsJDBC2()) {
            TestSuite db3 = new TestSuite("db3");
            db3.addTest((Test)new BootAllTest("createShutdownDatabase"));
            db3.addTest((Test)new BootAllTest("shutdownDerby"));
            Properties ba = new Properties();
            ba.setProperty("gemfirexd.system.bootAll", "true");
            db3.addTest((Test)new SystemPropertyTestSetup((Test)new BootAllTest("testSettingBootAllPropertyWithHomePropertySet"), ba));
            TestSuite db2 = new TestSuite("db2");
            db2.addTest((Test)new BootAllTest("createShutdownDatabase"));
            db2.addTest((Test)TestConfiguration.singleUseDatabaseDecorator((Test)db3));
            TestSuite db1 = new TestSuite("db1");
            db1.addTest((Test)new BootAllTest("createShutdownDatabase"));
            db1.addTest((Test)TestConfiguration.singleUseDatabaseDecorator((Test)db2));
            suite.addTest((Test)new BootAllTest("createShutdownDatabase"));
            suite.addTest((Test)TestConfiguration.singleUseDatabaseDecorator((Test)db1));
        }
        return suite;
    }

    public BootAllTest(String name) {
        super(name);
    }

    public void createShutdownDatabase() throws SQLException {
        this.getConnection().close();
        this.getTestConfiguration().shutdownDatabase();
    }

    public void shutdownDerby() {
        this.getTestConfiguration().shutdownEngine();
        System.runFinalization();
        System.gc();
    }

    public void testSettingBootAllPropertyWithHomePropertySet() throws Exception {
        JDBCClient embedded = this.getTestConfiguration().getJDBCClient();
        String driverName = embedded.getJDBCDriverName();
        String url = embedded.getUrlBase();
        try {
            DriverManager.getDriver(url);
            BootAllTest.fail((String)"Derby is booted!");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        Class.forName(driverName).newInstance();
        Driver driver = DriverManager.getDriver(url);
        DriverPropertyInfo[] attributes = driver.getPropertyInfo(url, null);
        String[] returnedDatabases = null;
        for (int i = 0; i < attributes.length; ++i) {
            if (!attributes[i].name.equalsIgnoreCase("databaseName")) continue;
            returnedDatabases = attributes[i].choices;
        }
        BootAllTest.assertNotNull(returnedDatabases);
        BootAllTest.assertEquals((String)"Did not expect any databaseName", (int)0, (int)returnedDatabases.length);
    }
}

