/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.store;

import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.tools.JDBCDisplayUtil;
import com.pivotal.gemfirexd.internal.tools.ij;
import java.io.PrintStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public abstract class BaseTest {
    private static boolean debug_system_procedures_created = false;
    protected static boolean verbose = false;
    protected static final int SPACE_INFO_IS_INDEX = 0;
    protected static final int SPACE_INFO_NUM_ALLOC = 1;
    protected static final int SPACE_INFO_NUM_FREE = 2;
    protected static final int SPACE_INFO_NUM_UNFILLED = 3;
    protected static final int SPACE_INFO_PAGE_SIZE = 4;
    protected static final int SPACE_INFO_ESTIMSPACESAVING = 5;
    protected static final int SPACE_INFO_NUMCOLS = 6;

    public abstract void testList(Connection var1) throws SQLException;

    void runTests(String[] argv) throws Throwable {
        ij.getPropertyArg((String[])argv);
        Connection conn = ij.startJBMS();
        System.out.println("conn from ij.startJBMS() = " + conn);
        conn.setAutoCommit(false);
        try {
            this.testList(conn);
        }
        catch (SQLException sqle) {
            JDBCDisplayUtil.ShowSQLException((PrintStream)System.out, (SQLException)sqle);
            sqle.printStackTrace(System.out);
        }
    }

    protected void beginTest(Connection conn, String str) throws SQLException {
        this.log("Beginning test: " + str);
        conn.commit();
    }

    protected void testProgress(String str) throws SQLException {
        this.log("Executing test: " + str);
    }

    protected void endTest(Connection conn, String str) throws SQLException {
        conn.commit();
        this.log("Ending test: " + str);
    }

    protected void log(String str) {
        System.out.println(str);
    }

    protected void logError(String str) {
        System.out.println("ERROR: " + str);
    }

    public void executeQuery(Connection conn, String stmt_str, boolean commit_query) throws SQLException {
        Statement stmt = conn.createStatement();
        stmt.executeUpdate(stmt_str);
        stmt.close();
        if (commit_query) {
            conn.commit();
        }
    }

    protected boolean checkConsistency(Connection conn, String schemaName, String tableName) throws SQLException {
        Statement s = conn.createStatement();
        ResultSet rs = s.executeQuery("values SYSCS_UTIL.CHECK_TABLE('" + schemaName + "', '" + tableName + "')");
        if (!rs.next()) {
            SanityManager.THROWASSERT((String)"no value from values clause.");
        }
        boolean consistent = rs.getBoolean(1);
        rs.close();
        conn.commit();
        return consistent;
    }

    protected boolean checkAllConsistency(Connection conn) throws SQLException {
        Statement s = conn.createStatement();
        ResultSet rs = s.executeQuery("select schemaname, tablename, SYSCS_UTIL.CHECK_TABLE(schemaname, tablename) from sys.systables a,  sys.sysschemas b where a.schemaid = b.schemaid");
        int table_count = 0;
        while (rs.next()) {
            ++table_count;
            if (rs.getInt(3) == 1) continue;
            System.out.println("Bad return from consistency check of " + rs.getString(1) + "." + rs.getString(2));
        }
        if (table_count < 5) {
            System.out.println("Something wrong with consistency check query, found only " + table_count + " tables.");
        }
        rs.close();
        s.close();
        conn.commit();
        return true;
    }

    protected void createDebugSystemProcedures(Connection conn) throws SQLException {
        Statement s = conn.createStatement();
        s.executeUpdate("CREATE FUNCTION D_CONGLOMID_PRINT(DBNAME VARCHAR(128), CONGLOMID INT) RETURNS VARCHAR(32000) RETURNS NULL ON NULL INPUT EXTERNAL NAME 'com.pivotal.gemfirexd.internal.impl.store.raw.data.D_DiagnosticUtil.diag_conglomid' LANGUAGE JAVA PARAMETER STYLE JAVA");
        s.executeUpdate("CREATE FUNCTION DIAG_CONGLOMID(DBNAME VARCHAR(128), CONGLOMID INT) RETURNS VARCHAR(32000) RETURNS NULL ON NULL INPUT EXTERNAL NAME 'com.pivotal.gemfirexd.internal.impl.store.raw.data.D_DiagnosticUtil.diag_conglomid' LANGUAGE JAVA PARAMETER STYLE JAVA");
        s.close();
        conn.commit();
        debug_system_procedures_created = true;
    }

    String dump_table(Connection conn, String schemaName, String tableName, boolean commit_transaction) throws SQLException {
        if (!debug_system_procedures_created) {
            this.createDebugSystemProcedures(conn);
        }
        PreparedStatement ps = conn.prepareStatement("select sys.systables.tablename, sys.sysconglomerates.conglomeratenumber, DIAG_CONGLOMID('wombat', conglomeratenumber) from sys.systables, sys.sysconglomerates where sys.systables.tableid = sys.sysconglomerates.tableid and sys.systables.schemaid = sys.sysconglomerates.schemaid and sys.systables.tablename = ?");
        ps.setString(1, tableName);
        ResultSet rs = ps.executeQuery();
        if (!rs.next()) {
            SanityManager.THROWASSERT((String)"no value from values clause.");
        }
        String dump_table_info = rs.getString(3);
        rs.close();
        if (commit_transaction) {
            conn.commit();
        }
        return dump_table_info;
    }

    protected String get_lock_info(Connection conn, boolean include_system_locks) throws SQLException {
        String lock_query = "select cast(l.xid as char(8)) as xid, cast(username as char(8)) as username, cast(t.type as char(8)) as trantype, cast(l.type as char(8)) as type, cast(lockcount as char(3)) as cnt, cast(mode as char(4)) as mode, cast(tablename as char(12)) as tabname, cast(lockname as char(10)) as lockname, state, status from SYSCS_DIAG.LOCK_TABLE l right outer join SYSCS_DIAG.LOCK_TABLE t on l.xid = t.xid where l.tableType <> 'S' ";
        if (!include_system_locks) {
            lock_query = lock_query + "and t.type='UserTransaction' ";
        }
        lock_query = lock_query + "order by tabname, type desc, mode, cnt, lockname";
        PreparedStatement ps = conn.prepareStatement(lock_query);
        ResultSet rs = ps.executeQuery();
        String lock_output = "xid     |username|trantype|type    |cnt|mode|tabname     |lockname  |state|status\n---------------------------------------------------------------------------------\n";
        while (rs.next()) {
            String username = rs.getString(1);
            String trantype = rs.getString(2);
            String type = rs.getString(3);
            String lockcount = rs.getString(4);
            String mode = rs.getString(5);
            String tabname = rs.getString(6);
            String lockname = rs.getString(7);
            String state = rs.getString(8);
            String status = rs.getString(9);
            lock_output = lock_output + username + "|" + trantype + "|" + type + "|" + lockcount + "|" + mode + "|" + tabname + "|" + lockname + "|" + state + "|" + status + "\n";
        }
        rs.close();
        return lock_output;
    }

    public void createTable(Connection conn, String tbl_name, String create_str) throws SQLException {
        Statement stmt = conn.createStatement();
        try {
            stmt.executeUpdate("drop table " + tbl_name);
        }
        catch (Exception exception) {
            // empty catch block
        }
        stmt.executeUpdate(create_str);
    }

    protected int[] getSpaceInfo(Connection conn, String schemaName, String tableName, boolean commit_xact) throws SQLException {
        String stmt_str = "select conglomeratename, isindex, numallocatedpages, numfreepages, numunfilledpages, pagesize, estimspacesaving from new com.pivotal.gemfirexd.internal.diag.SpaceTable('" + tableName + "') t where isindex = 0";
        PreparedStatement space_stmt = conn.prepareStatement(stmt_str);
        ResultSet rs = space_stmt.executeQuery();
        if (!rs.next()) {
            SanityManager.THROWASSERT((String)("No rows returned from space table query on table: " + schemaName + "." + tableName));
        }
        int[] ret_info = new int[6];
        String conglomerate_name = rs.getString(1);
        for (int i = 0; i < 6; ++i) {
            ret_info[i] = rs.getInt(i + 2);
        }
        if (rs.next()) {
            SanityManager.THROWASSERT((String)("More than one row returned from space query on table: " + schemaName + "." + tableName));
        }
        if (verbose) {
            System.out.println("Space information for " + schemaName + "." + tableName + ":");
            System.out.println("isindex = " + ret_info[0]);
            System.out.println("num_alloc = " + ret_info[1]);
            System.out.println("num_free = " + ret_info[2]);
            System.out.println("num_unfilled = " + ret_info[3]);
            System.out.println("page_size = " + ret_info[4]);
            System.out.println("estimspacesaving = " + ret_info[5]);
        }
        rs.close();
        if (commit_xact) {
            conn.commit();
        }
        return ret_info;
    }

    protected int total_pages(int[] space_info) {
        return space_info[2] + space_info[1];
    }
}

