/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.replicationTests;

import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.apache.derbyTesting.functionTests.tests.replicationTests.ClientRunner;
import org.apache.derbyTesting.functionTests.tests.replicationTests.ReplicationRun;
import org.apache.derbyTesting.junit.TestConfiguration;

public class TestPreStartedMaster
extends ClientRunner {
    public TestPreStartedMaster(String testcaseName) {
        super(testcaseName);
    }

    public static Test suite() throws Exception {
        System.out.println("**** TestPreStartedMaster.suite()");
        TestPreStartedMaster.initEnvironment();
        TestSuite suite = new TestSuite("TestPreStartedMaster");
        suite.addTest(TestPreStartedMaster.suite(masterServerHost, masterServerPort));
        System.out.println("*** Done suite.addTest(TestPreStartedMaster.suite())");
        return suite;
    }

    public static Test suite(String serverHost, int serverPort) {
        System.out.println("*** TestPreStartedMaster.suite(serverHost,serverPort)");
        Test t = TestConfiguration.existingServerSuite(TestPreStartedMaster.class, false, serverHost, serverPort);
        System.out.println("*** Done TestConfiguration.existingServerSuite(TestPreStartedMaster.class,false,serverHost,serverPort)");
        return t;
    }

    public void testStartMasterConnect_OK() throws SQLException, IOException, InterruptedException {
        String msg;
        String ss;
        int ec;
        System.out.println("**** TestPreStartedMaster.testStartMasterConnect_OK() " + this.getTestConfiguration().getJDBCClient().getJDBCDriverName());
        Connection conn = null;
        String db = masterDatabasePath + "/" + ReplicationRun.masterDbSubPath + "/" + replicatedDb;
        String connectionURL = "jdbc:derby://" + masterServerHost + ":" + masterServerPort + "/" + db + ";startMaster=true" + ";slaveHost=" + slaveServerHost + ";slavePort=" + slaveReplPort;
        System.out.println(connectionURL);
        try {
            conn = DriverManager.getConnection(connectionURL);
            System.out.println("1. startMaster Successfully connected as: " + connectionURL);
        }
        catch (SQLException se) {
            int ec2 = se.getErrorCode();
            String ss2 = se.getSQLState();
            String msg2 = ec2 + " " + ss2 + " " + se.getMessage();
            System.out.println(msg2);
            throw se;
        }
        System.out.println("2. startMaster attempt should fail on: " + connectionURL);
        System.out.println("********************'' 2. CURRENTLY HANGS!!!! Skipping.");
        try {
            conn = DriverManager.getConnection(connectionURL);
            System.out.println("2. Unexpectedly connected as: " + connectionURL);
            TestPreStartedMaster.assertTrue((String)("2. Unexpectedly connected as: " + connectionURL), (boolean)false);
        }
        catch (SQLException se) {
            ec = se.getErrorCode();
            ss = se.getSQLState();
            msg = ec + " " + ss + " " + se.getMessage();
            System.out.println("2. startMaster No connection as expected: " + msg);
            TestPreStartedMaster.assertSQLState("2. startMaster Unexpected SQLException: " + msg, "XJ004", se);
        }
        db = slaveDatabasePath + "/" + ReplicationRun.slaveDbSubPath + "/" + replicatedDb;
        connectionURL = "jdbc:derby://" + slaveServerHost + ":" + slaveServerPort + "/" + db + ";startSlave=true" + ";slaveHost=" + slaveServerHost + ";slavePort=" + slaveReplPort;
        System.out.println(connectionURL);
        try {
            conn = DriverManager.getConnection(connectionURL);
            System.out.println("2. startSlave Unexpectedly connected as: " + connectionURL);
            TestPreStartedMaster.assertTrue((String)("2. startSlave Unexpectedly connected as: " + connectionURL), (boolean)false);
        }
        catch (SQLException se) {
            ec = se.getErrorCode();
            ss = se.getSQLState();
            msg = ec + " " + ss + " " + se.getMessage();
            System.out.println("2. startSlave No connection as expected: " + msg);
            TestPreStartedMaster.assertSQLState("2. startSlave Unexpected SQLException: " + msg, "XRE09", se);
        }
    }

    public void verifyTestStartMasterConnect_OK() throws SQLException, IOException, InterruptedException {
    }
}

