/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.replicationTests;

import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.derbyTesting.functionTests.tests.replicationTests.ReplicationRun;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;

public class ShutdownSlave
extends BaseJDBCTestCase {
    private static ReplicationRun repRun = new ReplicationRun("ShutdownSlave");
    static String jvmVersion = null;
    static String derbyVersion = null;
    static String slaveServerHost = null;
    static int slaveServerPort = -1;
    static String slaveDatabasePath = null;
    static String masterServerHost = null;
    static int masterServerPort = -1;
    static String masterDatabasePath = null;

    public ShutdownSlave(String testcaseName) {
        super(testcaseName);
    }

    static void setEnv() throws Exception {
        repRun.initEnvironment();
        masterServerHost = ReplicationRun.masterServerHost;
        masterServerPort = ReplicationRun.masterServerPort;
        slaveServerHost = ReplicationRun.slaveServerHost;
        slaveServerPort = ReplicationRun.slaveServerPort;
        jvmVersion = ReplicationRun.masterJvmVersion;
        derbyVersion = ReplicationRun.derbyMasterVersion;
        masterDatabasePath = ReplicationRun.masterDatabasePath;
        slaveDatabasePath = ReplicationRun.slaveDatabasePath;
    }

    void shutdown(String url, boolean dbOnly, boolean killServer) throws SQLException, IOException, InterruptedException {
        System.out.println("**** ShutdownSlave.shutdown() " + this.getTestConfiguration().getJDBCClient().getJDBCDriverName() + " " + url + " dbOnly: " + dbOnly + " killServer: " + killServer);
        Connection conn = this.getConnection();
        Statement s = conn.createStatement();
        s.executeUpdate("create table t (i integer primary key, vc varchar(20))");
        PreparedStatement pSt = this.prepareStatement("insert into t values (?,?)");
        for (int i = 0; i < 1000; ++i) {
            pSt.setInt(1, i);
            pSt.setString(2, "i" + i);
            pSt.execute();
            System.out.println("i: " + i);
            if (i != 500) continue;
            if (killServer) {
                repRun.killMaster(slaveServerHost, slaveServerPort);
                continue;
            }
            if (url == null) {
                repRun.stopServer(jvmVersion, derbyVersion, slaveServerHost, slaveServerPort);
                continue;
            }
            System.out.println("**** DriverManager.getConnection(\"" + url + ";shutdown=true\");");
            try {
                DriverManager.getConnection(url + ";shutdown=true");
                continue;
            }
            catch (SQLException se) {
                int errCode = se.getErrorCode();
                String msg = se.getMessage();
                String state = se.getSQLState();
                String expectedState = dbOnly ? "08004" : "XJ015";
                System.out.println("shutdown Got SQLException: " + errCode + " " + state + " " + msg);
                if (errCode == -1 && state.equalsIgnoreCase(expectedState)) {
                    System.out.println("As expected.");
                    continue;
                }
                throw se;
            }
        }
        ResultSet rs = s.executeQuery("select count(*) from t");
        rs.next();
        int count = rs.getInt(1);
        System.out.println("count: " + count);
    }
}

